/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;

public class IlvSemiTransparentLabel
extends JLabel {
    protected TexturePaint tp;
    protected boolean hasFocus;
    protected boolean paintSemiTransparency = true;

    public IlvSemiTransparentLabel() {
        this.setOpaque(false);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.paintSemiTransparency) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            graphics2D.setPaint(this.tp);
            graphics2D.fill(new Rectangle(0, 0, n, n2));
            if (this.hasFocus) {
                graphics2D.setColor(Color.gray);
                BasicStroke basicStroke = new BasicStroke(3.0f, 0, 0);
                graphics2D.setStroke(basicStroke);
                graphics2D.drawRect(0, 0, n - 1, n2 - 1);
            }
        }
        super.paintComponent(graphics);
    }

    @Override
    public void setBackground(Color color) {
        BasicStroke basicStroke = new BasicStroke(3.0f, 1, 1);
        color = this.setAlpha(color, 0.4f);
        super.setBackground(color);
        this.updateTexture();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.updateTexture();
    }

    protected Color setAlpha(Color color, float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Alpha value must be in the range [0,1]");
        }
        int n = (int)(f * 255.0f + 0.5f);
        if (color.getAlpha() == n) {
            return color;
        }
        return new Color(color.getRGB() & 0xFFFFFF | n << 24, true);
    }

    protected void updateTexture() {
        BufferedImage bufferedImage = this.createImage();
        this.tp = new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    protected BufferedImage createImage() {
        int n = 4;
        int n2 = 4;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        if (this.getBackground() != null) {
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        return bufferedImage;
    }
}

