/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.plaf.windows;

import ilog.views.appframe.swing.plaf.ComponentDecoratorManager;
import ilog.views.appframe.swing.plaf.IlvToolBarUI;
import ilog.views.appframe.swing.plaf.windows.ButtonDisabledIconHandler;
import ilog.views.appframe.swing.plaf.windows.WindowsXPButtonDecorator;
import ilog.views.appframe.swing.plaf.windows.WindowsXPUtils;
import ilog.views.appframe.swing.util.AbstractLookAndFeelInstaller;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.UIDefaults;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class WindowsXPToolBarUI
extends IlvToolBarUI {
    private Border a;
    private static Border b;

    public WindowsXPToolBarUI() {
        if (b == null) {
            b = new ToolBarBorder();
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.a = jComponent.getBorder();
        jComponent.setBorder(b);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.setBorder(this.a);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        WindowsXPToolBarUI windowsXPToolBarUI = new WindowsXPToolBarUI();
        return windowsXPToolBarUI;
    }

    @Override
    protected ComponentDecoratorManager createDecoratorManager(Container container) {
        ComponentDecoratorManager componentDecoratorManager = super.createDecoratorManager(container);
        componentDecoratorManager.addComponentDecorator(new ButtonDisabledIconHandler());
        componentDecoratorManager.addComponentDecorator(new WindowsXPButtonDecorator());
        return componentDecoratorManager;
    }

    @Override
    public boolean isRolloverBorders() {
        return true;
    }

    static {
        WindowsXPUtils.InitializeColors();
    }

    public static class Installer
    extends AbstractLookAndFeelInstaller {
        @Override
        public String getUIClassname() {
            return WindowsXPToolBarUI.class.getName();
        }

        @Override
        public void installDefaults(UIDefaults uIDefaults, LookAndFeel lookAndFeel) {
            this.putValue(uIDefaults, "ToolBar.background", WindowsXPUtils.TOOLBAR_BACKGROUND_COLOR);
        }
    }

    private static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(WindowsXPUtils.GRAYED_ICON_COLOR);
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    if (component.getComponentOrientation().isLeftToRight()) {
                        for (int i = 4; i < n4 - 5; i += 2) {
                            graphics.drawLine(2, i, 4, i);
                        }
                    } else {
                        for (int i = 4; i < n4 - 5; i += 2) {
                            graphics.drawLine(n3 - 4, i, n3 - 2, i);
                        }
                    }
                } else {
                    for (int i = 4; i < n3 - 5; i += 2) {
                        graphics.drawLine(i, 2, i, 4);
                    }
                }
            }
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(1, 1, 1, 1));
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    if (component.getComponentOrientation().isLeftToRight()) {
                        insets.left = 8;
                    } else {
                        insets.right = 8;
                    }
                } else {
                    insets.top = 7;
                }
            }
            return insets;
        }
    }
}

