/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.plaf.metal;

import ilog.views.appframe.swing.plaf.ButtonDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalButtonDecorator
extends ButtonDecorator {
    public static final ButtonBorder BUTTON_BORDER = new ButtonBorder();

    @Override
    public void installComponent(Component component) {
        AbstractButton abstractButton = (AbstractButton)component;
        abstractButton.setOpaque(false);
        abstractButton.setContentAreaFilled(false);
        super.installComponent(component);
    }

    @Override
    public void uninstallComponent(Component component) {
        AbstractButton abstractButton = (AbstractButton)component;
        super.uninstallComponent(component);
    }

    @Override
    protected Border createRolloverBorder() {
        return BUTTON_BORDER;
    }

    @Override
    public Object saveComponentProperties(Component component) {
        return new MetalButtonProperties((AbstractButton)component);
    }

    public static class ButtonBorder
    extends AbstractBorder {
        private Color a;
        private Color b;

        public ButtonBorder() {
            this.updateColors();
        }

        public void updateColors() {
            this.a = MetalLookAndFeel.getControlShadow();
            this.b = MetalLookAndFeel.getControlHighlight();
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                boolean bl;
                boolean bl2 = bl = buttonModel.isSelected() || buttonModel.isPressed() && buttonModel.isArmed();
                if (bl || buttonModel.isRollover()) {
                    Color color = graphics.getColor();
                    graphics.translate(n, n2);
                    graphics.setColor(bl ? this.a : this.b);
                    graphics.drawLine(0, 0, 0, n4 - 1);
                    graphics.drawLine(0, 0, n3 - 1, 0);
                    graphics.setColor(bl ? this.b : this.a);
                    graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
                    graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
                    graphics.translate(-n, -n2);
                    graphics.setColor(color);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(1, 1, 1, 1);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            boolean bl = buttonModel.isPressed() && buttonModel.isArmed();
            insets.top = bl ? 2 : 1;
            insets.left = bl ? 2 : 1;
            insets.bottom = 1;
            insets.right = 1;
            return insets;
        }
    }

    protected class MetalButtonProperties
    extends ButtonDecorator.ButtonProperties {
        private boolean a;
        private boolean b;

        public MetalButtonProperties(AbstractButton abstractButton) {
            super(abstractButton);
            this.a = abstractButton.isOpaque();
            this.b = abstractButton.isContentAreaFilled();
        }

        @Override
        public void restore(AbstractButton abstractButton) {
            super.restore(abstractButton);
            abstractButton.setContentAreaFilled(this.b);
            abstractButton.setOpaque(this.a);
        }
    }
}

