/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.settings.query;

import ilog.views.appframe.settings.IlvSettings;
import ilog.views.appframe.settings.query.AbstractNodeList;
import ilog.views.appframe.settings.query.IlvEvaluationContext;
import ilog.views.appframe.settings.query.IlvNumberUtil;
import ilog.views.appframe.settings.query.NodeListHandler;
import ilog.views.appframe.settings.query.ParseException;
import ilog.views.appframe.settings.query.XPathParser;
import java.io.StringReader;
import java.util.HashMap;
import java.util.ResourceBundle;

public class IlvXPathParser {
    protected XPathParser parser = null;
    protected HashMap functions = new HashMap(10);
    public static boolean Debug = false;
    protected boolean debug = Debug;

    public IlvXPathParser() {
        try {
            this.parser = new XPathParser(new StringReader(""));
            this.setDebug(this.debug);
        }
        catch (Exception exception) {
            System.out.println("XPath Parser exception: " + exception.getMessage());
            return;
        }
        this.initializeFunctions();
    }

    public AbstractNodeList evaluate(String string, AbstractNodeList abstractNodeList, NodeListHandler nodeListHandler, ResourceBundle resourceBundle) throws ParseException {
        this.parser.ReInit(new StringReader(string));
        this.parser.XPath();
        IlvEvaluationContext ilvEvaluationContext = new IlvEvaluationContext(abstractNodeList, nodeListHandler);
        if (resourceBundle != null) {
            ilvEvaluationContext.setTranslateLiterals(true);
            ilvEvaluationContext.setResourceBundle(resourceBundle);
        }
        ilvEvaluationContext.setFunctions(this.functions);
        this.parser.jjtree.c().evaluate(ilvEvaluationContext);
        return (AbstractNodeList)ilvEvaluationContext.getStackObject(0);
    }

    public AbstractNodeList evaluate(String string, IlvSettings ilvSettings, NodeListHandler nodeListHandler, ResourceBundle resourceBundle) throws ParseException {
        this.parser.ReInit(new StringReader(string));
        this.parser.XPath();
        IlvEvaluationContext ilvEvaluationContext = new IlvEvaluationContext(ilvSettings, nodeListHandler);
        if (resourceBundle != null) {
            ilvEvaluationContext.setTranslateLiterals(true);
            ilvEvaluationContext.setResourceBundle(resourceBundle);
        }
        ilvEvaluationContext.setFunctions(this.functions);
        this.parser.jjtree.c().evaluate(ilvEvaluationContext);
        return (AbstractNodeList)ilvEvaluationContext.getStackObject(0);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        if (bl) {
            this.parser.enable_tracing();
        } else {
            this.parser.disable_tracing();
        }
    }

    public void addFunction(String string, Function function) {
        this.functions.put(string, function);
    }

    public boolean removeFunction(String string) {
        return this.functions.remove(string) != null;
    }

    protected void initializeFunctions() {
        this.addFunction("last", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (ilvEvaluationContext.isEvaluatingPredicate()) {
                    return new Integer(ilvEvaluationContext.getContextSize());
                }
                return new Integer(-1);
            }
        });
        this.addFunction("position", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (ilvEvaluationContext.isEvaluatingPredicate() && ilvEvaluationContext.getContextNode() != null) {
                    return new Integer(ilvEvaluationContext.getContextPosition() + 1);
                }
                return new Integer(-1);
            }
        });
        this.addFunction("count", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length <= 0 || objectArray[0] == null || !(objectArray[0] instanceof AbstractNodeList)) {
                    return null;
                }
                return new Integer(((AbstractNodeList)objectArray[0]).getLength());
            }
        });
        this.addFunction("id", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new String("");
            }
        });
        this.addFunction("local-name", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new String("");
            }
        });
        this.addFunction("namespace-uri", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new String("");
            }
        });
        this.addFunction("name", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new String("");
            }
        });
        this.addFunction("concat", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length == 0) {
                    return new String("");
                }
                if (objectArray.length == 1) {
                    return objectArray[0];
                }
                String string = objectArray[0].toString();
                for (int i = 1; i < objectArray.length; ++i) {
                    string = string + objectArray[i].toString();
                }
                return string;
            }
        });
        this.addFunction("start-with", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 2) {
                    return Boolean.FALSE;
                }
                return new Boolean(objectArray[0].toString().startsWith(objectArray[1].toString()));
            }
        });
        this.addFunction("contains", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 2) {
                    return Boolean.FALSE;
                }
                return new Boolean(objectArray[0].toString().indexOf(objectArray[1].toString()) != -1);
            }
        });
        this.addFunction("substring-before", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length == 0) {
                    return new String("");
                }
                String string = objectArray[0].toString();
                if (objectArray.length == 1) {
                    return string;
                }
                int n = string.indexOf(objectArray[1].toString());
                return n == -1 ? string : string.substring(0, n);
            }
        });
        this.addFunction("substring-after", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length == 0) {
                    return new String("");
                }
                String string = objectArray[0].toString();
                if (objectArray.length == 1) {
                    return string;
                }
                int n = string.indexOf(objectArray[1].toString());
                return n == -1 ? string : string.substring(n + objectArray[1].toString().length());
            }
        });
        this.addFunction("substring", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length == 0) {
                    return new String("");
                }
                String string = objectArray[0].toString();
                if (objectArray.length == 1) {
                    return string;
                }
                int n = IlvNumberUtil.a(objectArray[1]) - 1;
                if (objectArray.length == 2) {
                    return string.substring(n);
                }
                return string.substring(n, IlvNumberUtil.a(objectArray[2]) - 1);
            }
        });
        this.addFunction("string-length", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                String string = objectArray.length == 0 ? ilvEvaluationContext.getContextNodeString() : objectArray[0].toString();
                return new Integer(string.length());
            }
        });
        this.addFunction("normalize-space", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                String string = objectArray.length == 0 ? ilvEvaluationContext.getContextNodeString() : objectArray[0].toString();
                int n = IlvXPathParser.this.skipWhites(string);
                if (n > 0) {
                    if (n == string.length()) {
                        return new String("");
                    }
                    string = string.substring(n);
                }
                n = 1;
                while (true) {
                    int n2;
                    if (n < string.length() && !IlvXPathParser.this.isWhite(string.charAt(n))) {
                        ++n;
                        continue;
                    }
                    if (n == string.length()) {
                        return string;
                    }
                    for (n2 = n + 1; n2 < string.length() && IlvXPathParser.this.isWhite(string.charAt(n2)); ++n2) {
                    }
                    if (n2 == string.length()) {
                        return string.substring(0, n);
                    }
                    if (++n >= (string = string.substring(0, n) + " " + string.substring(n2)).length()) break;
                }
                return string;
            }
        });
        this.addFunction("translate", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 2) {
                    return objectArray.length == 1 ? objectArray[0].toString() : new String("");
                }
                String string = "";
                String string2 = objectArray[0].toString();
                String string3 = objectArray[1].toString();
                String string4 = objectArray.length > 2 ? objectArray[2].toString() : "";
                int n = 0;
                for (int i = 0; i < string2.length(); ++i) {
                    int n2 = string3.indexOf(string2.charAt(i));
                    if (n2 != -1 && i > 0 && i > n) {
                        string = string + string2.substring(n, i);
                        n = i + 1;
                    }
                    if (n2 >= string4.length()) continue;
                    string = string + string4.charAt(n2);
                }
                if (n < string2.length()) {
                    string = string + string2.substring(n);
                }
                return string;
            }
        });
        this.addFunction("boolean", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 1) {
                    return Boolean.FALSE;
                }
                if (objectArray[0] instanceof AbstractNodeList) {
                    return new Boolean(((AbstractNodeList)objectArray[0]).getLength() > 0);
                }
                if (objectArray[0] instanceof String) {
                    return new Boolean(((String)objectArray[0]).length() > 0);
                }
                return new Boolean(IlvNumberUtil.b(objectArray[0]) != 0.0f);
            }
        });
        this.addFunction("not", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 1) {
                    return Boolean.TRUE;
                }
                return new Boolean(!IlvNumberUtil.c(objectArray[0]));
            }
        });
        this.addFunction("true", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return Boolean.TRUE;
            }
        });
        this.addFunction("false", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return Boolean.FALSE;
            }
        });
        this.addFunction("lang", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 1) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        this.addFunction("number", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                if (objectArray.length < 1 || objectArray[0] instanceof String) {
                    String string = objectArray.length == 0 ? ilvEvaluationContext.getContextNodeString() : (String)objectArray[0];
                    int n = IlvXPathParser.this.skipWhites(string);
                    if (n > 0) {
                        string = string.substring(n);
                    }
                    try {
                        return new Integer(Integer.parseInt(string));
                    }
                    catch (Exception exception) {
                        return new Integer(Integer.MIN_VALUE);
                    }
                }
                if (objectArray[0] instanceof Boolean) {
                    return new Integer((Boolean)objectArray[0] != false ? 1 : 0);
                }
                if (objectArray[0] instanceof AbstractNodeList) {
                    return null;
                }
                return new Integer(0);
            }
        });
        this.addFunction("sum", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new Integer(0);
            }
        });
        this.addFunction("floor", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new Integer(0);
            }
        });
        this.addFunction("ceiling", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new Integer(0);
            }
        });
        this.addFunction("round", new Function(){

            @Override
            public Object evaluate(IlvEvaluationContext ilvEvaluationContext, Object[] objectArray) {
                return new Integer(0);
            }
        });
    }

    protected final boolean isWhite(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    protected int skipWhites(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (this.isWhite(string.charAt(i))) continue;
            return i;
        }
        return string.length();
    }

    public static interface Function {
        public Object evaluate(IlvEvaluationContext var1, Object[] var2);
    }
}

