/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.form.wizard;

import ilog.views.appframe.form.IlvForm;
import ilog.views.appframe.form.IlvFormException;
import ilog.views.appframe.form.events.ValidationEvent;
import ilog.views.appframe.form.events.ValidationListener;
import ilog.views.appframe.form.internal.controller.IlvEditionContext;
import ilog.views.appframe.form.internal.controller.IlvFormController;
import ilog.views.appframe.form.services.IlvServicesProvider;
import ilog.views.appframe.form.swing.IlvSwingForm;
import ilog.views.appframe.form.swing.IlvSwingFormReader;
import ilog.views.appframe.form.wizard.IlvPanelWizardPage;
import java.awt.Container;
import java.net.URL;
import org.w3c.dom.Element;

public class IlvFormWizardPage
extends IlvPanelWizardPage {
    public static final String FORM_URL_PROPERTY = "FormURL";

    public IlvFormWizardPage(IlvServicesProvider ilvServicesProvider) {
        this.setServicesProvider(ilvServicesProvider);
    }

    public IlvFormWizardPage() {
    }

    @Override
    public void constructPage(IlvEditionContext ilvEditionContext) {
        IlvFormController ilvFormController;
        super.constructPage(ilvEditionContext);
        IlvForm ilvForm = this.getForm();
        if (ilvForm != null && (ilvFormController = IlvFormController.GetFormController(ilvForm)) != null) {
            ilvFormController.setFormModel(ilvEditionContext.getFormModel());
            ilvFormController.setEditionContext(ilvEditionContext);
            ilvFormController.addValidationListener(new ValidationListener(){

                @Override
                public void validationErrorAdded(ValidationEvent validationEvent) {
                    IlvFormWizardPage.this.setValid(false);
                }

                @Override
                public void validationErrorRemoved(ValidationEvent validationEvent) {
                    IlvFormWizardPage.this.setValid(validationEvent.getRemainingErrors() == null || validationEvent.getRemainingErrors().size() == 0);
                }
            });
        }
    }

    @Override
    public void initializePage(IlvEditionContext ilvEditionContext) {
        IlvFormController ilvFormController;
        super.initializePage(ilvEditionContext);
        IlvForm ilvForm = this.getForm();
        if (ilvForm != null && (ilvFormController = IlvFormController.GetFormController(ilvForm)) != null) {
            ilvFormController.initialize();
        }
    }

    public void read(Element element) {
        this.setTitle(element.getAttribute("title"));
        String string = element.getAttribute("description");
        if (string != null && string.length() == 0) {
            this.setDescription(string);
        }
    }

    public void readForm(URL uRL) throws IlvFormException {
        IlvSwingFormReader ilvSwingFormReader = new IlvSwingFormReader();
        IlvSwingForm ilvSwingForm = ilvSwingFormReader.readForm((Container)this, uRL, this.getServicesProvider());
        this.setProperty("form", ilvSwingForm);
        this.setProperty(FORM_URL_PROPERTY, uRL);
    }
}

