/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.docview;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.docview.IlvDocument;
import ilog.views.appframe.docview.IlvDocumentTemplate;
import ilog.views.appframe.docview.IlvDocumentView;
import ilog.views.appframe.event.ActionHandler;
import ilog.views.appframe.event.IlvActionHandlerArray;
import ilog.views.appframe.event.IlvMessageMapper;
import ilog.views.appframe.event.IlvSingleActionHandler;
import ilog.views.appframe.event.MessageEvent;
import ilog.views.appframe.util.IlvDefaultPropertyManager;
import ilog.views.appframe.util.IlvPropertyManager;
import ilog.views.appframe.util.IlvUtil;
import ilog.views.util.internal.IlvUndoManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public abstract class IlvAbstractDocument
implements IlvDocument {
    private IlvMessageMapper a;
    private Object[] b = null;
    private IlvUndoManager c = new DocumentUndoManager();
    private IlvPropertyManager d;
    private boolean e = false;
    private boolean f = false;
    private IlvActionHandlerArray g = new IlvActionHandlerArray();
    private PropertyChangeListener h;
    public static final String UNDO_CMD = "Undo";
    public static final String REDO_CMD = "Redo";

    public IlvAbstractDocument() {
        this.d = new IlvDefaultPropertyManager(this);
        this.d.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("DocumentTemplate")) {
                    IlvAbstractDocument.this.a((IlvDocumentTemplate)propertyChangeEvent.getNewValue(), (IlvDocumentTemplate)propertyChangeEvent.getOldValue());
                } else if (propertyChangeEvent.getPropertyName().equals("Application")) {
                    IlvAbstractDocument.this.f = true;
                    IlvAbstractDocument.this.setApplication((IlvApplication)propertyChangeEvent.getNewValue());
                    IlvAbstractDocument.this.f = false;
                }
            }
        });
        this.addActionHandler(new IlvSingleActionHandler(UNDO_CMD){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvAbstractDocument.this.undo();
                IlvAbstractDocument.this.c();
            }

            @Override
            protected boolean updateSingleAction(Action action) {
                IlvAbstractDocument.this.a(action);
                return true;
            }
        });
        this.addActionHandler(new IlvSingleActionHandler(REDO_CMD){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvAbstractDocument.this.redo();
                IlvAbstractDocument.this.c();
            }

            @Override
            protected boolean updateSingleAction(Action action) {
                IlvAbstractDocument.this.b(action);
                return true;
            }
        });
    }

    @Override
    public boolean initializeDocument(Object object) {
        this.a();
        this.c.discardAllEdits();
        this.c.setModified();
        return true;
    }

    @Override
    public void documentClosing() {
    }

    @Override
    public void documentClosed() {
    }

    @Override
    public void clean() {
        this.a();
        this.c.discardAllEdits();
        this.c.setUnmodified();
    }

    @Override
    public void activated(boolean bl) {
    }

    @Override
    public int getViewCount() {
        return this.b == null ? 0 : this.b.length;
    }

    @Override
    public boolean removeView(IlvDocumentView ilvDocumentView) {
        int n = IlvUtil.IndexOf(this.b, ilvDocumentView);
        if (n == -1) {
            return false;
        }
        this.b = IlvUtil.RemoveFromArray(this.b, n);
        IlvDocumentTemplate ilvDocumentTemplate = this.getDocumentTemplate();
        if (ilvDocumentTemplate != null) {
            ilvDocumentTemplate.updateViewContainerTitles(this);
        }
        return true;
    }

    @Override
    public void removeViews() {
        this.b = null;
    }

    @Override
    public void addView(IlvDocumentView ilvDocumentView) {
        int n = IlvUtil.IndexOf(this.b, ilvDocumentView);
        if (n != -1) {
            return;
        }
        this.b = IlvUtil.AddToArray(this.b, ilvDocumentView);
    }

    @Override
    public IlvDocumentView getView(int n) {
        return (IlvDocumentView)this.b[n];
    }

    public IlvDocumentView[] getViews() {
        int n = this.getViewCount();
        if (n == 0) {
            return null;
        }
        IlvDocumentView[] ilvDocumentViewArray = new IlvDocumentView[n];
        System.arraycopy(this.b, 0, ilvDocumentViewArray, 0, n);
        return ilvDocumentViewArray;
    }

    public IlvDocumentView getActiveView() {
        return this.getViewCount() != 0 ? this.getView(0) : null;
    }

    @Override
    public boolean isModified() {
        Boolean bl = (Boolean)this.getProperty("Modified");
        return bl == null ? false : bl;
    }

    @Override
    public void setModified(boolean bl) {
        if (this.isModified() != bl) {
            this.setProperty("Modified", bl ? Boolean.TRUE : Boolean.FALSE);
            if (!bl) {
                this.c.setUnmodified();
            }
        }
    }

    @Override
    public String getTitle() {
        return (String)this.getProperty("Title");
    }

    @Override
    public void setTitle(String string) {
        this.setProperty("Title", string);
    }

    @Override
    public IlvDocumentTemplate getDocumentTemplate() {
        return (IlvDocumentTemplate)this.d.getProperty("DocumentTemplate");
    }

    IlvMessageMapper a() {
        if (!this.e) {
            this.a = new IlvMessageMapper(this);
            this.registerMappings(this.a);
            this.g.addActionHandler(this.a);
            this.e = true;
        }
        return this.a;
    }

    @Override
    public boolean updateAction(Action action) {
        this.a();
        return this.g.updateAction(action);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.a();
        this.g.actionPerformed(actionEvent);
    }

    @Override
    public boolean isProcessingAction(String string) {
        this.a();
        return this.g.isProcessingAction(string);
    }

    protected void registerMappings(IlvMessageMapper ilvMessageMapper) {
    }

    public void addActionHandler(ActionHandler actionHandler) {
        this.g.addActionHandler(actionHandler);
    }

    public boolean removeActionHandler(ActionHandler actionHandler) {
        return this.g.removeActionHandler(actionHandler);
    }

    @Override
    public void receiveMessage(MessageEvent messageEvent) {
        this.a();
        this.a.receiveMessage(messageEvent);
    }

    private boolean a(Action action) {
        block5: {
            block2: {
                String string;
                block4: {
                    block3: {
                        if (!this.canUndo()) break block2;
                        action.setEnabled(true);
                        string = this.c.getUndoPresentationName();
                        if (string == null) break block3;
                        if (string.length() != 0) break block4;
                    }
                    string = "Action.Undo";
                }
                string = this.getApplication().getString(string);
                action.putValue("Name", string);
                action.putValue("ShortDescription", string);
                break block5;
            }
            action.setEnabled(false);
            String string = this.getApplication().getString("Action.CantUndo");
            action.putValue("Name", string);
            action.putValue("ShortDescription", string);
        }
        return true;
    }

    private boolean b(Action action) {
        block5: {
            block2: {
                String string;
                block4: {
                    block3: {
                        if (!this.canRedo()) break block2;
                        action.setEnabled(true);
                        string = this.c.getRedoPresentationName();
                        if (string == null) break block3;
                        if (string.length() != 0) break block4;
                    }
                    string = "Action.Redo";
                }
                action.putValue("Name", string);
                action.putValue("ShortDescription", string);
                break block5;
            }
            action.setEnabled(false);
            String string = this.getApplication().getString("Action.CantRedo");
            action.putValue("Name", string);
            action.putValue("ShortDescription", string);
        }
        return true;
    }

    private void c() {
        this.getApplication().updateAction(UNDO_CMD);
        this.getApplication().updateAction(REDO_CMD);
        this.updateModificationState();
    }

    public UndoManager getUndoManager() {
        return this.c;
    }

    public boolean canUndo() {
        return this.c.canUndo();
    }

    public void undo() {
        this.c.undo();
    }

    public boolean canRedo() {
        return this.c.canRedo();
    }

    public void redo() {
        this.c.redo();
    }

    public void addEdit(UndoableEdit undoableEdit) {
        this.c.addEdit(undoableEdit);
    }

    protected void updateModificationState() {
        if (this.isModified() != this.c.isModified()) {
            this.setModified(this.c.isModified());
        }
    }

    protected void notifyViews(String string, IlvDocumentView ilvDocumentView, Object[] objectArray) {
        if (this.b != null) {
            for (int i = 0; i < this.b.length; ++i) {
                if (this.b[i] == ilvDocumentView) continue;
                MessageEvent messageEvent = new MessageEvent(this, string, objectArray);
                ((IlvDocumentView)this.b[i]).receiveMessage(messageEvent);
            }
        }
    }

    @Override
    public Object setProperty(String string, Object object) {
        return this.d.setProperty(string, object);
    }

    @Override
    public Object getProperty(String string) {
        return this.d.getProperty(string);
    }

    IlvDocument b() {
        return this;
    }

    @Override
    public IlvApplication getApplication() {
        return (IlvApplication)this.getProperty("Application");
    }

    public void setApplication(IlvApplication ilvApplication) {
        if (!this.f) {
            this.setProperty("Application", ilvApplication);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.d.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.d.removePropertyChangeListener(propertyChangeListener);
    }

    public void attachDocument(IlvDocument ilvDocument, boolean bl) {
        Object[] objectArray = (Object[])this.getProperty("AttachedDocuments");
        objectArray = bl ? IlvUtil.AddToArray(objectArray, ilvDocument) : IlvUtil.RemoveFromArray(objectArray, ilvDocument);
        this.setProperty("AttachedDocuments", objectArray);
        ilvDocument.setProperty("DocumentOwner", bl ? this : null);
    }

    private void a(IlvDocumentTemplate ilvDocumentTemplate, IlvDocumentTemplate ilvDocumentTemplate2) {
        if (!this.f) {
            this.setProperty("DocumentTemplate", ilvDocumentTemplate);
            return;
        }
        if (ilvDocumentTemplate2 != null && this.h != null) {
            ilvDocumentTemplate2.removePropertyChangeListener(this.h);
        }
        if (ilvDocumentTemplate != null) {
            if (this.h == null) {
                this.h = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("undoLimit")) {
                            IlvAbstractDocument.this.a(propertyChangeEvent.getNewValue());
                        }
                    }
                };
            }
            ilvDocumentTemplate.addPropertyChangeListener(this.h);
            this.a(ilvDocumentTemplate.getProperty("undoLimit"));
        }
    }

    private void a(Object object) {
        if (object == null) {
            return;
        }
        int n = -1;
        if (object != null) {
            if (object instanceof String) {
                try {
                    n = Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    return;
                }
            } else if (object instanceof Integer) {
                n = (Integer)object;
            }
        }
        if (n == -1) {
            return;
        }
        if (n != this.c.getLimit()) {
            this.c.setLimit(n);
        }
    }

    private class DocumentUndoManager
    extends IlvUndoManager {
        private DocumentUndoManager() {
        }

        @Override
        public void undo() {
            super.undo();
            IlvAbstractDocument.this.c();
        }

        @Override
        public void redo() {
            super.redo();
            IlvAbstractDocument.this.c();
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            boolean bl = super.addEdit(undoableEdit);
            IlvAbstractDocument.this.c();
            return bl;
        }

        @Override
        public void discardAllEdits() {
            super.discardAllEdits();
            if (IlvAbstractDocument.this.getApplication() != null) {
                IlvAbstractDocument.this.c();
            }
        }
    }
}

