/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicFilter;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.io.Serializable;

public final class IlvQuadtree
implements Serializable {
    private IlvQuadtree a;
    private IlvQuadtree b;
    private IlvQuadtree c;
    private IlvQuadtree d;
    private IlvGraphic[] e;
    private int f;
    private boolean g;
    private int h = 30;
    private double i;
    private double j;
    private double k;
    private double l;
    private IlvRect m;
    private boolean n;
    private IlvQuadtree o;
    private static final int p = 1;
    private static final int q = 2;
    private static final int r = 4;
    private static final int s = 8;
    private static final int t = 5;
    private static final int u = 6;
    private static final int v = 9;
    private static final int w = 10;
    private static final int x = 65535;
    static final double y = 1.0E-5;
    private static boolean z = true;
    private static final double aa = 10000.0;

    IlvQuadtree(int n) {
        this.h = n;
        this.i = -10000.0;
        this.j = -10000.0;
        this.k = 20000.0;
        this.l = 20000.0;
    }

    private IlvQuadtree(IlvQuadtree ilvQuadtree, int n) {
        this(n);
        this.o = ilvQuadtree;
    }

    private IlvQuadtree(IlvQuadtree ilvQuadtree, int n, double d, double d2, double d3, double d4) {
        this.h = n;
        this.i = d;
        this.j = d2;
        this.k = d3;
        this.l = d4;
        this.o = ilvQuadtree;
    }

    private IlvQuadtree(IlvQuadtree ilvQuadtree) {
        this.a = ilvQuadtree.a;
        this.b = ilvQuadtree.b;
        this.c = ilvQuadtree.c;
        this.d = ilvQuadtree.d;
        if (this.a != null) {
            this.a.o = this;
        }
        if (this.b != null) {
            this.b.o = this;
        }
        if (this.c != null) {
            this.c.o = this;
        }
        if (this.d != null) {
            this.d.o = this;
        }
        this.e = ilvQuadtree.e;
        this.f = ilvQuadtree.f;
        this.g = ilvQuadtree.g;
        this.h = ilvQuadtree.h;
        this.i = ilvQuadtree.i;
        this.j = ilvQuadtree.j;
        this.k = ilvQuadtree.k;
        this.l = ilvQuadtree.l;
        this.n = false;
        this.m = null;
        this.o = ilvQuadtree;
    }

    private IlvQuadtree d() {
        return this.o;
    }

    public static boolean isOptimizeMode() {
        return z;
    }

    public static void setOptimizeMode(boolean bl) {
        z = bl;
    }

    void a(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        if (ilvRect == null) {
            ilvRect = ilvGraphic.boundingBox(null);
        }
        if (!z) {
            if (Float.isNaN(ilvRect.x) || Float.isInfinite(ilvRect.x) || Float.isNaN(ilvRect.y) || Float.isInfinite(ilvRect.y) || Float.isNaN(ilvRect.width) || Float.isInfinite(ilvRect.width) || Float.isNaN(ilvRect.height) || Float.isInfinite(ilvRect.height)) {
                throw new RuntimeException("IlvQuadtree.add: " + ilvGraphic + " Invalid coordinates, obj.bbox=" + ilvRect);
            }
            if (this.o != null) {
                throw new RuntimeException("IlvQuadtree.add: " + ilvGraphic + " Call not allowed for non-root cells");
            }
            if (this.b(ilvGraphic, ilvRect) != null) {
                throw new RuntimeException("IlvQuadtree.add: " + ilvGraphic + " Already in quadtree");
            }
        }
        if (!this.c(ilvRect)) {
            if (this.g) {
                this.b(ilvRect);
            } else {
                this.f(ilvRect);
            }
        }
        this.c(ilvGraphic, ilvRect);
        if (!z) {
            IlvQuadtree ilvQuadtree = ilvGraphic.l();
            if (ilvQuadtree == null) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Backpointer cannot be null after update");
            }
            if (!ilvQuadtree.c(ilvGraphic)) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Backpointer cell does not contain the object");
            }
        }
    }

    private void c(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        if (!z && !this.c(ilvRect)) {
            String string = null;
            if (this == this.o.b) {
                string = "top right";
            } else if (this == this.o.a) {
                string = "top left";
            } else if (this == this.o.d) {
                string = "bottom right";
            } else if (this == this.o.c) {
                string = "bottom left";
            }
            throw new RuntimeException("IlvQuadtree.nodeAdd: " + ilvGraphic + " Not contained in cell bounds " + new IlvRect((float)this.i, (float)this.j, (float)this.k, (float)this.l) + " parent:" + this.o + " position:" + string);
        }
        if (this.g) {
            this.d(ilvGraphic, ilvRect);
        } else if (this.k > 1.0E-5 && this.l > 1.0E-5 && this.f >= this.h - 1) {
            if (this.f == this.h - 1) {
                IlvGraphic[] ilvGraphicArray = this.e;
                int n = this.f;
                this.e();
                for (int i = 0; i < n; ++i) {
                    this.d(ilvGraphicArray[i], ilvGraphicArray[i].boundingBox(null));
                }
            }
            this.d(ilvGraphic, ilvRect);
        } else {
            this.b(ilvGraphic);
        }
    }

    private void e() {
        this.f = 0;
        this.e = null;
    }

    private void d(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        switch (this.a(ilvRect)) {
            case 6: {
                if (this.a == null) {
                    this.a = new IlvQuadtree(this, this.h, this.i, this.j, this.k / 2.0, this.l / 2.0);
                    this.g = true;
                }
                this.a.c(ilvGraphic, ilvRect);
                break;
            }
            case 5: {
                if (this.b == null) {
                    this.b = new IlvQuadtree(this, this.h, this.i + this.k / 2.0, this.j, this.k / 2.0, this.l / 2.0);
                    this.g = true;
                }
                this.b.c(ilvGraphic, ilvRect);
                break;
            }
            case 10: {
                if (this.c == null) {
                    this.c = new IlvQuadtree(this, this.h, this.i, this.j + this.l / 2.0, this.k / 2.0, this.l / 2.0);
                    this.g = true;
                }
                this.c.c(ilvGraphic, ilvRect);
                break;
            }
            case 9: {
                if (this.d == null) {
                    this.d = new IlvQuadtree(this, this.h, this.i + this.k / 2.0, this.j + this.l / 2.0, this.k / 2.0, this.l / 2.0);
                    this.g = true;
                }
                this.d.c(ilvGraphic, ilvRect);
                break;
            }
            case 65535: {
                this.b(ilvGraphic);
            }
        }
    }

    void a(IlvGraphic ilvGraphic, IlvQuadtree ilvQuadtree, IlvRect ilvRect) {
        this.n = false;
        if (ilvRect == null) {
            ilvRect = ilvGraphic.boundingBox(null);
        }
        if (!z) {
            if (Float.isNaN(ilvRect.x) || Float.isInfinite(ilvRect.x) || Float.isNaN(ilvRect.y) || Float.isInfinite(ilvRect.y) || Float.isNaN(ilvRect.width) || Float.isInfinite(ilvRect.width) || Float.isNaN(ilvRect.height) || Float.isInfinite(ilvRect.height)) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Invalid coordinates, obj.bbox=" + ilvRect);
            }
            if (ilvQuadtree == null) {
                throw new IllegalArgumentException("IlvQuadtree.update: " + ilvGraphic + " [" + ilvRect + "] " + " Root quadtree cell cannot be null");
            }
            if (ilvGraphic.l() != this) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Backpointer points to a different cell");
            }
            if (this.o == null && this != ilvQuadtree) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Cell with null parent must be the root");
            }
            if (!this.c(ilvGraphic)) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Not stored in this quadtree cell");
            }
        }
        if (this.c(ilvRect)) {
            this.e(ilvGraphic, ilvRect);
        } else if (this.o == null) {
            if (this.g) {
                if (!this.a(ilvGraphic, false)) {
                    throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Cannot remove from divided root cell of quadtree");
                }
                this.b(ilvRect);
                this.c(ilvGraphic, ilvRect);
            } else if (this.f >= this.h) {
                if (!this.a(ilvGraphic, false)) {
                    throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Cannot remove from non divided root cell of quadtree");
                }
                this.a(ilvGraphic, ilvRect);
            } else {
                this.f(ilvRect);
            }
        } else {
            if (!this.a(ilvGraphic, false)) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Cannot remove from quadtree");
            }
            if (this.o.c(ilvRect)) {
                this.b(false);
                this.o.c(ilvGraphic, ilvRect);
            } else {
                this.b(true);
                ilvQuadtree.a(ilvGraphic, ilvRect);
            }
        }
        if (!z) {
            IlvQuadtree ilvQuadtree2 = ilvGraphic.l();
            if (ilvQuadtree2 == null) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Backpointer cannot be null after update");
            }
            if (!ilvQuadtree2.c(ilvGraphic)) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Backpointer cell does not contain the object");
            }
            if (!ilvQuadtree2.c(ilvRect)) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Bounds of backpointer cell does not contain the object");
            }
        }
    }

    boolean a(IlvGraphic ilvGraphic) {
        if (!z && !this.c(ilvGraphic)) {
            throw new RuntimeException("IlvQuadtree.remove: " + ilvGraphic + " Not stored in this quadtree cell");
        }
        return this.a(ilvGraphic, true);
    }

    private boolean a(IlvGraphic ilvGraphic, boolean bl) {
        ilvGraphic.a((IlvQuadtree)null);
        if (this.e == null) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < this.f; ++i) {
            if (ilvGraphic != this.e[i]) continue;
            n = this.f - i - 1;
            if (n > 0) {
                System.arraycopy(this.e, i + 1, this.e, i, n);
            }
            --this.f;
            this.e[this.f] = null;
            this.n = false;
            if (bl) {
                this.b(true);
            }
            return true;
        }
        return false;
    }

    private void b(boolean bl) {
        if (this.f == 0 && !this.g && this.o != null) {
            if (this == this.o.a) {
                this.o.a = null;
            } else if (this == this.o.c) {
                this.o.c = null;
            } else if (this == this.o.b) {
                this.o.b = null;
            } else {
                this.o.d = null;
            }
            if (this.o.a == null && this.o.b == null && this.o.c == null && this.o.d == null) {
                this.o.g = false;
                if (bl) {
                    this.o.b(true);
                }
            }
        }
    }

    void a() {
        this.e = null;
        this.f = 0;
        this.n = false;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.o = null;
        this.g = false;
    }

    private void e(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        if (!this.g && (this.f < this.h || Math.min(this.k, this.l) <= 1.0E-5)) {
            this.n = false;
        } else {
            switch (this.a(ilvRect)) {
                case 6: {
                    this.a(ilvGraphic, false);
                    if (this.a == null) {
                        this.a = new IlvQuadtree(this, this.h);
                        this.a.i = this.i;
                        this.a.j = this.j;
                        this.a.k = this.k / 2.0;
                        this.a.l = this.l / 2.0;
                        this.g = true;
                    }
                    this.a.c(ilvGraphic, ilvRect);
                    break;
                }
                case 5: {
                    this.a(ilvGraphic, false);
                    if (this.b == null) {
                        this.b = new IlvQuadtree(this, this.h);
                        this.b.i = this.i + this.k / 2.0;
                        this.b.j = this.j;
                        this.b.k = this.i + this.k - this.b.i;
                        this.b.l = this.l / 2.0;
                        this.g = true;
                    }
                    this.b.c(ilvGraphic, ilvRect);
                    break;
                }
                case 10: {
                    this.a(ilvGraphic, false);
                    if (this.c == null) {
                        this.c = new IlvQuadtree(this, this.h);
                        this.c.i = this.i;
                        this.c.j = this.j + this.l / 2.0;
                        this.c.k = this.k / 2.0;
                        this.c.l = this.j + this.l - this.c.j;
                        this.g = true;
                    }
                    this.c.c(ilvGraphic, ilvRect);
                    break;
                }
                case 9: {
                    this.a(ilvGraphic, false);
                    if (this.d == null) {
                        this.d = new IlvQuadtree(this, this.h);
                        this.d.i = this.i + this.k / 2.0;
                        this.d.j = this.j + this.l / 2.0;
                        this.d.k = this.i + this.k - this.d.i;
                        this.d.l = this.j + this.l - this.d.j;
                        this.g = true;
                    }
                    this.d.c(ilvGraphic, ilvRect);
                    break;
                }
                case 65535: {
                    this.n = false;
                }
            }
        }
    }

    private int a(IlvRect ilvRect) {
        double d;
        double d2;
        block7: {
            block6: {
                if (this.k <= 1.0E-5) break block6;
                if (!(this.l <= 1.0E-5)) break block7;
            }
            return 65535;
        }
        double d3 = ilvRect.x;
        double d4 = this.i + this.k / 2.0;
        int n = 1;
        if (d3 < d4) {
            if (d3 + (double)ilvRect.width <= d4) {
                n = 2;
            } else {
                return 65535;
            }
        }
        return (d2 = (double)ilvRect.y) >= (d = this.j + this.l / 2.0) ? n | 8 : (d2 + (double)ilvRect.height <= d ? n | 4 : 65535);
    }

    private int a(IlvPoint ilvPoint) {
        block7: {
            block6: {
                if (this.k <= 1.0E-5) break block6;
                if (!(this.l <= 1.0E-5)) break block7;
            }
            return 65535;
        }
        if ((double)ilvPoint.x >= this.i + this.k / 2.0) {
            if ((double)ilvPoint.y >= this.j + this.l / 2.0) {
                return 9;
            }
            return 5;
        }
        if ((double)ilvPoint.y >= this.j + this.l / 2.0) {
            return 10;
        }
        return 6;
    }

    private void a(float f, float f2) {
        if (this.b(f, f2)) {
            return;
        }
        IlvGraphic[] ilvGraphicArray = this.e;
        int n = this.f;
        this.e = null;
        this.n = false;
        this.f = 0;
        boolean bl = true;
        switch ((this.i >= (double)f ? 2 : 1) | (this.j >= (double)f2 ? 4 : 8)) {
            case 10: {
                do {
                    IlvQuadtree ilvQuadtree = new IlvQuadtree(this);
                    if (bl) {
                        bl = false;
                        ilvQuadtree.e = ilvGraphicArray;
                        ilvQuadtree.f = n;
                        this.a(ilvGraphicArray, n, ilvQuadtree);
                    } else {
                        ilvQuadtree.e = null;
                        ilvQuadtree.f = 0;
                    }
                    ilvQuadtree.i = this.i;
                    ilvQuadtree.j = this.j;
                    ilvQuadtree.k = this.k;
                    ilvQuadtree.l = this.l;
                    this.i -= this.k;
                    this.k = 2.0 * this.k;
                    this.l = 2.0 * this.l;
                    this.b = ilvQuadtree;
                    this.a = null;
                    this.c = null;
                    this.d = null;
                } while (!this.b(f, f2));
                break;
            }
            case 9: {
                do {
                    IlvQuadtree ilvQuadtree = new IlvQuadtree(this);
                    if (bl) {
                        bl = false;
                        ilvQuadtree.e = ilvGraphicArray;
                        ilvQuadtree.f = n;
                        this.a(ilvGraphicArray, n, ilvQuadtree);
                    } else {
                        ilvQuadtree.e = null;
                        ilvQuadtree.f = 0;
                    }
                    ilvQuadtree.i = this.i;
                    ilvQuadtree.j = this.j;
                    ilvQuadtree.k = this.k;
                    ilvQuadtree.l = this.l;
                    this.k = 2.0 * this.k;
                    this.l = 2.0 * this.l;
                    this.a = ilvQuadtree;
                    this.b = null;
                    this.c = null;
                    this.d = null;
                } while (!this.b(f, f2));
                break;
            }
            case 6: {
                do {
                    IlvQuadtree ilvQuadtree = new IlvQuadtree(this);
                    if (bl) {
                        bl = false;
                        ilvQuadtree.e = ilvGraphicArray;
                        ilvQuadtree.f = n;
                        this.a(ilvGraphicArray, n, ilvQuadtree);
                    } else {
                        ilvQuadtree.e = null;
                        ilvQuadtree.f = 0;
                    }
                    ilvQuadtree.i = this.i;
                    ilvQuadtree.j = this.j;
                    ilvQuadtree.k = this.k;
                    ilvQuadtree.l = this.l;
                    this.i += -this.k;
                    this.j += -this.l;
                    this.k = 2.0 * this.k;
                    this.l = 2.0 * this.l;
                    this.d = ilvQuadtree;
                    this.a = null;
                    this.b = null;
                    this.c = null;
                } while (!this.b(f, f2));
                break;
            }
            case 5: {
                do {
                    IlvQuadtree ilvQuadtree = new IlvQuadtree(this);
                    if (bl) {
                        bl = false;
                        ilvQuadtree.e = ilvGraphicArray;
                        ilvQuadtree.f = n;
                        this.a(ilvGraphicArray, n, ilvQuadtree);
                    } else {
                        ilvQuadtree.e = null;
                        ilvQuadtree.f = 0;
                    }
                    ilvQuadtree.i = this.i;
                    ilvQuadtree.j = this.j;
                    ilvQuadtree.k = this.k;
                    ilvQuadtree.l = this.l;
                    this.j -= this.l;
                    this.k = 2.0 * this.k;
                    this.l = 2.0 * this.l;
                    this.c = ilvQuadtree;
                    this.a = null;
                    this.b = null;
                    this.d = null;
                } while (!this.b(f, f2));
            }
        }
        this.g = true;
        this.e = null;
        this.n = false;
        this.f = 0;
    }

    private void a(IlvGraphic[] ilvGraphicArray, int n, IlvQuadtree ilvQuadtree) {
        if (ilvGraphicArray != null) {
            for (int i = 0; i < n; ++i) {
                ilvGraphicArray[i].a(ilvQuadtree);
            }
        }
    }

    private void b(IlvRect ilvRect) {
        this.a(ilvRect.x, ilvRect.y);
        this.a(ilvRect.x + ilvRect.width, ilvRect.y + ilvRect.height);
    }

    IlvQuadtree b(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        if (!this.e(ilvRect)) {
            return null;
        }
        if (!this.g) {
            return this.c(ilvGraphic) ? this : null;
        }
        switch (this.a(ilvRect)) {
            case 6: {
                return this.a != null ? this.a.b(ilvGraphic, ilvRect) : null;
            }
            case 5: {
                return this.b != null ? this.b.b(ilvGraphic, ilvRect) : null;
            }
            case 10: {
                return this.c != null ? this.c.b(ilvGraphic, ilvRect) : null;
            }
            case 9: {
                return this.d != null ? this.d.b(ilvGraphic, ilvRect) : null;
            }
            case 65535: {
                return this.c(ilvGraphic) ? this : null;
            }
        }
        return null;
    }

    private void a(int n) {
        if (this.e == null) {
            this.e = new IlvGraphic[Math.max(this.h, n)];
        } else {
            int n2 = this.e.length;
            if (n > n2) {
                IlvGraphic[] ilvGraphicArray = this.e;
                int n3 = n2 * 2;
                if (n3 < n) {
                    n3 = n;
                }
                this.e = new IlvGraphic[n3];
                System.arraycopy(ilvGraphicArray, 0, this.e, 0, this.f);
            }
        }
    }

    private void b(IlvGraphic ilvGraphic) {
        this.a(this.f + 1);
        this.e[this.f++] = ilvGraphic;
        ilvGraphic.a(this);
        this.n = false;
    }

    private boolean c(IlvGraphic ilvGraphic) {
        if (this.e == null) {
            return false;
        }
        for (int i = 0; i < this.f; ++i) {
            if (ilvGraphic != this.e[i]) continue;
            return true;
        }
        return false;
    }

    private boolean c(IlvRect ilvRect) {
        return (double)ilvRect.x >= this.i && (double)ilvRect.y >= this.j && (double)(ilvRect.x + ilvRect.width) <= this.i + this.k && (double)(ilvRect.y + ilvRect.height) <= this.j + this.l;
    }

    private boolean d(IlvRect ilvRect) {
        return this.i >= (double)ilvRect.x && this.i + this.k <= (double)(ilvRect.x + ilvRect.width) && this.j >= (double)ilvRect.y && this.j + this.l <= (double)(ilvRect.y + ilvRect.height);
    }

    private boolean b(float f, float f2) {
        return (double)f >= this.i && (double)f <= this.i + this.k && (double)f2 >= this.j && (double)f2 <= this.j + this.l;
    }

    private boolean e(IlvRect ilvRect) {
        return this.i <= (double)(ilvRect.x + ilvRect.width) && this.i + this.k >= (double)ilvRect.x && this.j <= (double)(ilvRect.y + ilvRect.height) && this.j + this.l >= (double)ilvRect.y;
    }

    private void f(IlvRect ilvRect) {
        if (ilvRect.width == 0.0f || ilvRect.height == 0.0f) {
            return;
        }
        double d = Math.min(this.i, (double)ilvRect.x);
        double d2 = Math.max(this.i + this.k, (double)(ilvRect.x + ilvRect.width));
        double d3 = Math.min(this.j, (double)ilvRect.y);
        double d4 = Math.max(this.j + this.l, (double)(ilvRect.y + ilvRect.height));
        this.i = d;
        this.j = d3;
        this.k = d2 - d;
        this.l = d4 - d3;
    }

    void b() {
        this.n = false;
    }

    IlvRect c() {
        return this.g(null);
    }

    private IlvRect g(IlvRect ilvRect) {
        if (ilvRect != null && this.i > (double)ilvRect.x && this.j > (double)ilvRect.y && this.i + this.k < (double)(ilvRect.x + ilvRect.width) && this.j + this.l < (double)(ilvRect.y + ilvRect.height)) {
            return ilvRect;
        }
        if (!this.n) {
            this.m = null;
            for (int i = 0; i < this.f; ++i) {
                IlvGraphic ilvGraphic = this.e[i];
                if (!ilvGraphic.zoomable() || !ilvGraphic.isVisible()) continue;
                IlvRect ilvRect2 = ilvGraphic.boundingBox(null);
                if (this.m == null) {
                    this.m = ilvRect2;
                    continue;
                }
                this.m.add(ilvRect2);
            }
            this.n = true;
        }
        if (this.m != null) {
            if (ilvRect == null) {
                ilvRect = new IlvRect(this.m);
            } else {
                ilvRect.add(this.m);
            }
        }
        if (this.a != null) {
            ilvRect = this.a.g(ilvRect);
        }
        if (this.b != null) {
            ilvRect = this.b.g(ilvRect);
        }
        if (this.c != null) {
            ilvRect = this.c.g(ilvRect);
        }
        if (this.d != null) {
            ilvRect = this.d.g(ilvRect);
        }
        return ilvRect;
    }

    void a(IlvApplyObject ilvApplyObject, Object object) {
        for (int i = 0; i < this.f; ++i) {
            ilvApplyObject.apply(this.e[i], object);
        }
        if (this.a != null) {
            this.a.a(ilvApplyObject, object);
        }
        if (this.b != null) {
            this.b.a(ilvApplyObject, object);
        }
        if (this.c != null) {
            this.c.a(ilvApplyObject, object);
        }
        if (this.d != null) {
            this.d.a(ilvApplyObject, object);
        }
    }

    void b(IlvApplyObject ilvApplyObject, Object object) {
        for (int i = 0; i < this.f; ++i) {
            IlvGraphic ilvGraphic = this.e[i];
            if (!ilvGraphic.zoomable()) continue;
            ilvApplyObject.apply(ilvGraphic, object);
        }
        if (this.a != null) {
            this.a.b(ilvApplyObject, object);
        }
        if (this.b != null) {
            this.b.b(ilvApplyObject, object);
        }
        if (this.c != null) {
            this.c.b(ilvApplyObject, object);
        }
        if (this.d != null) {
            this.d.b(ilvApplyObject, object);
        }
    }

    void a(IlvRect ilvRect, IlvRect ilvRect2, IlvApplyObject ilvApplyObject, Object object, IlvTransformer ilvTransformer) {
        if (this.d(ilvRect)) {
            this.a(ilvApplyObject, object);
        } else if (this.e(ilvRect)) {
            for (int i = 0; i < this.f; ++i) {
                IlvGraphic ilvGraphic = this.e[i];
                if (!ilvGraphic.inside(ilvRect, ilvRect2, ilvTransformer)) continue;
                ilvApplyObject.apply(ilvGraphic, object);
            }
            if (this.a != null) {
                this.a.a(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.b != null) {
                this.b.a(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.c != null) {
                this.c.a(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.d != null) {
                this.d.a(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
        }
    }

    void b(IlvRect ilvRect, IlvRect ilvRect2, IlvApplyObject ilvApplyObject, Object object, IlvTransformer ilvTransformer) {
        if (this.d(ilvRect)) {
            this.b(ilvApplyObject, object);
        } else if (this.e(ilvRect)) {
            for (int i = 0; i < this.f; ++i) {
                IlvGraphic ilvGraphic = this.e[i];
                if (!ilvGraphic.zoomable() || !ilvGraphic.inside(ilvRect, ilvRect2, ilvTransformer)) continue;
                ilvApplyObject.apply(ilvGraphic, object);
            }
            if (this.a != null) {
                this.a.b(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.b != null) {
                this.b.b(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.c != null) {
                this.c.b(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.d != null) {
                this.d.b(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
        }
    }

    void c(IlvRect ilvRect, IlvRect ilvRect2, IlvApplyObject ilvApplyObject, Object object, IlvTransformer ilvTransformer) {
        if (this.d(ilvRect)) {
            this.a(ilvApplyObject, object);
        } else if (this.e(ilvRect)) {
            for (int i = 0; i < this.f; ++i) {
                IlvGraphic ilvGraphic = this.e[i];
                if (!ilvGraphic.intersects(ilvRect, ilvRect2, ilvTransformer)) continue;
                ilvApplyObject.apply(ilvGraphic, object);
            }
            if (this.a != null) {
                this.a.c(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.b != null) {
                this.b.c(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.c != null) {
                this.c.c(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.d != null) {
                this.d.c(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
        }
    }

    void d(IlvRect ilvRect, IlvRect ilvRect2, IlvApplyObject ilvApplyObject, Object object, IlvTransformer ilvTransformer) {
        if (this.d(ilvRect)) {
            this.b(ilvApplyObject, object);
        } else if (this.e(ilvRect)) {
            for (int i = 0; i < this.f; ++i) {
                IlvGraphic ilvGraphic = this.e[i];
                if (!ilvGraphic.zoomable() || !ilvGraphic.intersects(ilvRect, ilvRect2, ilvTransformer)) continue;
                ilvApplyObject.apply(ilvGraphic, object);
            }
            if (this.a != null) {
                this.a.d(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.b != null) {
                this.b.d(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.c != null) {
                this.c.d(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.d != null) {
                this.d.d(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
        }
    }

    private IlvQuadtree b(int n) {
        switch (n) {
            case 5: {
                return this.b;
            }
            case 6: {
                return this.a;
            }
            case 9: {
                return this.d;
            }
            case 10: {
                return this.c;
            }
        }
        return null;
    }

    IlvGraphic a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, IlvGraphicFilter ilvGraphicFilter) {
        IlvGraphic ilvGraphic;
        IlvQuadtree ilvQuadtree;
        if (!this.b(ilvPoint.x, ilvPoint.y)) {
            return null;
        }
        if (this.g && (ilvQuadtree = this.b(this.a(ilvPoint))) != null && (ilvGraphic = ilvQuadtree.a(ilvPoint, ilvPoint2, ilvTransformer, ilvGraphicFilter)) != null) {
            return ilvGraphic;
        }
        if (this.e != null && this.f != 0) {
            for (int i = this.f - 1; i >= 0; --i) {
                ilvGraphic = this.e[i];
                if (!ilvGraphicFilter.accept(ilvGraphic) || !ilvGraphic.zoomable() || !ilvGraphic.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
                return ilvGraphic;
            }
        }
        return null;
    }

    IlvGraphic b(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, IlvGraphicFilter ilvGraphicFilter) {
        IlvGraphic ilvGraphic;
        IlvQuadtree ilvQuadtree;
        if (!this.b(ilvPoint.x, ilvPoint.y)) {
            return null;
        }
        if (this.g && (ilvQuadtree = this.b(this.a(ilvPoint))) != null && (ilvGraphic = ilvQuadtree.b(ilvPoint, ilvPoint2, ilvTransformer, ilvGraphicFilter)) != null) {
            return ilvGraphic;
        }
        if (this.e != null && this.f != 0) {
            for (int i = this.f - 1; i >= 0; --i) {
                ilvGraphic = this.e[i];
                if (!ilvGraphicFilter.accept(ilvGraphic) || !ilvGraphic.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
                return ilvGraphic;
            }
        }
        return null;
    }

    void a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, IlvGraphicFilter ilvGraphicFilter, IlvGraphicVector ilvGraphicVector) {
        IlvQuadtree ilvQuadtree;
        if (!this.b(ilvPoint.x, ilvPoint.y)) {
            return;
        }
        if (this.g && (ilvQuadtree = this.b(this.a(ilvPoint))) != null) {
            ilvQuadtree.a(ilvPoint, ilvPoint2, ilvTransformer, ilvGraphicFilter, ilvGraphicVector);
        }
        if (this.e != null && this.f != 0) {
            for (int i = this.f - 1; i >= 0; --i) {
                IlvGraphic ilvGraphic = this.e[i];
                if (!ilvGraphicFilter.accept(ilvGraphic) || !ilvGraphic.zoomable() || !ilvGraphic.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
                ilvGraphicVector.addElement(ilvGraphic);
            }
        }
    }

    void b(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, IlvGraphicFilter ilvGraphicFilter, IlvGraphicVector ilvGraphicVector) {
        IlvQuadtree ilvQuadtree;
        if (!this.b(ilvPoint.x, ilvPoint.y)) {
            return;
        }
        if (this.g && (ilvQuadtree = this.b(this.a(ilvPoint))) != null) {
            ilvQuadtree.b(ilvPoint, ilvPoint2, ilvTransformer, ilvGraphicFilter, ilvGraphicVector);
        }
        if (this.e != null && this.f != 0) {
            for (int i = this.f - 1; i >= 0; --i) {
                IlvGraphic ilvGraphic = this.e[i];
                if (!ilvGraphicFilter.accept(ilvGraphic) || !ilvGraphic.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
                ilvGraphicVector.addElement(ilvGraphic);
            }
        }
    }

    final int a(boolean bl) {
        int n = this.f;
        IlvRect ilvRect = new IlvRect((float)this.i, (float)this.j, (float)this.k, (float)this.l);
        if (bl) {
            System.out.print("** Cell " + this + " bounds: " + ilvRect);
            System.out.println(" " + this.f + " elements" + (!this.g ? " (leave)" : ""));
        }
        if (this.e == null && this.f != 0) {
            throw new RuntimeException("_elements is null and _count != 0");
        }
        if (this.e != null && this.e.length < this.f) {
            throw new RuntimeException("_elements.length (" + this.e.length + ") < _count (" + this.f + ")");
        }
        if (this.e != null) {
            IlvGraphic ilvGraphic = null;
            IlvQuadtree ilvQuadtree = null;
            boolean bl2 = Math.min(this.k, this.l) > 1.0E-5 && (this.f >= this.h || this.g);
            for (int i = 0; i < this.f; ++i) {
                IlvRect ilvRect2;
                ilvGraphic = this.e[i];
                ilvQuadtree = ilvGraphic.l();
                if (ilvQuadtree == null) {
                    throw new RuntimeException("null backpointer");
                }
                if (ilvQuadtree != this) {
                    System.out.println("obj " + ilvGraphic);
                    if (ilvGraphic.getName() != null) {
                        System.out.println("name = " + ilvGraphic.getName());
                    }
                    System.out.println("has backpointer to cell " + ilvQuadtree);
                    ilvRect2 = new IlvRect((float)ilvQuadtree.i, (float)ilvQuadtree.j, (float)ilvQuadtree.k, (float)ilvQuadtree.l);
                    System.out.println("    (bounds = " + ilvRect2 + ")");
                    System.out.println("and is in cell " + this);
                    System.out.println("    (bounds = " + ilvRect + ")");
                    throw new RuntimeException("backpointer to a different cell");
                }
                ilvRect2 = ilvGraphic.boundingBox(null);
                if (!ilvRect.contains(ilvRect2)) {
                    int n2 = 50;
                    boolean bl3 = false;
                    float f = 0.0f;
                    float f2 = ilvRect.x - ilvRect2.x;
                    f = Math.max(f, f2 / ilvRect2.width);
                    if (f2 > 0.0f) {
                        float f3 = n2 != 0 ? ilvRect2.width / (float)n2 : 0.0f;
                        if (f2 > f3) {
                            bl3 = true;
                        }
                    }
                    f2 = ilvRect.y - ilvRect2.y;
                    f = Math.max(f, f2 / ilvRect2.height);
                    if (f2 > 0.0f) {
                        float f4 = n2 != 0 ? ilvRect2.height / (float)n2 : 0.0f;
                        if (f2 > f4) {
                            bl3 = true;
                        }
                    }
                    f2 = ilvRect2.x + ilvRect2.width - ilvRect.x - ilvRect.width;
                    f = Math.max(f, f2 / ilvRect2.width);
                    if (f2 > 0.0f) {
                        float f5 = n2 != 0 ? ilvRect2.width / (float)n2 : 0.0f;
                        if (f2 > f5) {
                            bl3 = true;
                        }
                    }
                    f2 = ilvRect2.y + ilvRect2.height - ilvRect.y - ilvRect.height;
                    f = Math.max(f, f2 / ilvRect2.height);
                    if (f2 > 0.0f) {
                        float f6 = n2 != 0 ? ilvRect2.height / (float)n2 : 0.0f;
                        if (f2 > f6) {
                            bl3 = true;
                        }
                    }
                    if (bl3) {
                        throw new RuntimeException("Object " + ilvGraphic + " not contained in the bounds of its " + "quadtree cell = " + ilvRect + " maxError = " + f * 100.0f + " %");
                    }
                }
                if (!bl2) continue;
                if (this.a(ilvRect2) == 65535) continue;
                System.out.println("******** _count: " + this.f);
                System.out.println(" i = " + i);
                System.out.println("obj = " + this.e[i]);
                System.out.println(" Subcells: " + (this.a == null ? "null" : "TOP_L") + " " + (this.b == null ? "null" : "TOP_R") + " " + (this.c == null ? "null" : "BOTTOM_L") + " " + (this.d == null ? "null" : "BOTTOM_R"));
                System.out.println("_divided: " + this.g);
                System.out.println("bounds: " + new IlvRect((float)this.i, (float)this.j, (float)this.k, (float)this.l));
                if (this.o == null) {
                    System.out.println("(top root cell)");
                }
                String string = ilvGraphic instanceof IlvLinkImage ? "link" : "node";
                String string2 = null;
                switch (this.a(ilvRect2)) {
                    case 6: {
                        string2 = "QTopL";
                        break;
                    }
                    case 5: {
                        string2 = "QTopR";
                        break;
                    }
                    case 10: {
                        string2 = "QBottomL";
                        break;
                    }
                    case 9: {
                        string2 = "QBottomR";
                        break;
                    }
                    case 65535: {
                        string2 = "QInside";
                    }
                }
                System.out.println("********* Objects in the cell that should be in subcells:");
                boolean bl4 = true;
                IlvRect ilvRect3 = null;
                for (int j = 0; j < this.f; ++j) {
                    string = this.e[j] instanceof IlvLinkImage ? "link" : "node";
                    ilvRect3 = this.e[j].boundingBox(null);
                    string2 = null;
                    switch (this.a(ilvRect3)) {
                        case 6: {
                            string2 = "QTopL";
                            break;
                        }
                        case 5: {
                            string2 = "QTopR";
                            break;
                        }
                        case 10: {
                            string2 = "QBottomL";
                            break;
                        }
                        case 9: {
                            string2 = "QBottomR";
                            break;
                        }
                        case 65535: {
                            string2 = "QInside";
                        }
                    }
                    if (i == j) {
                        System.out.println("j = " + j + " posDescr = " + string2);
                    }
                    if (!bl2) continue;
                    if (string2.equals("QInside")) continue;
                    if (bl4) {
                        System.out.println("******** _count: " + this.f);
                        bl4 = false;
                    }
                    System.out.println("  bbox[" + j + "] " + string + ": " + ilvRect3 + " (" + string2 + ")");
                }
                throw new RuntimeException("Object " + ilvGraphic + " should be in a subcell! (bounds: " + ilvRect + " _count: " + this.f + " _divided: " + this.g + " pos: " + string2 + ")");
            }
        }
        if (this.g && this.b == null && this.a == null && this.d == null && this.c == null) {
            System.out.println("cell " + this + ": no subcell, but flag _divided is true!!");
            System.out.println("parent = " + this.o);
            throw new RuntimeException("No subcell, but flag _divided is true!!");
        }
        if (!(this.g || this.b == null && this.a == null && this.d == null && this.c == null)) {
            if (this.b != null) {
                System.out.println("_divided is false but _topR is " + this.b + " (elem., count = " + this.b.f + ")");
            }
            if (this.a != null) {
                System.out.println("_divided is false but _topL is " + this.a + " (elem., count = " + this.a.f + ")");
            }
            if (this.d != null) {
                System.out.println("_divided is false but _bottomR is " + this.d + " (elem., count = " + this.d.f + ")");
            }
            if (this.c != null) {
                System.out.println("_divided is false but _bottomL is " + this.c + " (elem., count = " + this.c.f + ")");
            }
            throw new RuntimeException("Subcells exist, but flag _divided is false!!");
        }
        if (this.g) {
            if (this.b != null) {
                if (this.b.d() != this) {
                    System.out.println("this: " + this);
                    System.out.println("_topL = " + this.b + " with count: " + this.b.f);
                    System.out.println("_topL.getParent() = " + this.b.d() + " with count: " + this.b.d().f);
                    throw new RuntimeException("_topR.getParent != this !!" + (this.b.d() == null ? " (is null)" : ""));
                }
                if (bl) {
                    System.out.println("  topR:");
                }
                n += this.b.a(bl);
            }
            if (this.a != null) {
                if (this.a.d() != this) {
                    System.out.println("this: " + this);
                    System.out.println("_topL = " + this.a + " with count: " + this.a.f);
                    System.out.println("_topL.getParent() = " + this.a.d() + " with count: " + this.a.d().f);
                    throw new RuntimeException("_topL.getParent != this !!" + (this.a.d() == null ? " (is null)" : ""));
                }
                if (bl) {
                    System.out.println("  topL:");
                }
                n += this.a.a(bl);
            }
            if (this.d != null) {
                if (this.d.d() != this) {
                    System.out.println("this: " + this);
                    System.out.println("_bottomR = " + this.d + " with count: " + this.d.f);
                    System.out.println("_bottomR.getParent() = " + this.d.d() + " with count: " + this.d.d().f);
                    throw new RuntimeException("_bottomR.getParent != this !!" + (this.d.d() == null ? " (is null)" : ""));
                }
                if (bl) {
                    System.out.println("  bottomR:");
                }
                n += this.d.a(bl);
            }
            if (this.c != null) {
                if (this.c.d() != this) {
                    System.out.println("this: " + this);
                    System.out.println("_bottomL = " + this.c + " with count: " + this.c.f);
                    System.out.println("_bottomL.getParent() = " + this.c.d() + " with count: " + this.c.d().f);
                    throw new RuntimeException("_bottomL.getParent != this !!" + (this.c.d() == null ? " (is null)" : ""));
                }
                if (bl) {
                    System.out.println("  bottomL:");
                }
                n += this.c.a(bl);
            }
        }
        return n;
    }
}

