/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.samlp;

import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.samlp.SAMLPUtils;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLNode;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StatusCode
extends XMLElement {
    public static final String SUCCESS = "Success";
    public static final String VERSION_MISMATCH = "VersionMismatch";
    public static final String RESPONDER = "Responder";
    public static final String REQUESTER = "Requester";
    public static final String REQUEST_VERSION_TOO_HIGH = "RequestVersionTooHigh";
    public static final String REQUEST_VERSION_TOO_LOW = "RequestVersionTooLow";
    public static final String REQUEST_VERSION_DEPRECATED = "RequestVersionDeprecated";
    public static final String TOO_MANY_RESPONSES = "TooManyResponses";
    public static final String REQUEST_DENIED = "RequestDenied";
    public static final String RESOURCE_NOT_RECOGNIZED = "ResourceNotRecognized";

    public StatusCode(Element element) throws DOMException {
        super(element);
    }

    public StatusCode(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public StatusCode(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
    }

    public void setValue(String value, String namespace) {
        String prefix = XMLElement.getDefaultNSPrefix((String)(namespace == null ? "urn:oasis:names:tc:SAML:1.0:protocol" : namespace));
        String qName = value;
        if (prefix != null && prefix.length() != 0) {
            qName = prefix + ":" + qName;
        }
        this.setAttribute("Value", qName);
    }

    public String getValue() {
        if (this.hasAttribute("Value")) {
            return this.getAttribute("Value");
        }
        return null;
    }

    public void setStatusCodeValue(QName qname) {
        Attr attr = this.getOwnerDocument().createAttribute("Value");
        this.setAttributeNode(attr);
        QName.setQNameValue((Node)attr, (QName)qname);
    }

    public QName getStatusCodeValue() {
        if (this.hasAttribute("Value")) {
            return QName.getInstance((String)this.getAttribute("Value"), (XMLElement)this);
        }
        return null;
    }

    public void setStatusCode(StatusCode statusCode) {
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"urn:oasis:names:tc:SAML:1.0:protocol", (String)"StatusCode");
        this.appendChild((XMLNode)statusCode);
    }

    public StatusCode getStatusCode() {
        return (StatusCode)SAMLPUtils.getChildElement(this, "urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
    }

    static {
        SAMLInitializer.initialize();
    }
}

