/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml;

import oracle.security.xmlsec.saml.Action;
import oracle.security.xmlsec.saml.Advice;
import oracle.security.xmlsec.saml.Assertion;
import oracle.security.xmlsec.saml.Attribute;
import oracle.security.xmlsec.saml.AttributeDesignator;
import oracle.security.xmlsec.saml.AttributeStatement;
import oracle.security.xmlsec.saml.AudienceRestrictionCondition;
import oracle.security.xmlsec.saml.AuthenticationStatement;
import oracle.security.xmlsec.saml.AuthorityBinding;
import oracle.security.xmlsec.saml.AuthorizationDecisionStatement;
import oracle.security.xmlsec.saml.Condition;
import oracle.security.xmlsec.saml.Conditions;
import oracle.security.xmlsec.saml.DoNotCacheCondition;
import oracle.security.xmlsec.saml.Evidence;
import oracle.security.xmlsec.saml.NameIdentifier;
import oracle.security.xmlsec.saml.Subject;
import oracle.security.xmlsec.saml.SubjectConfirmation;
import oracle.security.xmlsec.saml.SubjectLocality;
import oracle.security.xmlsec.samlp.AttributeQuery;
import oracle.security.xmlsec.samlp.AuthenticationQuery;
import oracle.security.xmlsec.samlp.AuthorizationDecisionQuery;
import oracle.security.xmlsec.samlp.Request;
import oracle.security.xmlsec.samlp.Response;
import oracle.security.xmlsec.samlp.Status;
import oracle.security.xmlsec.samlp.StatusCode;
import oracle.security.xmlsec.samlp.StatusDetail;
import oracle.security.xmlsec.util.TagManager;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;

public class SAMLInitializer {
    private static boolean initialized;
    private static boolean saml11Initialized;

    public static void initialize() {
        SAMLInitializer.initialize(1, 0);
    }

    public static synchronized void initialize(int majorVersion, int minorVersion) {
        if (!initialized) {
            XMLElement.setDefaultNSPrefix((String)"urn:oasis:names:tc:SAML:1.0:assertion", (String)"saml");
            XMLElement.setDefaultNSPrefix((String)"urn:oasis:names:tc:SAML:1.0:protocol", (String)"samlp");
            TagManager m = TagManager.getTagManager();
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "Action", Action.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "Advice", Advice.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion", Assertion.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "Attribute", Attribute.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator", AttributeDesignator.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionCondition", AudienceRestrictionCondition.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding", AuthorityBinding.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement", AuthenticationStatement.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement", AttributeStatement.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement", AuthorizationDecisionStatement.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "Condition", Condition.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "Conditions", Conditions.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "DoNotCacheCondition", DoNotCacheCondition.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "Evidence", Evidence.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier", NameIdentifier.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "Subject", Subject.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation", SubjectConfirmation.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectLocality", SubjectLocality.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQuery", AuthenticationQuery.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery", AttributeQuery.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQuery", AuthorizationDecisionQuery.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:protocol", "Status", Status.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:protocol", "StatusDetail", StatusDetail.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode", StatusCode.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:protocol", "Request", Request.class);
            m.mapTag("urn:oasis:names:tc:SAML:1.0:protocol", "Response", Response.class);
            initialized = true;
        }
        if (!saml11Initialized && majorVersion == 1 && minorVersion == 1) {
            XMLUtils.addIdAttribute((String)"urn:oasis:names:tc:SAML:1.0:assertion", (String)"AssertionID");
            XMLUtils.addIdAttribute((String)"urn:oasis:names:tc:SAML:1.0:protocol", (String)"RequestID");
            XMLUtils.addIdAttribute((String)"urn:oasis:names:tc:SAML:1.0:protocol", (String)"ResponseID");
            saml11Initialized = true;
        }
    }

    private SAMLInitializer() {
    }
}

