/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml;

import java.util.List;
import oracle.security.xmlsec.saml.Action;
import oracle.security.xmlsec.saml.Decision;
import oracle.security.xmlsec.saml.Evidence;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.saml.SAMLUtils;
import oracle.security.xmlsec.saml.SubjectStatement;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuthorizationDecisionStatement
extends SubjectStatement {
    private static final String[] nsURIs = new String[]{"urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion"};
    private static final String[] localNames = new String[]{"Subject", "Action", "Evidence"};

    public AuthorizationDecisionStatement(Element element) throws DOMException {
        super(element);
    }

    public AuthorizationDecisionStatement(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AuthorizationDecisionStatement(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement");
    }

    public void setResource(String resource) {
        this.setAttribute("Resource", resource);
    }

    public String getResource() {
        if (this.hasAttribute("Resource")) {
            return this.getAttribute("Resource");
        }
        return null;
    }

    public void setDecision(Decision decision) {
        this.setAttribute("Decision", decision.getValue());
    }

    public Decision getDecision() {
        if (this.hasAttribute("Decision")) {
            return new Decision(this.getAttribute("Decision"));
        }
        return null;
    }

    public void addAction(Action action) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)action, (String[])nsURIs, (String[])localNames);
    }

    public List getActions() {
        return SAMLUtils.getChildElements(this, "urn:oasis:names:tc:SAML:1.0:assertion", "Action");
    }

    public void setEvidence(Evidence evidence) {
        SAMLUtils.setChildElement(this, evidence, nsURIs, localNames);
    }

    public Evidence getEvidence() {
        return (Evidence)SAMLUtils.getChildElement(this, "urn:oasis:names:tc:SAML:1.0:assertion", "Evidence");
    }

    static {
        SAMLInitializer.initialize();
    }
}

