/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml;

import java.util.Date;
import java.util.List;
import oracle.security.xmlsec.saml.Advice;
import oracle.security.xmlsec.saml.Conditions;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.saml.SAMLMessage;
import oracle.security.xmlsec.saml.SAMLUtils;
import oracle.security.xmlsec.saml.Statement;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Assertion
extends SAMLMessage {
    private static final String[] nsURIs = new String[]{"urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "http://www.w3.org/2000/09/xmldsig#"};
    private static final String[] localNames = new String[]{"Conditions", "Advice", "Statement", "SubjectStatement", "AuthenticationStatement", "AuthorizationDecisionStatement", "AttributeStatement", "Signature"};
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;

    public Assertion(Element element) throws DOMException {
        super(element);
    }

    public Assertion(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public Assertion(Document owner) throws DOMException {
        this(owner, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:assertion");
    }

    protected Assertion(Document owner, String uri, String localName) throws DOMException {
        super(owner, uri, localName);
        this.setVersion(1, 0);
    }

    public void setAssertionID(String assertionID) {
        this.setAttribute("AssertionID", assertionID);
    }

    public String getAssertionID() {
        if (this.hasAttribute("AssertionID")) {
            return this.getAttribute("AssertionID");
        }
        return null;
    }

    public void setIssuer(String issuer) {
        this.setAttribute("Issuer", issuer);
    }

    public String getIssuer() {
        if (this.hasAttribute("Issuer")) {
            return this.getAttribute("Issuer");
        }
        return null;
    }

    public void setIssueInstant(Date issueInstant) {
        this.setAttribute("IssueInstant", XMLUtils.formatDateTime((Date)issueInstant));
    }

    public Date getIssueInstant() {
        if (this.hasAttribute("IssueInstant")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("IssueInstant"));
        }
        return null;
    }

    public void setConditions(Conditions conditions) {
        SAMLUtils.setChildElement(this, conditions, nsURIs, localNames);
    }

    public Conditions getConditions() {
        return (Conditions)SAMLUtils.getChildElement(this, "urn:oasis:names:tc:SAML:1.0:assertion", "Conditions");
    }

    public void setAdvice(Advice advice) {
        SAMLUtils.setChildElement(this, advice, nsURIs, localNames);
    }

    public Advice getAdvice() {
        return (Advice)SAMLUtils.getChildElement(this, "urn:oasis:names:tc:SAML:1.0:assertion", "Advice");
    }

    public void addStatement(Statement statement) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)statement, (String[])nsURIs, (String[])localNames);
    }

    public List getAuthenticationStatements() {
        return SAMLUtils.getChildElements(this, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement");
    }

    public List getAuthorizationDecisionStatements() {
        return SAMLUtils.getChildElements(this, "urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement");
    }

    public List getAttributeStatements() {
        return SAMLUtils.getChildElements(this, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement");
    }

    @Override
    protected String[] getNSURIsPrecedeDSig() {
        return new String[]{"urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:assertion"};
    }

    @Override
    protected String[] getLocalNamesPrecedeDSig() {
        return new String[]{"Conditions", "Advice", "Statement", "SubjectStatement", "AuthenticationStatement", "AuthorizationDecisionStatement", "AttributeStatement"};
    }

    @Override
    protected String getID() {
        if (this.getMajorVersion() == 1 && this.getMinorVersion() == 0) {
            return null;
        }
        return this.getAssertionID();
    }

    static {
        SAMLInitializer.initialize();
    }
}

