/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import oracle.ide.Ide;
import oracle.ide.layout.SimpleLayout;
import oracle.ide.layout.ViewId;
import oracle.ide.migration.Migrator;
import oracle.ide.util.FileCopyUtil2;

public final class ProjectNavigatorMigrator
implements Migrator {
    private static final String NAVIGATOR_DEFAULT_NAME = "ApplicationNavigatorName";
    private static final String NAVIGATOR_WINDOW_ID = "ApplicationNavigatorWindow";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public int[] getMigrationCategories() {
        return new int[0];
    }

    public String getDescription(int category) {
        return "Window Manager Migrator";
    }

    public boolean canMigrate(int category, File sourceDir) {
        return false;
    }

    public void setSelected(int category, boolean selected) {
    }

    public boolean isSelected(int category) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] migrate(File sourceDir, File destDir) {
        Boolean migrationEnabled = Boolean.getBoolean("window.manager.migration");
        if (!migrationEnabled.booleanValue()) {
            return EMPTY_STRING_ARRAY;
        }
        if (sourceDir == null || destDir == null) {
            return EMPTY_STRING_ARRAY;
        }
        FileCopyUtil2.copyFiles((String)sourceDir.getPath(), (String)destDir.getPath());
        Collection allIdePropertiesFileOld = FileCopyUtil2.findFilesOrDirectories((File)sourceDir.getParentFile(), (String)"ide.properties", (boolean)true);
        if (allIdePropertiesFileOld.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        File idePropertiesFileOld = (File)allIdePropertiesFileOld.iterator().next();
        ViewId viewId = new ViewId("_SUB_ApplicationNavigatorWindow", "_SUB_ApplicationNavigatorName");
        String propName = viewId.getId() + ".root";
        SimpleLayout layout = null;
        try {
            layout = new SimpleLayout(idePropertiesFileOld.toURI().toURL());
            layout.open();
            String urlString = layout.getProperty(propName, null);
            if (urlString != null) {
                Ide.getIdeProperties().setProperty(propName, urlString);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (layout != null) {
                try {
                    layout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return EMPTY_STRING_ARRAY;
    }
}

