/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComboBoxUI;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ideimpl.navigator.AppPickerButtonUI;
import oracle.ideimpl.navigator.AppPickerComboBoxUI;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;

public final class AppPickerUI {
    private JComboBox _comboBox;
    private AbstractButton _button;
    private boolean _active;
    private boolean _mouseOverComboBox;
    private boolean _mouseOverButton;

    public void setComboBox(JComboBox box) {
        this._comboBox = this.decorateComboBox(box);
    }

    private JComboBox decorateComboBox(JComboBox box) {
        return AppPickerUI.decorateComboBox(box, this);
    }

    public void setButton(AbstractButton button) {
        this._button = this.decorateButton(button);
    }

    private AbstractButton decorateButton(AbstractButton button) {
        return AppPickerUI.decorateButton(button, this);
    }

    private void repaintAll() {
        if (this._comboBox != null) {
            this._comboBox.repaint();
        }
        if (this._button != null) {
            this._button.repaint();
        }
    }

    public void setInActiveView(boolean active) {
        if (!Themes.isThemed()) {
            return;
        }
        this._active = active;
    }

    private String getState() {
        if (!this._mouseOverButton && !this._mouseOverComboBox) {
            return this._active ? "active" : "inactive";
        }
        String state = "";
        if (!this._active) {
            state = "i";
        }
        if (this._mouseOverComboBox) {
            state = state + "mol";
        } else if (this._mouseOverButton) {
            state = state + "mor";
        }
        return state;
    }

    Painter getButtonPainter() {
        Theme theme = Themes.getActiveTheme();
        return theme.getStateProperties("apppkbtn", this._getButtonState()).getPainter("bg");
    }

    Painter getButtonFocusPainter() {
        Theme theme = Themes.getActiveTheme();
        return theme.getStateProperties("apppkbtn", "focus").getPainter("bg");
    }

    private String _getButtonState() {
        AbstractButton b = this._button;
        String state = "default";
        if (b.getModel().isArmed() && b.getModel().isPressed()) {
            state = "down";
        } else if (b.getModel().isRollover()) {
            state = "over";
        } else if (b.getModel().isSelected()) {
            state = "selected";
        }
        return state;
    }

    Painter getComboBoxPainter() {
        Theme theme = Themes.getActiveTheme();
        return theme.getStateProperties("apppkcmb", this.getState()).getPainter("bg");
    }

    static AppPickerUI get(JComponent component) {
        return (AppPickerUI)component.getClientProperty("apui");
    }

    private static AbstractButton decorateButton(AbstractButton button, final AppPickerUI ui) {
        if (!Themes.isThemed()) {
            return button;
        }
        button.putClientProperty("apui", ui);
        button.setUI((ButtonUI)((Object)new AppPickerButtonUI()));
        button.setHorizontalAlignment(0);
        button.setIcon(Themes.getActiveTheme().getStateProperties("apppkbtn", "default").getIcon("icon"));
        button.setPressedIcon(Themes.getActiveTheme().getStateProperties("apppkbtn", "pressed").getIcon("icon"));
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ui._mouseOverButton = true;
                ui.repaintAll();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ui._mouseOverButton = false;
                ui.repaintAll();
            }
        });
        return button;
    }

    private static JComboBox decorateComboBox(JComboBox box, final AppPickerUI ui) {
        if (!Themes.isThemed()) {
            return box;
        }
        box.putClientProperty("apui", ui);
        box.setUI((ComboBoxUI)((Object)new AppPickerComboBoxUI()));
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ui._mouseOverComboBox = true;
                ui.repaintAll();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ui._mouseOverComboBox = false;
                ui.repaintAll();
            }
        };
        for (int i = 0; i < box.getComponentCount(); ++i) {
            box.getComponent(i).addMouseListener(ml);
        }
        box.addMouseListener(ml);
        return box;
    }

    static {
        AdapterManager.Factory.getAdapterManager().registerFactory((AdapterFactory)new AdapterFactory<JComboBox, JComboBox>(){

            public JComboBox adapt(JComboBox obj) {
                AppPickerUI ui = new AppPickerUI();
                ui.setComboBox(obj);
                return ui._comboBox;
            }
        });
        AdapterManager.Factory.getAdapterManager().registerFactory((AdapterFactory)new AdapterFactory<AbstractButton, AbstractButton>(){

            public AbstractButton adapt(AbstractButton obj) {
                AppPickerUI ui = new AppPickerUI();
                ui.setButton(obj);
                return ui._button;
            }
        });
    }
}

