/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.explorer.Explorer;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.AbstractLayoutListener;
import oracle.ide.layout.Layout;
import oracle.ide.layout.URL2String;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.resource.ExplorerArb;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.DynamicStatusProvider;
import oracle.ide.view.Pinnable;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.navigator.NavigatorBundle;
import oracle.ideri.util.Product;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.GraphicsUtils;

public class ExplorerWindowImpl
extends ExplorerWindow
implements ListSelectionListener,
DynamicStatusProvider {
    private static final String TARGET_PROP = ".pinTarget";
    private static final String EXPLORER_PROP = ".explorerType";
    private static final String PROJECT_PROP = ".project";
    private static final String WORKSPACE_PROP = ".workspace";
    private static ExplorerManager MANAGER = ExplorerManager.getExplorerManager();
    private JPanel gui;
    private CustomTab tabs;
    private FocusableLabel defaultLabel;
    private JScrollPane defaultStructure;
    private String defaultText;
    private Explorer explorer;
    private URL pinTarget;
    private URL pinTargetProject;
    private URL pinTargetWorkspace;
    private Class explorerType;
    private TargetMonitor targetMonitor;
    private Context context;
    private PropertyAccess properties;
    private ArrayList changeListeners = new ArrayList();
    private Controller controller = new ChainedController();
    private boolean shownCalled = false;
    private boolean loading = false;
    private Map<String, String> lastSelectedPageCaption = new HashMap<String, String>();
    private PinStateMonitor _pinStateMonitor;
    private Object closedObject;
    private NodeListener reopenListener = new NodeListener(){

        public void nodeWillOpen(NodeEvent e) {
            e.getNode().removeNodeListener((NodeListener)this);
            ExplorerWindowImpl.this.closedObject = null;
        }
    };
    private boolean _alreadyUpdating = false;

    protected ExplorerWindowImpl(String viewId) {
        super(viewId);
    }

    public int getType() {
        return super.getType() | 0x20;
    }

    CustomTab getTabs() {
        return this.tabs;
    }

    public void setToolbarVisible(boolean visible) {
        super.setToolbarVisible(visible);
        if (this.gui != null) {
            if (this.isToolbarVisible) {
                if (this.toolbar == null) {
                    this.tabs = new CustomTab(3);
                    this.tabs.setShowIcons(false);
                    this.tabs.setGapBeforeTabs(-1);
                    this.tabs.setOffsetSelected(0);
                    this.tabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
                    this.tabs.addSelectionListener((ListSelectionListener)this);
                    this.tabs.setTabComponentOwner((JComponent)this.gui);
                    this.toolbar = new Toolbar();
                    this.updateToolbar(false);
                    this.gui.add((Component)this.toolbar, "North");
                    this.gui.add((Component)this.tabs, "South");
                    this.viewSelectionChanged(this.getContext());
                    this.forceRepaint();
                } else {
                    this.tabs.addSelectionListener((ListSelectionListener)this);
                    this.gui.add((Component)this.toolbar, "North");
                    this.gui.add((Component)this.tabs, "South");
                    this.forceRepaint();
                }
            } else if (this.toolbar != null) {
                this.gui.remove((Component)this.toolbar);
                this.gui.remove((Component)this.tabs);
                this.tabs.removeSelectionListener((ListSelectionListener)this);
                this.forceRepaint();
            }
        }
    }

    private void forceRepaint() {
        this.gui.invalidate();
        this.gui.validate();
        this.gui.revalidate();
        this.gui.repaint();
    }

    public synchronized Explorer getExplorer() {
        return this.explorer;
    }

    protected String getDefaultText() {
        return this.defaultText;
    }

    protected void setDefaultText(String text) {
        this.defaultText = text;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setContext(Context context) {
        if (this.gui == null) {
            this.context = context;
        } else {
            super.setContext(context);
        }
    }

    public Context getContext(EventObject e) {
        Context context = null;
        if (this.explorer != null && (context = this.explorer.getContext(e)) != null) {
            context = new Context(context);
            context.setView((View)this);
        }
        if (context == null) {
            context = Context.newIdeContext((View)this, (EventObject)e);
            context.setEvent(e);
        }
        return context;
    }

    public HelpInfo getHelpInfo() {
        HelpInfo info;
        HelpInfo helpInfo = info = this.explorer != null ? this.explorer.getHelpInfo() : null;
        if (info == null || info.getHelpTopicID() == null || info == HelpInfo.getDefaultHelpInfo()) {
            info = new HelpInfo(this.getDefaultHelpTag());
            info.setContext(this.getContext());
        }
        return info;
    }

    protected String getDefaultHelpTag() {
        return "f1_idestructurepane_html";
    }

    public ContextMenu getContextMenu() {
        return MANAGER.getContextMenu();
    }

    protected Element[] getSelectionFromUI() {
        if (this.explorer != null) {
            if (!this._alreadyUpdating) {
                this._alreadyUpdating = true;
                try {
                    this.explorer.updateSelection();
                }
                finally {
                    this._alreadyUpdating = false;
                }
            }
            return this.explorer.getSelection();
        }
        return super.getSelectionFromUI();
    }

    public String getMenuTitle() {
        return NavigatorBundle.get("EXPLORER");
    }

    public String getTabName() {
        if (this.isPinned()) {
            String name = null;
            if (this._node != null) {
                name = this._node.getShortLabel();
            } else if (this.targetMonitor != null && this.targetMonitor.target != null) {
                name = this.targetMonitor.target.getShortLabel();
            }
            return name != null ? name : ExplorerArb.getString((int)0);
        }
        return ExplorerArb.getString((int)0);
    }

    protected Icon getTabIconImpl() {
        return OracleIcons.getIcon((String)"structure.png");
    }

    protected String getTitleNameImpl() {
        String name;
        Explorer exp = this.getExplorer();
        String string = name = exp != null ? exp.getTitle() : null;
        if (name == null) {
            name = this._node != null ? this._node.getShortLabel() : null;
        }
        return name != null ? name + " - " + ExplorerArb.getString((int)0) : ExplorerArb.getString((int)0);
    }

    public int getDefaultVisibility(Layout layout) {
        String defaultVisibility = Product.isRaptor() ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
        String showStructure = layout.getProperty("Layout.ShowStructure", defaultVisibility);
        boolean visible = Boolean.valueOf(showStructure);
        return visible ? 1 : 0;
    }

    public Component getGUI() {
        if (this.gui == null) {
            this.gui = new JPanel();
            this.gui.setOpaque(false);
            this.defaultLabel = new FocusableLabel();
            this.defaultStructure = new JScrollPane();
            this.defaultStructure.setOpaque(false);
            this.defaultStructure.getViewport().setOpaque(false);
            this.defaultStructure.setBorder(BorderFactory.createEmptyBorder());
            if (this.defaultText == null) {
                this.defaultText = ExplorerArb.getString((int)1);
            }
            this.defaultLabel.setText(this.defaultText);
            this.defaultLabel.setOpaque(false);
            this.defaultStructure.setViewportView((Component)this.defaultLabel);
            this.gui.setLayout(new BorderLayout());
            this.gui.add((Component)this.defaultStructure, "Center");
            this.setToolbarVisible(this.isToolbarVisible);
            if (this.context != null) {
                this.setContext(this.context);
                this.context = null;
            }
            if (this.properties != null) {
                this.loadLayout(this.properties);
                this.properties = null;
            }
            if (this.explorer != null) {
                this._setExplorer(this.explorer);
                this.updateTitle(this.getTitleName());
                this.fireStateChanged();
            }
        }
        return this.gui;
    }

    public void activate() {
        if (this.explorer != null) {
            AccessibleContext ac;
            this.explorer.activate();
            JComponent deepestComp = GraphicsUtils.getFocusableComponentOrChild((Component)this.explorer.getGUI(), (boolean)true);
            if (deepestComp != null && deepestComp instanceof Accessible && (ac = ((Accessible)((Object)deepestComp)).getAccessibleContext()) != null && ac.getAccessibleName() == null) {
                ac.setAccessibleName(ExplorerArb.getString((int)0));
            }
        } else {
            super.activate();
        }
    }

    public void deactivate() {
        if (this.explorer != null) {
            this.explorer.deactivate();
        } else {
            super.deactivate();
        }
    }

    public void stateChange(int newState) {
        switch (newState) {
            case 2: {
                if (this.explorer == null) break;
                this.explorer.removeViewSelectionListener((ViewSelectionListener)this);
                if (!this.shownCalled) break;
                this.shownCalled = false;
                this.explorer.stateChanged(1);
                break;
            }
            case 1: {
                if (this.explorer == null) break;
                this.explorer.addViewSelectionListener((ViewSelectionListener)this);
                if (this.shownCalled) break;
                this.shownCalled = true;
                this.explorer.stateChanged(0);
                break;
            }
            case 3: {
                if (this.isSingleton()) break;
                this.setToolbarVisible(false);
            }
        }
        super.stateChange(newState);
    }

    public synchronized void viewSelectionChanged(ViewSelectionEvent e) {
        View view = e.getView();
        if (view == this.explorer) {
            this.updateSelection();
        } else {
            super.viewSelectionChanged(e);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Class<?> dataType;
        if (null == this.tabs) {
            return;
        }
        DefaultCustomTabPage page = (DefaultCustomTabPage)this.tabs.getPage(e.getFirstIndex());
        if (null == page) {
            return;
        }
        Object data = null != this._node ? this._node.getData() : null;
        Class<?> clazz = dataType = data != null ? data.getClass() : null;
        if (dataType != null) {
            this.lastSelectedPageCaption.put(dataType.toString(), page.getLabel());
        }
        this.toggleExplorer((Class)page.getUserObject());
    }

    public void toggleExplorer(Class type) {
        if (type == null) {
            return;
        }
        if (this.explorer == null || this.explorer.getClass() != type) {
            boolean hadFocus = GraphicsUtils.isAncestorOfFocusedComponent((Component)this.getGUI());
            Context ctx = new Context(this.getContext());
            ExplorerContext.setExplorerType((Context)ctx, (Class)type);
            if (hadFocus) {
                this.getGUI().requestFocus();
                if (this.explorer != null) {
                    this.explorer.deactivate();
                }
            }
            this.viewSelectionChanged(ctx);
            if (this.explorer != null && hadFocus) {
                GraphicsUtils.focusComponentOrChild((Component)this.explorer.getGUI(), (boolean)true);
                this.explorer.activate();
            }
        }
    }

    public void saveLayout(PropertyAccess layout) {
        Context ctx;
        if (this.gui == null) {
            return;
        }
        String id = this.getId();
        Context context = ctx = this.explorer != null ? this.explorer.getContext() : null;
        if (this.getPinState() == 2) {
            Node node = null;
            Project project = null;
            Workspace workspace = null;
            if (ctx != null) {
                node = ctx.getNode();
                project = ctx.getProject();
                workspace = ctx.getWorkspace();
            }
            this.persistPinTarget(node, project, workspace, false);
            if (this.pinTarget != null) {
                layout.setProperty(id + TARGET_PROP, URL2String.toString((URL)this.pinTarget));
                URL projectURL = project != null ? project.getURL() : null;
                layout.setProperty(id + PROJECT_PROP, URL2String.toString((URL)projectURL));
                URL workspaceURL = workspace != null ? workspace.getURL() : null;
                layout.setProperty(id + WORKSPACE_PROP, URL2String.toString((URL)workspaceURL));
                if (this.explorerType != null) {
                    layout.setProperty(id + EXPLORER_PROP, this.explorerType.getName());
                }
            } else {
                layout.removeProperty(id + TARGET_PROP);
                layout.removeProperty(id + EXPLORER_PROP);
            }
        } else {
            layout.removeProperty(id + TARGET_PROP);
            layout.removeProperty(id + EXPLORER_PROP);
            layout.removeProperty(id + PROJECT_PROP);
            layout.removeProperty(id + WORKSPACE_PROP);
        }
        if (layout instanceof DefaultStructuredPropertyAccess && !((DefaultStructuredPropertyAccess)layout).hasAttributes() && !((DefaultStructuredPropertyAccess)layout).hasChildNodes()) {
            layout.setProperty(id + ".placeholder", "foo");
        }
    }

    public void loadLayout(PropertyAccess properties) {
        if (this.gui == null) {
            this.properties = properties;
            return;
        }
        this.loading = true;
        this.pinTarget = null;
        this.pinTargetProject = null;
        this.pinTargetWorkspace = null;
        this.explorerType = null;
        this.setPinState(0);
        String id = this.getId();
        Node node = AbstractLayoutListener.getNode((String)(id + TARGET_PROP), (PropertyAccess)properties, (boolean)true);
        if (node != null) {
            this.pinTarget = node.getURL();
            this.pinTargetProject = ExplorerWindowImpl.getURLProperty(id + PROJECT_PROP, properties);
            this.pinTargetWorkspace = ExplorerWindowImpl.getURLProperty(id + WORKSPACE_PROP, properties);
            String clsName = properties.getProperty(id + EXPLORER_PROP, null);
            try {
                this.explorerType = Class.forName(clsName);
            }
            catch (Exception e) {
                this.explorerType = null;
            }
            this.setPinState(2);
        }
        this.loading = false;
        Explorer exp = this.getExplorer();
        if (exp instanceof Pinnable) {
            ((Pinnable)exp).setPinState(this.getPinState());
        }
    }

    private static URL getURLProperty(String propertyName, PropertyAccess properties) {
        String project = properties.getProperty(propertyName, null);
        if (project != null) {
            return URL2String.toURL((String)project);
        }
        return null;
    }

    public JComponent[] getCustomCells() {
        Explorer view = this.getExplorer();
        if (view instanceof StatusProvider) {
            return ((StatusProvider)view).getCustomCells();
        }
        return null;
    }

    public boolean isExpandable(JComponent customCell) {
        Explorer view = this.getExplorer();
        if (view instanceof StatusProvider) {
            return ((StatusProvider)view).isExpandable(customCell);
        }
        return false;
    }

    public void addChangeListener(ChangeListener l) {
        if (!this.changeListeners.contains(l)) {
            this.changeListeners.add(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.changeListeners.contains(l)) {
            this.changeListeners.remove(l);
        }
    }

    public synchronized void setPinState(int newState) {
        Explorer exp;
        super.setPinState(newState);
        if (!this.loading && (exp = this.getExplorer()) instanceof Pinnable) {
            ((Pinnable)exp).setPinState(this.getPinState());
        }
    }

    private void fireStateChanged() {
        ArrayList list = (ArrayList)this.changeListeners.clone();
        Iterator i = list.iterator();
        if (i != null) {
            ChangeEvent e = new ChangeEvent(this);
            while (i.hasNext()) {
                ((ChangeListener)i.next()).stateChanged(e);
            }
        }
    }

    protected boolean isViewSupported(View view) {
        return MANAGER.supportsStructure(view);
    }

    protected void viewSelectionChanged(Context context) {
        if (null != this.closedObject && (context.getNode() == this.closedObject || context.getElement() == this.closedObject)) {
            this.setExplorer(null);
            return;
        }
        if (this.closedObject instanceof Node) {
            ((Node)this.closedObject).removeNodeListener(this.reopenListener);
        }
        this.closedObject = null;
        super.viewSelectionChanged(context);
        this.setExplorer(MANAGER.getExplorerForHost((View)this, context));
        this.updateSelection();
    }

    public void update(final Object subject, final UpdateMessage msg) {
        int id;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExplorerWindowImpl.this.update(subject, msg);
                }
            });
            return;
        }
        int n = id = msg != null ? msg.getMessageID() : -1;
        if (id == UpdateMessage.OBJECT_OPENED) {
            if (this._pinStateMonitor == null) {
                this._pinStateMonitor = new PinStateMonitor();
            }
            this._pinStateMonitor.attach(this._node);
        } else if (id == UpdateMessage.OBJECT_RENAMED) {
            this.objectRenamed(subject, msg);
            if (this._pinStateMonitor == null) {
                this._pinStateMonitor = new PinStateMonitor();
            }
            this._pinStateMonitor.unpin();
            this._pinStateMonitor.attach(this._node);
        } else if (id == UpdateMessage.OBJECT_CLOSED) {
            this.objectClosed(subject, msg);
        }
    }

    protected boolean isSingleton() {
        return true;
    }

    private void selectTabFor(Explorer explorer) {
        if (explorer == null) {
            return;
        }
        if (this.tabs == null) {
            return;
        }
        int pageCount = this.tabs.getPageCount();
        if (pageCount <= 0) {
            return;
        }
        for (int i = 0; i < pageCount; ++i) {
            CustomTabPage page = this.tabs.getPage(i);
            if (!ExplorerWindowImpl.isPageFor(page, explorer)) continue;
            this.tabs.setSelectedPage(i);
            return;
        }
    }

    private static boolean isPageFor(CustomTabPage page, Explorer explorer) {
        if (page == null || explorer == null) {
            return false;
        }
        if (!(page instanceof DefaultCustomTabPage)) {
            return false;
        }
        Object userObj = ((DefaultCustomTabPage)page).getUserObject();
        if (!(userObj instanceof Class)) {
            return false;
        }
        return explorer.getClass().equals(userObj) || ((Class)userObj).isInstance(explorer);
    }

    protected void clear() {
        super.clear();
        this.setExplorer(null);
    }

    private void _setExplorer(Explorer explorer) {
        IconOverlayConsumer consumer;
        IconOverlayCache overlayCache;
        Component child;
        boolean toolbarDisplayed = this.toolbar == null ? false : this.toolbar.getParent() != null;
        this.gui.removeAll();
        if (this.explorer != null) {
            IconOverlayConsumer consumer2;
            IconOverlayCache overlayCache2;
            this.explorer.removeViewSelectionListener((ViewSelectionListener)this);
            if (this.shownCalled) {
                this.shownCalled = false;
                this.explorer.stateChanged(1);
            }
            if (this.explorer instanceof IconOverlayConsumer && (overlayCache2 = (consumer2 = (IconOverlayConsumer)this.explorer).getOverlayCache()) != null) {
                overlayCache2.deregisterOverlayConsumer(consumer2);
            }
        }
        this.explorer = explorer;
        if (!this.loading && explorer instanceof Pinnable) {
            ((Pinnable)explorer).setPinState(this.getPinState());
        }
        Component component = child = explorer != null ? explorer.getGUI() : null;
        if (child == null) {
            child = this.defaultStructure;
            this.defaultLabel.setText(this.getDefaultText());
        }
        this.gui.add(child, "Center");
        this.updateToolbar(true);
        if (toolbarDisplayed) {
            this.gui.add((Component)this.toolbar, "North");
            this.gui.add((Component)this.tabs, "South");
        }
        if (explorer != null) {
            explorer.addViewSelectionListener((ViewSelectionListener)this);
            if (!this.shownCalled) {
                this.shownCalled = true;
                explorer.stateChanged(0);
            }
        }
        if (explorer instanceof IconOverlayConsumer && (overlayCache = (consumer = (IconOverlayConsumer)explorer).getOverlayCache()) != null) {
            overlayCache.registerOverlayConsumer(consumer);
        }
        this.selectTabFor(explorer);
        this.gui.revalidate();
        this.gui.repaint();
    }

    protected synchronized void setExplorer(Explorer explorer) {
        if (this.gui != null) {
            if (this.explorer != explorer) {
                this._setExplorer(explorer);
            } else if (this.explorer == null) {
                this.defaultLabel.setText(this.getDefaultText());
                this.gui.repaint();
            }
            this.updateTitle(this.getTitleName());
            this.fireStateChanged();
        } else {
            this.explorer = explorer;
        }
    }

    protected void persistPinTarget() {
        this.persistPinTarget(this._node, this.getContext().getProject(), this.getContext().getWorkspace(), true);
    }

    private void persistPinTarget(Node node, Project p, Workspace w, boolean attachMonitor) {
        if (this.getPinState() == 0) {
            this.pinTarget = null;
            this.explorerType = null;
            this.pinTargetProject = null;
            this.pinTargetWorkspace = null;
            return;
        }
        this.pinTarget = node != null ? node.getURL() : null;
        this.explorerType = this.explorer != null ? this.explorer.getClass() : null;
        this.pinTargetProject = p != null ? p.getURL() : null;
        URL uRL = this.pinTargetWorkspace = w != null ? w.getURL() : null;
        if (attachMonitor && this.pinTarget != null) {
            this.getTargetMonitor().monitor(node);
        }
    }

    protected void restorePinTarget() {
        if (this.targetMonitor != null) {
            this.targetMonitor.reset();
        }
        if (this.pinTarget != null) {
            try {
                Node node = NodeFactory.findOrCreate((URL)this.pinTarget);
                Context ctx = this.getContext();
                ctx.setNode(node);
                if (this.pinTargetProject != null && this.pinTargetWorkspace != null) {
                    Node project = NodeFactory.findOrCreate((URL)this.pinTargetProject);
                    Node workspace = NodeFactory.findOrCreate((URL)this.pinTargetWorkspace);
                    ctx.setProject(project instanceof Project ? (Project)project : Ide.getActiveProject());
                    ctx.setWorkspace(workspace instanceof Workspace ? (Workspace)workspace : Ide.getActiveWorkspace());
                }
                ExplorerContext.setExplorerType((Context)ctx, (Class)this.explorerType);
                this.viewSelectionChanged(ctx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pinTarget = null;
            this.pinTargetProject = null;
            this.pinTargetWorkspace = null;
            this.explorerType = null;
        }
    }

    protected void objectClosed(Object subject, UpdateMessage msg) {
        this.closedObject = subject;
        if (this.closedObject instanceof Node) {
            ((Node)this.closedObject).addNodeListener(this.reopenListener);
        }
        if (this._pinStateMonitor == null) {
            this.setPinState(0);
        }
        String oldText = this.getDefaultText();
        this.setDefaultText(ExplorerArb.getString((int)2));
        super.objectClosed(subject, msg);
        this.setDefaultText(oldText);
    }

    protected void objectRenamed(Object subject, UpdateMessage msg) {
        Node target = null;
        List list = msg.getAddObjects();
        if (!list.isEmpty()) {
            target = (Node)list.get(0);
        } else {
            target = RenameMessage.getRenamedNode((UpdateMessage)msg);
            if (target == null) {
                target = this._node;
            }
        }
        this.persistPinTarget(target, this.getContext().getProject(), this.getContext().getWorkspace(), false);
        this.clear();
        this.restorePinTarget();
        this.setPinState(this.getPinState());
    }

    private TargetMonitor getTargetMonitor() {
        if (this.targetMonitor == null) {
            this.targetMonitor = new TargetMonitor();
        }
        return this.targetMonitor;
    }

    private void updateToolbar(boolean dispose) {
        if (this.toolbar == null) {
            return;
        }
        this.tabs.removeSelectionListener((ListSelectionListener)this);
        this.tabs.removeAllPages();
        if (dispose) {
            this.toolbar.dispose();
        }
        this.toolbar.removeAll();
        List types = MANAGER.getExplorerTypes((Element)this._node, this.getContext());
        Iterator i = types != null ? types.iterator() : null;
        Class<?> dataType = null;
        if (i != null && i.hasNext()) {
            DefaultListModel<DefaultCustomTabPage> model = new DefaultListModel<DefaultCustomTabPage>();
            Explorer exp = this.getExplorer();
            Class<?> current = exp != null ? exp.getClass() : null;
            DefaultCustomTabPage defaultPage = null;
            Object data = this._node.getData();
            Class<?> clazz = dataType = data != null ? data.getClass() : null;
            while (i.hasNext()) {
                Class type = (Class)i.next();
                String caption = MANAGER.getExplorerCaption(type, dataType);
                Icon icon = MANAGER.getExplorerIcon(type, dataType);
                DefaultCustomTabPage page = new DefaultCustomTabPage(icon, null, (Object)type);
                page.setLabel(caption);
                model.addElement(page);
                if (type != current) continue;
                defaultPage = page;
            }
            this.tabs.setModel(model);
            this.toolbar.setVisible(true);
            this.tabs.setVisible(model.getSize() > 1);
            this.tabs.setPreferredSize(null);
            int pageIndex = this.findLastSelectedPageByCaption(dataType);
            this.tabs.setSelectedPage(pageIndex != -1 ? pageIndex : this.tabs.searchPage((CustomTabPage)defaultPage));
            CustomTabPage selectedPage = this.tabs.getPage(this.tabs.getSelectedPage());
            if (dataType != null) {
                this.lastSelectedPageCaption.put(dataType.toString(), selectedPage.getLabel());
            }
            this.tabs.addSelectionListener((ListSelectionListener)this);
        } else {
            this.toolbar.setVisible(false);
            this.tabs.setVisible(false);
        }
        ExplorerWindowImpl.updateToolbarActions((Toolbar)this.getToolbar());
    }

    private int findLastSelectedPageByCaption(Class dataType) {
        if (dataType == null) {
            return -1;
        }
        String key = dataType.toString();
        String caption = this.lastSelectedPageCaption.get(key);
        if (caption == null) {
            return -1;
        }
        int pageCount = this.tabs.getPageCount();
        for (int i = 0; i < pageCount; ++i) {
            CustomTabPage page = this.tabs.getPage(i);
            if (!caption.equals(page.getLabel())) continue;
            return i;
        }
        return -1;
    }

    private final class ChainedController
    implements Controller {
        private ChainedController() {
        }

        public boolean handleEvent(IdeAction action, Context context) {
            Controller controller;
            Explorer view = ExplorerWindowImpl.this.getExplorer();
            Controller controller2 = controller = view != null ? view.getController() : null;
            if (controller != null && controller.handleEvent(action, context)) {
                return true;
            }
            return controller != MANAGER ? MANAGER.handleEvent(action, context) : false;
        }

        public boolean update(IdeAction action, Context context) {
            Controller controller;
            Explorer view = ExplorerWindowImpl.this.getExplorer();
            Controller controller2 = controller = view != null ? view.getController() : null;
            if (controller != null) {
                try {
                    if (controller.update(action, context)) {
                        action.putValue("controller-handling-update", (Object)controller.getClass().getName());
                        return true;
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            return controller != MANAGER ? MANAGER.update(action, context) : false;
        }
    }

    private final class TargetMonitor
    implements Observer {
        Node target;

        private TargetMonitor() {
        }

        public void reset() {
            if (this.target != null) {
                this.target.detach((Observer)this);
                this.target = null;
            }
        }

        public void monitor(Node target) {
            this.reset();
            this.target = target;
            if (this.target != null) {
                this.target.attach((Observer)this);
            }
        }

        public void update(Object observed, UpdateMessage msg) {
            if (msg.getMessageID() == UpdateMessage.OBJECT_RENAMED) {
                List list = msg.getAddObjects();
                Node node = null;
                if (!list.isEmpty()) {
                    node = (Node)list.get(0);
                } else {
                    node = RenameMessage.getRenamedNode((UpdateMessage)msg);
                    if (node == null) {
                        node = (Node)observed;
                    }
                }
                ExplorerWindowImpl.this.pinTarget = node != null ? node.getURL() : null;
                ExplorerWindowImpl.this.pinTargetProject = msg.getContext().getProject().getURL();
                ExplorerWindowImpl.this.pinTargetWorkspace = msg.getContext().getWorkspace().getURL();
                if (node != this.target) {
                    this.monitor(node);
                }
            }
        }
    }

    private class PinStateMonitor
    extends NodeListener {
        private Node node;

        private PinStateMonitor() {
        }

        void attach(Node node) {
            if (this.node != node) {
                this.dettach();
                this.node = node;
                if (null != this.node) {
                    this.node.addNodeListener((NodeListener)this);
                }
            }
        }

        void dettach() {
            if (this.node != null) {
                this.node.removeNodeListener((NodeListener)this);
            }
            this.node = null;
        }

        void unpin() {
            ExplorerWindowImpl.this.setPinState(0);
            this.dettach();
        }

        public void nodeWillClose(NodeEvent e) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.unpin();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PinStateMonitor.this.unpin();
                    }
                });
            }
        }
    }
}

