/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.templates;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.templates.Template;
import oracle.jrf.templates.WlsTemplateBuilder;

public class TemplateHelper {
    private static TemplateHelper instance;
    protected static final String WLS_TEMPLATE_FOLDER = "common/templates/wls/";
    protected static final String WLS_JRF_TEMPLATE_FOLDER = "../wlserver/common/templates/wls/";
    protected static final String OLD_WLS_TEMPLATE_FOLDER = "common/templates/applications/";
    private Map<String, Template> wlsTemplates = new HashMap<String, Template>();

    public static TemplateHelper getInstance() {
        if (instance == null) {
            instance = new TemplateHelper();
        }
        return instance;
    }

    public Template getTemplate(boolean wlsTemplate, String oracleHome, String templateFileName) throws PortabilityLayerException {
        Map<String, Template> templates = this.wlsTemplates;
        String templateId = oracleHome + "_" + templateFileName;
        Template template = templates.get(templateId);
        if (template == null && wlsTemplate) {
            WlsTemplateBuilder builder = new WlsTemplateBuilder();
            template = builder.getTemplate();
            templates.put(templateId, template);
            File templateFile = new File(oracleHome, WLS_TEMPLATE_FOLDER + File.separator + templateFileName);
            if (templateFile.exists()) {
                builder.initTemplate(templateFile);
            } else {
                templateFile = new File(oracleHome, WLS_JRF_TEMPLATE_FOLDER + File.separator + templateFileName);
                if (templateFile.exists()) {
                    builder.initTemplate(templateFile);
                } else {
                    builder.initTemplate(new File(oracleHome, OLD_WLS_TEMPLATE_FOLDER + File.separator + templateFileName));
                }
            }
        }
        return template;
    }
}

