/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.templates;

import java.util.ArrayList;
import java.util.List;
import oracle.jrf.JrfUtils;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.templates.NamedResource;
import oracle.jrf.templates.Template;
import oracle.jrf.templates.TemplateHelper;

public class JRFTemplateHelper {
    public static final String JRF_ALL_APPS_TAG = "JRF-ALL-APPS";
    public static final String JRF_ADMIN_APPS_TAG = "JRF-ADMIN-APPS";
    public static final String JRF_DMGR_APPS_TAG = "JRF-DMGR-APPS";
    public static final String APP_DEPLOYMENT = "app-deployment";
    public static final String LIBRARY = "library";
    public static final String STARTUP_CLASS = "startup-class";
    public static final String SHUTDOWN_CLASS = "shutdown-class";
    public static final String JDBC_SYSTEM_RESOURCE = "jdbc-system-resource";
    public static final String WLDF_SYSTEM_RESOURCE = "wldf-system-resource";
    public static final String CUSTOM_SERVICE = "custom-service";
    public static final String URL_PROVIDER = "url-provider";

    public static List<? extends NamedResource> getJRFManagedResourcesFromTemplate(String resourceType, Template template) throws PortabilityLayerException {
        ArrayList<String> configGroups = new ArrayList<String>();
        configGroups.add(JRF_ALL_APPS_TAG);
        configGroups.addAll(template.getConfigGroupReferences(JRF_ALL_APPS_TAG));
        return JRFTemplateHelper.getJRFResourcesFromTemplate(configGroups.toArray(new String[0]), resourceType, template);
    }

    public static List<? extends NamedResource> getJRFAdminResourcesFromTemplate(String resourceType, Template template) throws PortabilityLayerException {
        ArrayList<String> configGroups = new ArrayList<String>();
        configGroups.add(JRF_ALL_APPS_TAG);
        configGroups.add(JRF_ADMIN_APPS_TAG);
        configGroups.addAll(template.getConfigGroupReferences(JRF_ALL_APPS_TAG));
        configGroups.addAll(template.getConfigGroupReferences(JRF_ADMIN_APPS_TAG));
        return JRFTemplateHelper.getJRFResourcesFromTemplate(configGroups.toArray(new String[0]), resourceType, template);
    }

    public static List<? extends NamedResource> getJRFAdminOnlyResourcesFromTemplate(String resourceType, Template template) throws PortabilityLayerException {
        ArrayList<String> configGroups = new ArrayList<String>();
        configGroups.add(JRF_ADMIN_APPS_TAG);
        configGroups.addAll(template.getConfigGroupReferences(JRF_ADMIN_APPS_TAG));
        return JRFTemplateHelper.getJRFResourcesFromTemplate(configGroups.toArray(new String[0]), resourceType, template);
    }

    public static List<? extends NamedResource> getJRFDmgrResourcesFromTemplate(String resourceType, Template template) throws PortabilityLayerException {
        ArrayList<String> configGroups = new ArrayList<String>();
        configGroups.add(JRF_DMGR_APPS_TAG);
        configGroups.addAll(template.getConfigGroupReferences(JRF_ADMIN_APPS_TAG));
        return JRFTemplateHelper.getJRFResourcesFromTemplate(configGroups.toArray(new String[0]), resourceType, template);
    }

    private static List<? extends NamedResource> getJRFResourcesFromTemplate(String[] configGroups, String resourceType, Template template) throws PortabilityLayerException {
        ArrayList<NamedResource> namedResources = new ArrayList<NamedResource>();
        for (String groupName : configGroups) {
            namedResources.addAll(JRFTemplateHelper.getResourceListFromTemplate(groupName, resourceType, template));
            for (Template subTemplate : template.getSubTemplates()) {
                namedResources.addAll(JRFTemplateHelper.getResourceListFromTemplate(groupName, resourceType, subTemplate));
            }
        }
        return namedResources;
    }

    private static List<? extends NamedResource> getResourceListFromTemplate(String groupName, String resourceType, Template template) {
        if (resourceType.equals(APP_DEPLOYMENT)) {
            return template.getApplications(groupName);
        }
        if (resourceType.equals(LIBRARY)) {
            return template.getLibraries(groupName);
        }
        if (resourceType.equals(SHUTDOWN_CLASS)) {
            return template.getShutdownClasses(groupName);
        }
        if (resourceType.equals(STARTUP_CLASS)) {
            return template.getStartupClasses(groupName);
        }
        if (resourceType.equals(JDBC_SYSTEM_RESOURCE)) {
            return template.getJDBCSystemResources(groupName);
        }
        if (resourceType.equals(WLDF_SYSTEM_RESOURCE)) {
            return template.getWLDFSystemResources(groupName);
        }
        if (resourceType.equals(CUSTOM_SERVICE)) {
            return template.getStartupClasses(groupName);
        }
        if (resourceType.equals(URL_PROVIDER)) {
            return template.getURLProviders(groupName);
        }
        return null;
    }

    public static Template getJRFTemplateForWLS() throws PortabilityLayerException {
        if (Boolean.getBoolean("oracle.jrf.restrictedMode")) {
            return TemplateHelper.getInstance().getTemplate(true, JrfUtils.getCommonComponentsHome(), "oracle.jrf_restricted_template.jar");
        }
        return TemplateHelper.getInstance().getTemplate(true, JrfUtils.getCommonComponentsHome(), "oracle.jrf_template.jar");
    }

    public static Template getJRFTemplateForWLS(String templatestr) throws PortabilityLayerException {
        if (templatestr.indexOf("Oracle Restricted JRF:") > -1) {
            return TemplateHelper.getInstance().getTemplate(true, JrfUtils.getCommonComponentsHome(), "oracle.jrf_restricted_template.jar");
        }
        if (templatestr.indexOf("Oracle JRF Cloud:") > -1) {
            return TemplateHelper.getInstance().getTemplate(true, JrfUtils.getCommonComponentsHome(), "oracle.jrf_cloud_template.jar");
        }
        return TemplateHelper.getInstance().getTemplate(true, JrfUtils.getCommonComponentsHome(), "oracle.jrf_template.jar");
    }
}

