/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Scanner;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import oracle.core.ojdl.logging.config.LoggingConfigUtil;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public class InternalJrfUtils {
    static final String WL_JMX_SERVICE_URL_PATTERN = "service:jmx:t3://{0}:{1}/jndi/{2}";
    public static final String ORA_LOGGING_EXCLUSION_FILE = "loggers.exclude";
    public static final String ORA_TARGET_LOGFILE = "logging.xml";
    public static final String ORA_LOG_TEMPLATE = "logging-template.xml";
    public static final String ORA_LOGGER_SUFFIX = "logging.xml";
    public static final String ORA_LOGGER_DIR = "logging";
    public static final String ORA_SERVER_CONFIG_TEMPLATE_DIR = "server-config-template";
    static ArrayList<String> discovered_loggers;
    static ArrayList<String> excluded_loggers;
    static ArrayList<String> new_loggers;
    public static final String[][] WL_TYPE_TO_MBEAN_LOOKUPSERVICE;

    public static void copyDir(File inDir, File outDir, boolean shouldOverride) throws IOException {
        for (File child : inDir.listFiles()) {
            if (child.getName().equals("logging.xml")) continue;
            File outChild = new File(outDir, child.getName());
            if (child.isDirectory()) {
                outChild.mkdir();
                InternalJrfUtils.copyDir(child, outChild, shouldOverride);
                continue;
            }
            if (outChild.exists() && !shouldOverride) continue;
            InternalJrfUtils.copyStream(new FileInputStream(child), new FileOutputStream(outChild));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(FileInputStream in, FileOutputStream out) throws IOException {
        try {
            int lengthRead;
            byte[] buffer = new byte[10240];
            while ((lengthRead = in.read(buffer)) >= 0) {
                out.write(buffer, 0, lengthRead);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    public static void initServerConfigTemplateDir(File domainConfigDir, File oraHomeDir) throws PortabilityLayerException {
        File srvConfigTemplateDir = new File(domainConfigDir, ORA_SERVER_CONFIG_TEMPLATE_DIR);
        if (!srvConfigTemplateDir.exists()) {
            srvConfigTemplateDir.mkdirs();
        }
        File modulesDir = new File(oraHomeDir, "modules");
        for (File componentDir : modulesDir.listFiles()) {
            if (!componentDir.isDirectory()) continue;
            for (File componentChildDir : componentDir.listFiles()) {
                if (!componentChildDir.isDirectory() || !componentChildDir.getName().equals("server_config")) continue;
                try {
                    InternalJrfUtils.copyDir(componentChildDir, srvConfigTemplateDir, false);
                }
                catch (IOException e) {
                    throw new PortabilityLayerException(e);
                }
            }
        }
    }

    public static void copyServerConfigTemplateToServerDir(File domainConfigDir, File oraHomeDir, File serverConfigDir) throws Exception {
        File srvConfigTemplateDir = new File(domainConfigDir, ORA_SERVER_CONFIG_TEMPLATE_DIR);
        if (!srvConfigTemplateDir.exists()) {
            InternalJrfUtils.initServerConfigTemplateDir(domainConfigDir, oraHomeDir);
        }
        if (!serverConfigDir.exists()) {
            serverConfigDir.mkdirs();
        }
        try {
            InternalJrfUtils.copyDir(srvConfigTemplateDir, serverConfigDir, false);
            InternalJrfUtils.copyLoggingTemplateToServerDir(domainConfigDir, serverConfigDir);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10006", new String[]{serverConfigDir.getAbsolutePath(), e.getMessage()}), e);
        }
    }

    public static void copyConfigsToServerDir(File oraHomeDir, File serverConfigDir) throws Exception {
        if (!serverConfigDir.exists()) {
            serverConfigDir.mkdirs();
        }
        File modulesDir = new File(oraHomeDir, "modules");
        for (File componentDir : modulesDir.listFiles()) {
            if (!componentDir.isDirectory()) continue;
            for (File componentChildDir : componentDir.listFiles()) {
                if (!componentChildDir.isDirectory() || !componentChildDir.getName().equals("server_config")) continue;
                try {
                    InternalJrfUtils.copyDir(componentChildDir, serverConfigDir, false);
                }
                catch (IOException e) {
                    throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10006", new String[]{componentChildDir.getAbsolutePath(), serverConfigDir.getAbsolutePath(), e.getMessage()}), e);
                }
            }
        }
        try {
            InternalJrfUtils.copyLoggingTemplateToServerDir(serverConfigDir);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10006", new String[]{serverConfigDir.getAbsolutePath(), e.getMessage()}), e);
        }
    }

    public static void copyLoggingTemplateToServerDir(File serverDir) throws Exception {
        File logTemplate = new File(serverDir.getParentFile().getParentFile(), ORA_LOG_TEMPLATE);
        File logTarget = new File(serverDir, "logging.xml");
        if (logTemplate.exists() && !logTarget.exists()) {
            InternalJrfUtils.copyStream(new FileInputStream(logTemplate), new FileOutputStream(logTarget));
        }
    }

    private static void copyLoggingTemplateToServerDir(File domainConfigDir, File serverDir) throws Exception {
        File logTemplate = new File(domainConfigDir, ORA_LOG_TEMPLATE);
        File logTarget = new File(serverDir, "logging.xml");
        if (logTemplate.exists() && !logTarget.exists()) {
            InternalJrfUtils.copyStream(new FileInputStream(logTemplate), new FileOutputStream(logTarget));
        }
    }

    public static void mergeLoggersFromDir(File domainConfigDir, File serverDir, File loggingTarget) throws Exception {
        File exclusionFile = new File(serverDir, ORA_LOGGING_EXCLUSION_FILE);
        File domainLoggersDir = new File(domainConfigDir, ORA_LOGGER_DIR);
        if (!domainLoggersDir.exists()) {
            return;
        }
        if (!loggingTarget.exists()) {
            return;
        }
        ArrayList<String> loggersToMerge = InternalJrfUtils.getNewLoggers(domainLoggersDir, exclusionFile);
        InternalJrfUtils.updateLoggerExclusionList(domainLoggersDir, exclusionFile);
        for (String logger : loggersToMerge) {
            File loggerFile = new File(domainLoggersDir, logger);
            try {
                LoggingConfigUtil.mergeConfiguration((String)loggerFile.getPath(), (String)loggingTarget.getPath());
            }
            catch (Exception e) {
                if (e.getMessage().contains("ODL-52065")) continue;
                throw e;
            }
        }
    }

    public static ArrayList<String> getDiscoveredLoggers(File domainLoggersDir) throws IOException {
        if (discovered_loggers != null) {
            return discovered_loggers;
        }
        discovered_loggers = new ArrayList();
        File[] fileList = domainLoggersDir.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File current = fileList[i];
            if (!current.getName().endsWith("logging.xml")) continue;
            discovered_loggers.add(current.getName());
        }
        return discovered_loggers;
    }

    public static ArrayList<String> getExcludedLoggers(File exclusionFile) throws IOException {
        if (excluded_loggers != null) {
            return excluded_loggers;
        }
        excluded_loggers = new ArrayList();
        if (!exclusionFile.exists()) {
            exclusionFile.createNewFile();
            return excluded_loggers;
        }
        Scanner exin = new Scanner(exclusionFile);
        exin.reset();
        while (exin.hasNext()) {
            String name = exin.nextLine().trim();
            excluded_loggers.add(name);
        }
        exin.close();
        return excluded_loggers;
    }

    public static ArrayList<String> getNewLoggers(File domainLoggersDir, File exclusionFile) throws IOException {
        if (new_loggers != null) {
            return new_loggers;
        }
        new_loggers = new ArrayList();
        ArrayList<String> excluded = InternalJrfUtils.getExcludedLoggers(exclusionFile);
        ArrayList<String> discovered = InternalJrfUtils.getDiscoveredLoggers(domainLoggersDir);
        for (String found : discovered) {
            if (excluded.contains(found)) continue;
            new_loggers.add(found);
        }
        return new_loggers;
    }

    public static void updateLoggerExclusionList(File domainLoggersDir, File exclusionFile) throws IOException {
        ArrayList<String> excluded = InternalJrfUtils.getExcludedLoggers(exclusionFile);
        ArrayList<String> newLoggers = InternalJrfUtils.getNewLoggers(domainLoggersDir, exclusionFile);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(exclusionFile.getPath())));
        excluded.addAll(newLoggers);
        for (String logger : excluded) {
            out.println(logger);
        }
        out.flush();
        out.close();
        InternalJrfUtils.resetLoggerVars();
    }

    public static void resetLoggerVars() {
        new_loggers = null;
        excluded_loggers = null;
        discovered_loggers = null;
    }

    public static void clearLoggerExclusionList(File exclusionFile) throws IOException {
        FileWriter out = new FileWriter(exclusionFile);
        out.close();
        InternalJrfUtils.resetLoggerVars();
    }

    public static void delete(File fileOrDir) throws Exception {
        if (!fileOrDir.exists()) {
            return;
        }
        if (fileOrDir.isFile()) {
            fileOrDir.delete();
        } else {
            for (File file : fileOrDir.listFiles()) {
                InternalJrfUtils.delete(file);
            }
            fileOrDir.delete();
        }
        if (fileOrDir.exists()) {
            throw new Exception("Unable to delete" + fileOrDir.getAbsolutePath());
        }
    }

    public static MBeanServerConnection getWlsEditConnection(String hostname, String portString, String username, String password) throws Exception {
        return InternalJrfUtils.getWlsConnection(hostname, portString, username, password, "weblogic.management.mbeanservers.edit");
    }

    public static MBeanServerConnection getWlsConnection(String hostname, String portString, String username, String password, String mbeanServer) throws IOException, MalformedURLException {
        String urlString = MessageFormat.format(WL_JMX_SERVICE_URL_PATTERN, hostname, portString, mbeanServer);
        JMXServiceURL jmxServiceUrl = new JMXServiceURL(urlString);
        Hashtable<String, Object> env = new Hashtable<String, Object>(4);
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        env.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        env.put("jmx.remote.x.request.waiting.timeout", new Long(300000L));
        JMXConnector connector = JMXConnectorFactory.connect(jmxServiceUrl, env);
        return connector.getMBeanServerConnection();
    }

    public static ObjectName activate(MBeanServerConnection editConn, ObjectName cfgMgr) throws Exception {
        ObjectName task = (ObjectName)editConn.invoke(cfgMgr, "activate", new Object[]{new Long(120000L)}, new String[]{"java.lang.Long"});
        return task;
    }

    public static ObjectName lookupMBean(MBeanServerConnection editConn, ObjectName cfgRoot, String serviceName, String objectName) throws Exception {
        return (ObjectName)editConn.invoke(cfgRoot, serviceName, new Object[]{objectName}, new String[]{"java.lang.String"});
    }

    public static ObjectName startEditSession(MBeanServerConnection editConn, ObjectName cfgMgr) throws Exception {
        ObjectName domainConfigRoot = (ObjectName)editConn.invoke(cfgMgr, "startEdit", new Object[]{new Integer(60000), new Integer(120000)}, new String[]{"java.lang.Integer", "java.lang.Integer"});
        if (domainConfigRoot == null) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10019", new String[0]));
        }
        return domainConfigRoot;
    }

    public static void addTarget(MBeanServerConnection conn, ObjectName comp, ObjectName target) throws Exception {
        conn.invoke(comp, "addTarget", new Object[]{target}, new String[]{"javax.management.ObjectName"});
    }

    public static void removeTarget(MBeanServerConnection conn, ObjectName comp, ObjectName target) throws Exception {
        conn.invoke(comp, "removeTarget", new Object[]{target}, new String[]{"javax.management.ObjectName"});
    }

    static {
        WL_TYPE_TO_MBEAN_LOOKUPSERVICE = new String[][]{{"app-deployment", "lookupAppDeployment"}, {"library", "lookupLibrary"}, {"shutdown-class", "lookupShutdownClass"}, {"startup-class", "lookupStartupClass"}, {"jdbc-system-resource", "lookupJDBCSystemResource"}, {"wldf-system-resource", "lookupWLDFSystemResource"}};
    }
}

