/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.x509;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import oracle.security.xmlsec.keys.X509Data;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.WSSecurityTokenReferenceType;
import oracle.security.xmlsec.wss.x509.X509BinarySecurityToken;
import oracle.security.xmlsec.wss.x509.X509IssuerSerialResolver;
import oracle.security.xmlsec.wss.x509.X509IssuerSerialResolverException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class X509IssuerSerial
extends XMLElement
implements WSSecurityTokenReferenceType {
    private static ArrayList resolverList = new ArrayList();

    public X509IssuerSerial(Element element) {
        super(element);
    }

    public X509IssuerSerial(Element element, String systemId) {
        super(element, systemId);
    }

    public X509IssuerSerial(Document owner) {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        this.addNSPrefixAttrDefault("http://www.w3.org/2000/09/xmldsig#");
    }

    public void setIssuerSerial(X500Principal issuer, BigInteger serialNumber) throws DOMException {
        Document doc = this.getOwnerDocument();
        NodeList list = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "*");
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            this.removeChild(list.item(i));
        }
        Element xin = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509IssuerName");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)xin);
        xin.appendChild(doc.createTextNode(issuer.toString()));
        this.appendChild(xin);
        Element xsn = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)xsn);
        xsn.appendChild(doc.createTextNode(serialNumber.toString()));
        this.appendChild(xsn);
    }

    public X509Data.IssuerAndSerialNo getIssuerSerial() {
        X500Principal issuer = null;
        NodeList issuerList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509IssuerName");
        if (issuerList.getLength() != 0) {
            issuer = new X500Principal(XMLUtils.collectText((Node)issuerList.item(0)));
        }
        BigInteger serial = null;
        NodeList serialList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber");
        if (serialList.getLength() != 0) {
            serial = new BigInteger(XMLUtils.collectText((Node)serialList.item(0)));
        }
        if (serial == null || issuer == null) {
            return null;
        }
        return new X509Data.IssuerAndSerialNo(issuer, serial);
    }

    @Override
    public QName getName() {
        return new QName("X509IssuerSerial", "http://www.w3.org/2000/09/xmldsig#", null);
    }

    @Override
    public WSSecurityToken getSecurityToken() throws WSSException {
        X509Data.IssuerAndSerialNo iasn = this.getIssuerSerial();
        if (iasn == null) {
            throw new WSSException("Unable to locate X509IssuerSerial");
        }
        X509Certificate cert = null;
        if (cert == null) {
            int n = resolverList.size();
            for (int i = 0; i < n && cert == null; ++i) {
                X509IssuerSerialResolver r = (X509IssuerSerialResolver)resolverList.get(i);
                try {
                    cert = r.resolve(iasn.getIssuer(), iasn.getSerial());
                    continue;
                }
                catch (X509IssuerSerialResolverException ex) {
                    cert = null;
                }
            }
        }
        if (cert == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
        X509BinarySecurityToken x509Token = new X509BinarySecurityToken(this.getOwnerDocument());
        x509Token.setToken(cert);
        x509Token.alreadyValidated = true;
        return x509Token;
    }

    public static void addResolver(X509IssuerSerialResolver resolver) {
        resolverList.add(resolver);
    }

    public static List getResolvers() {
        return resolverList;
    }

    @Override
    public Object getKey() throws WSSException {
        X509Data.IssuerAndSerialNo iasn = this.getIssuerSerial();
        if (iasn == null) {
            throw new WSSException("Unable to locate X509IssuerSerial");
        }
        PrivateKey key = null;
        if (key == null) {
            int n = resolverList.size();
            for (int i = 0; i < n && key == null; ++i) {
                X509IssuerSerialResolver r = (X509IssuerSerialResolver)resolverList.get(i);
                try {
                    key = r.getPrivateKey(iasn.getIssuer(), iasn.getSerial());
                    continue;
                }
                catch (X509IssuerSerialResolverException ex) {
                    key = null;
                }
            }
        }
        if (key == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
        return key;
    }

    public X500Principal getIssuer() {
        X500Principal issuer = null;
        NodeList issuerList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509IssuerName");
        if (issuerList.getLength() != 0) {
            issuer = new X500Principal(XMLUtils.collectText((Node)issuerList.item(0)));
        }
        return issuer;
    }

    public BigInteger getSerial() {
        BigInteger serial = null;
        NodeList serialList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber");
        if (serialList.getLength() != 0) {
            serial = new BigInteger(XMLUtils.collectText((Node)serialList.item(0)));
        }
        return serial;
    }
}

