/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.wsc;

import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.WSSElement;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSXMLSecurityToken;
import oracle.security.xmlsec.wss.util.WSSUtils;
import oracle.security.xmlsec.wss.wsc.WSCSecurityContextTokenResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class WSCSecurityContextToken
extends WSSElement
implements WSSXMLSecurityToken {
    private static ArrayList<WSCSecurityContextTokenResolver> resolverList = new ArrayList();
    private static final String IDENTIFIER = "Identifier";
    private static final String INSTANCE = "Instance";
    private static final String[] localNames = new String[]{"Identifier", "Instance"};

    protected WSCSecurityContextToken(Document owner, String nsURI, String localName) {
        super(owner, nsURI, localName);
    }

    protected WSCSecurityContextToken(Element element, String systemId) {
        super(element, systemId);
    }

    protected WSCSecurityContextToken(Element element) {
        super(element);
    }

    public static void addResolver(WSCSecurityContextTokenResolver resolver) {
        resolverList.add(resolver);
    }

    public static List<WSCSecurityContextTokenResolver> getResolvers() {
        return resolverList;
    }

    @Override
    public Object getToken() throws WSSException {
        return this;
    }

    public SecretKey getKey() {
        int n = resolverList.size();
        for (int i = 0; i < n; ++i) {
            SecretKey key = resolverList.get(i).resolve(this.getIdentifier(), this.getInstance(), this);
            if (key == null) continue;
            return key;
        }
        return null;
    }

    @Override
    public QName getTokenName() {
        return new QName("SecurityContextToken", this.getNamespaceURI(), null);
    }

    protected abstract String[] getNsURIs();

    public String getIdentifier() {
        return WSSUtils.collectTextFromChild(this, this.getNamespaceURI(), IDENTIFIER);
    }

    public void setIdentifier(String identifier) {
        if (identifier == null) {
            XMLUtils.removeChildren((Element)this.getElement(), (String)this.getNamespaceURI(), (String)IDENTIFIER);
        } else {
            WSSUtils.insertChildElementWithText(this, this.getNamespaceURI(), IDENTIFIER, this.getNsURIs(), localNames, identifier, true);
        }
    }

    public String getInstance() {
        return WSSUtils.collectTextFromChild(this, this.getNamespaceURI(), INSTANCE);
    }

    public void setInstance(String instance) {
        if (instance == null) {
            XMLUtils.removeChildren((Element)this.getElement(), (String)this.getNamespaceURI(), (String)INSTANCE);
        } else {
            WSSUtils.insertChildElementWithText(this, this.getNamespaceURI(), INSTANCE, this.getNsURIs(), localNames, instance, true);
        }
    }

    public static class WSCSecurityContextToken13
    extends WSCSecurityContextToken {
        private static final String[] nsURIs = new String[]{"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512"};

        @Override
        protected String[] getNsURIs() {
            return nsURIs;
        }

        public WSCSecurityContextToken13(Document owner) {
            super(owner, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "SecurityContextToken");
        }

        public WSCSecurityContextToken13(Element element, String systemId) {
            super(element, systemId);
        }

        public WSCSecurityContextToken13(Element element) {
            super(element);
        }
    }

    public static class WSCSecurityContextToken12
    extends WSCSecurityContextToken {
        private static final String[] nsURIs = new String[]{"http://schemas.xmlsoap.org/ws/2005/02/sc", "http://schemas.xmlsoap.org/ws/2005/02/sc"};

        @Override
        protected String[] getNsURIs() {
            return nsURIs;
        }

        public WSCSecurityContextToken12(Document owner) {
            super(owner, "http://schemas.xmlsoap.org/ws/2005/02/sc", "SecurityContextToken");
        }

        public WSCSecurityContextToken12(Element element, String systemId) {
            super(element, systemId);
        }

        public WSCSecurityContextToken12(Element element) {
            super(element);
        }
    }
}

