/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPMessage;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.xmlsec.dsig.ObjectReference;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.saml2.core.Assertion;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.IDCache;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.TagManager;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLNode;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.encoding.BinaryDataEncoder;
import oracle.security.xmlsec.wss.saml.SAMLAssertionToken;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionToken;
import oracle.security.xmlsec.wss.swa.SWAUtil;
import oracle.security.xmlsec.wss.transform.StreamingSTRTransform;
import oracle.security.xmlsec.wss.util.WSSTokenUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSSUtils {
    public static String encodeBinary(byte[] value, String encodingType) {
        BinaryDataEncoder encoder = WSSTokenUtils.createBinaryDataEncoder(encodingType);
        return encoder.encode(value);
    }

    public static byte[] decodeBinary(String encoded, String encodingType) {
        BinaryDataEncoder decoder = WSSTokenUtils.createBinaryDataEncoder(encodingType);
        return decoder.decode(encoded);
    }

    public static void setTypeAttribute(Element element, String attrName, String attrVal) {
        element.setAttribute(attrName, attrVal);
    }

    public static String getTypeAttribute(Element element, String attrName) {
        return element.getAttribute(attrName);
    }

    public static Element insertChildElementWithText(XMLElement contextElement, String namespaceURI, String localName, String[] namespaceURIs, String[] localNames, String text, boolean replaceExisting) throws DOMException {
        Document doc = contextElement.getOwnerDocument();
        Element child = doc.createElementNS(namespaceURI, localName);
        child.appendChild(doc.createTextNode(text));
        XMLUtils.copyNSPrefix((Element)((Element)contextElement.getNode()), (Element)child);
        if (replaceExisting) {
            XMLUtils.removeChildren((Element)((Element)contextElement.getNode()), (String)namespaceURI, (String)localName);
        }
        XMLUtils.insertChild((Element)((Element)contextElement.getNode()), (Element)child, (String[])namespaceURIs, (String[])localNames);
        return child;
    }

    public static String collectTextFromChild(XMLElement contextElement, String namespaceURI, String localName) {
        NodeList list = XMLElement.getChildElementsByTagNameNS((Element)((Element)contextElement.getNode()), (String)namespaceURI, (String)localName);
        if (list.getLength() > 0) {
            return XMLUtils.collectText((Node)list.item(0));
        }
        return null;
    }

    public static void setChildElement(XMLElement contextElement, XMLElement element, String[] nsURIs, String[] localNames) {
        XMLUtils.removeChildren((Element)((Element)contextElement.getNode()), (String)element.getNamespaceURI(), (String)element.getLocalName());
        XMLUtils.insertChild((XMLElement)contextElement, (XMLElement)element, (String[])nsURIs, (String[])localNames);
    }

    public static XMLElement getChildElement(XMLElement contextElement, String nsURI, String localName) {
        XMLElement element = null;
        NodeList nList = contextElement.getChildElementsByTagNameNS(nsURI, localName);
        if (nList.getLength() != 0 && (element = WSSUtils.getInstance((Element)nList.item(0), nsURI, localName)) != null) {
            element.setSystemId(contextElement.getSystemId());
        }
        return element;
    }

    public static List getChildElements(XMLElement contextElement, String nsURI, String localName) {
        NodeList nList = contextElement.getChildElementsByTagNameNS(nsURI, localName);
        ArrayList<XMLElement> result = new ArrayList<XMLElement>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            XMLElement element = WSSUtils.getInstance((Element)nList.item(i), null, null);
            if (element == null) continue;
            element.setSystemId(contextElement.getSystemId());
            result.add(element);
        }
        return result;
    }

    public static XMLElement getInstance(Element element, String tag, String ns) {
        String nodeName = element.getNodeName();
        String tagLocal = element.getLocalName();
        String tagNS = element.getNamespaceURI();
        XMLElement result = XMLUtils.getInstance((Element)element, null, null);
        if (!(result == null || tagLocal.equals("Assertion") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion") || tagLocal.equals("Assertion") && tagNS.equals("urn:oasis:names:tc:SAML:2.0:assertion"))) {
            return result;
        }
        try {
            String xsiType = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            String xsiLocal = null;
            String xsiNS = null;
            if (xsiType != null && xsiType.length() > 0) {
                xsiLocal = QName.getLocalPart((String)xsiType);
                xsiNS = QName.resolvePrefix((String)xsiType, (Node)element);
            }
            String valueType = element.getAttribute("ValueType");
            if (tagNS == null) {
                tagNS = element.getNamespaceURI();
            }
            TagManager tagMgr = TagManager.getTagManager();
            Class c = null;
            if (valueType != null && tagNS.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) {
                URIManager uriMgr = URIManager.getURIManager();
                try {
                    if (tagLocal.equals("BinarySecurityToken")) {
                        c = uriMgr.getClassForURI(valueType, "useBinaryToken");
                    } else if (tagLocal.equals("KeyIdentifier")) {
                        c = uriMgr.getClassForURI(valueType, "useIdentifier");
                    } else if (tagLocal.equals("Reference")) {
                        c = uriMgr.getClassForURI(valueType, "useReference");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else if (tag != null && ns != null) {
                c = tagMgr.getClassForTag(tagNS, tagLocal);
            } else {
                if (xsiNS != null && xsiLocal != null) {
                    c = tagMgr.getClassForTag(xsiNS, xsiLocal);
                }
                if (c == null && tagNS != null && tagLocal != null) {
                    c = tagMgr.getClassForTag(tagNS, tagLocal);
                }
            }
            if (c != null) {
                if (c.getName().equals(oracle.security.xmlsec.saml.Assertion.class.getName())) {
                    c = SAMLAssertionToken.class;
                } else if (c.getName().equals(Assertion.class.getName())) {
                    c = SAML2AssertionToken.class;
                }
            }
            if (c != null) {
                Constructor x = c.getConstructor(Element.class);
                result = (XMLElement)x.newInstance(element);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return result;
    }

    public static void prependChild(XMLNode parent, Node newChild) {
        Node firstChild = parent.getFirstChild();
        if (firstChild != null) {
            parent.insertBefore(newChild, firstChild);
        } else {
            parent.appendChild(newChild);
        }
        if (newChild.getNodeType() == 1) {
            IDCache.addToIDCache((Element)((Element)newChild));
        }
    }

    public static Element prependChild2(XMLNode parent, Node newChild) {
        Node firstChild = parent.getFirstChild();
        Element ele = null;
        ele = firstChild != null ? (Element)parent.insertBefore(newChild, firstChild) : (Element)parent.appendChild(newChild);
        if (newChild.getNodeType() == 1) {
            IDCache.addToIDCache((Element)ele);
        }
        return ele;
    }

    public static WSSecurityToken createSecurityToken(Element element) throws WSSException {
        WSSecurityToken st = null;
        try {
            Class c = TagManager.getTagManager().getClassForTag(element.getNamespaceURI(), element.getLocalName());
            if (c != null) {
                Constructor x = c.getConstructor(Element.class);
                st = (WSSecurityToken)x.newInstance(element);
            }
        }
        catch (NoSuchMethodException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        catch (SecurityException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        catch (Exception ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        return st;
    }

    public static void addWsuIdToElement(String id, Element element) {
        String name = "Id";
        String prefix = XMLElement.getDefaultNSPrefix((String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        if (prefix != null && prefix.length() != 0) {
            name = prefix + ":" + name;
        }
        element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", name, id);
        XMLElement.addNSPrefixAttrDefault((Element)element, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        IDCache.addToIDCache((Element)element, (String)id);
    }

    public static Object resolveReference(ObjectReference ref, SOAPMessage msg, Map STRToST) throws ReferenceException, AlgorithmIdentifierException, TransformationException {
        SWAUtil.setSOAPMessage(msg);
        XMLContainer data = ObjectReference.dereference((String)ref.getURI(), (Document)ref.getOwnerDocument(), (Element)ref.getElement(), (String)ref.getSystemId());
        if (data.getUserData() != null && data.getUserData() instanceof AttachmentPart) {
            return data.getUserData();
        }
        if (data.subTreeAvailable()) {
            XSAlgorithmIdentifier transform;
            Vector transformList = ref.getTransforms();
            int size = transformList.size();
            if (size > 0 && ((transform = (XSAlgorithmIdentifier)transformList.elementAt(size - 1)).getAlgorithm().equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || transform.getAlgorithm().equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || transform.getAlgorithm().equals("http://www.w3.org/2001/10/xml-exc-c14n#") || transform.getAlgorithm().equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments"))) {
                --size;
            }
            for (int i = 0; i < size; ++i) {
                XSAlgorithmIdentifier transform2 = (XSAlgorithmIdentifier)transformList.elementAt(i);
                XSTransformer tran = XSTransformer.getInstance((XSAlgorithmIdentifier)transform2);
                if (transform2.getAlgorithm().equals("http://www.w3.org/TR/1999/REC-xpath-19991116") || transform2.getAlgorithm().equals("http://www.w3.org/2002/06/xmldsig-filter2") || transform2.getAlgorithm().equals("http://www.w3.org/2002/07/decrypt#XML") || transform2.getAlgorithm().equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) {
                    data = tran.transform(data);
                    continue;
                }
                if (transform2.getAlgorithm().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform")) {
                    if (i != size - 1) {
                        throw new TransformationException("STRTransform should be the last transform");
                    }
                    if (STRToST == null) continue;
                    ((StreamingSTRTransform)tran).transform(data, STRToST);
                    continue;
                }
                if (transform2.getAlgorithm().equals("http://www.w3.org/2000/09/xmldsig#base64")) {
                    if (i != size - 1) {
                        throw new TransformationException("Base64DecodeTransform should be the last transform");
                    }
                    data = tran.transform(data);
                    continue;
                }
                throw new TransformationException("This transformation is not allowed" + transform2.getAlgorithm());
            }
            try {
                if (data.subTreeAvailable()) {
                    return data.getSubTree();
                }
                if (data.nodeSetAvailable()) {
                    return data.getNodeSet();
                }
                if (data.octetsAvailable()) {
                    return XMLUtils.readBytes((InputStream)data.getOctetStream());
                }
                throw new ReferenceException("Internal error, either subtree, nodeset, or octets must be available");
            }
            catch (IOException ex) {
                throw new ReferenceException((Throwable)ex);
            }
            catch (SAXException ex) {
                throw new ReferenceException((Throwable)ex);
            }
            catch (XPathException ex) {
                throw new ReferenceException((Throwable)ex);
            }
        }
        return ref.getURI();
    }

    public static List resolveReferences(XSSignature sig, SOAPMessage msg, Map STRToST) throws ReferenceException, AlgorithmIdentifierException, TransformationException {
        Vector refs = sig.getSignedInfo().getReferences();
        ArrayList<Object> resolvedObjects = new ArrayList<Object>(refs.size());
        for (int i = 0; i < refs.size(); ++i) {
            resolvedObjects.add(i, WSSUtils.resolveReference((ObjectReference)refs.get(i), msg, STRToST));
        }
        return resolvedObjects;
    }
}

