/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.swa;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;
import javax.xml.soap.AttachmentPart;

public class MimeHeaderC14N {
    public static String canonicalizeContentLocation(String contentLocation, boolean decode) throws ParseException, UnsupportedEncodingException {
        if (contentLocation == null) {
            return null;
        }
        HeaderTokenizer ht = new HeaderTokenizer(contentLocation, "()<>@,;:\\\"\t []/?=", true);
        contentLocation = ht.next().getValue();
        if (decode) {
            contentLocation = MimeUtility.decodeText((String)contentLocation);
        }
        return contentLocation;
    }

    public static String canonicalizeContentDisposition(String contentDisposition) throws ParseException {
        if (contentDisposition == null) {
            return null;
        }
        ContentDisposition cd = new ContentDisposition(contentDisposition);
        StringBuffer sb = new StringBuffer();
        sb.append(cd.getDisposition().toLowerCase());
        sb.append(MimeHeaderC14N.canonicalizeParameterList(cd.getParameterList()));
        return sb.toString();
    }

    public static String canonicalizeContentDescription(String contentDescription) throws UnsupportedEncodingException {
        char c;
        int i;
        if (contentDescription == null) {
            return contentDescription;
        }
        String decodedText = MimeUtility.decodeText((String)contentDescription);
        int len = decodedText.length();
        for (i = 0; i < len && ((c = decodedText.charAt(i)) == ' ' || c == '\t' || c == '\r' || c == '\n'); ++i) {
        }
        decodedText = decodedText.substring(i);
        return decodedText;
    }

    public static String canonicalizeContentId(String contentId) throws AddressException {
        InternetAddress address = new InternetAddress(contentId);
        return "<" + address.getAddress() + ">";
    }

    public static String canonicalizeContentType(String contentType) throws ParseException {
        ContentType ctype = new ContentType(contentType);
        StringBuffer sb = new StringBuffer();
        sb.append(ctype.getPrimaryType().toLowerCase());
        sb.append("/");
        sb.append(ctype.getSubType().toLowerCase());
        sb.append(MimeHeaderC14N.canonicalizeParameterList(ctype.getParameterList()));
        return sb.toString();
    }

    public static String canonicalizeParameterList(ParameterList plist) {
        StringBuffer sb = new StringBuffer();
        if (plist == null) {
            return sb.toString();
        }
        ArrayList<String> paramNames = new ArrayList<String>();
        Enumeration e = plist.getNames();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            paramNames.add(paramName);
        }
        Collections.sort(paramNames);
        for (String paramName : paramNames) {
            String paramValue = plist.get(paramName);
            sb.append(";");
            sb.append(paramName.toLowerCase());
            sb.append("=\"");
            sb.append(MimeHeaderC14N.quote(paramValue));
            sb.append("\"");
        }
        return sb.toString();
    }

    public static String quote(String s) {
        if (s.indexOf(34) == -1 && s.indexOf(92) == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s + 5);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String canonicalizeHeader(String header) {
        HeaderTokenizer ht = new HeaderTokenizer(header, "()<>@,;:\\\"\t []/?=", true);
        try {
            return ht.next().getValue();
        }
        catch (ParseException parseException) {
            return header;
        }
    }

    public static String canonicalizeMimeHeaders(AttachmentPart ap) throws UnsupportedEncodingException, ParseException, AddressException {
        String contentLocation;
        String contentId;
        String ContentDescription = "Content-Description";
        String ContentDisposition2 = "Content-Disposition";
        String ContentID = "Content-ID";
        String ContentLocation = "Content-Location";
        String ContentType2 = "Content-Type";
        StringBuffer buf = new StringBuffer();
        String[] s = ap.getMimeHeader("Content-Description");
        if (s != null && s.length > 0) {
            buf.append("Content-Description");
            buf.append(":");
            buf.append(MimeHeaderC14N.canonicalizeContentDescription(s[0]));
            buf.append("\r\n");
        }
        if ((s = ap.getMimeHeader("Content-Disposition")) != null && s.length > 0) {
            buf.append("Content-Disposition");
            buf.append(":");
            buf.append(MimeHeaderC14N.canonicalizeContentDisposition(s[0]));
            buf.append("\r\n");
        }
        if ((contentId = ap.getContentId()) != null) {
            buf.append("Content-ID");
            buf.append(":");
            buf.append(MimeHeaderC14N.canonicalizeContentId(contentId));
            buf.append("\r\n");
        }
        if ((contentLocation = ap.getContentLocation()) != null) {
            buf.append("Content-Location");
            buf.append(":");
            buf.append(MimeHeaderC14N.canonicalizeContentLocation(contentLocation, false));
            buf.append("\r\n");
        }
        String contentType = ap.getContentType();
        buf.append("Content-Type");
        buf.append(":");
        buf.append(MimeHeaderC14N.canonicalizeContentType(contentType));
        buf.append("\r\n");
        buf.append("\r\n");
        return buf.toString();
    }
}

