/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.kerberos;

import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSKeyIdentifier;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.kerberos.KerberosBinarySecurityToken;
import oracle.security.xmlsec.wss.kerberos.KerberosKeyIdentifierResolver;
import oracle.security.xmlsec.wss.kerberos.KerberosKeyIdentifierResolverException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KerberosKeyIdentifier
extends WSSKeyIdentifier {
    protected static final String DEFAULT_ENCODING_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private static ArrayList resolverList = new ArrayList();

    public static void addResolver(KerberosKeyIdentifierResolver resolver) {
        resolverList.add(resolver);
    }

    public static List getResolvers() {
        return resolverList;
    }

    public KerberosKeyIdentifier(Element element) {
        super(element);
    }

    public KerberosKeyIdentifier(Element element, String systemId) {
        super(element, systemId);
    }

    public KerberosKeyIdentifier(Document owner) {
        super(owner, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ", DEFAULT_ENCODING_TYPE);
    }

    public KerberosKeyIdentifier(Document owner, String valType) {
        super(owner, valType);
    }

    public KerberosKeyIdentifier(Document owner, String valType, String encType) {
        super(owner, valType, encType);
    }

    @Override
    public WSSecurityToken getSecurityToken() throws WSSException {
        byte[] apreq = null;
        if (apreq == null) {
            int n = resolverList.size();
            for (int i = 0; i < n && apreq == null; ++i) {
                KerberosKeyIdentifierResolver r = (KerberosKeyIdentifierResolver)resolverList.get(i);
                try {
                    apreq = r.resolve(this, this.getValueType());
                    continue;
                }
                catch (KerberosKeyIdentifierResolverException ex) {
                    apreq = null;
                }
            }
        }
        if (apreq == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
        KerberosBinarySecurityToken kToken = new KerberosBinarySecurityToken(this.getOwnerDocument());
        kToken.removeAttribute("EncodingType");
        kToken.setToken(apreq);
        return kToken;
    }

    @Override
    public Object getKey() throws WSSException {
        KerberosBinarySecurityToken kToken = (KerberosBinarySecurityToken)this.getSecurityToken();
        return kToken == null ? null : kToken.getKey();
    }

    @Override
    protected String getDefaultEncodingType() {
        return DEFAULT_ENCODING_TYPE;
    }
}

