/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.xmlsec.wss.impl.KrbDecryptor;

public class KrbParser {
    public static ASN1GenericConstructed GSSUnwrap(byte[] contextToken) throws IOException {
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(contextToken);
        ASN1ConstructedInputStream asn1 = new ASN1ConstructedInputStream((InputStream)is, 0, 64);
        int tag = asn1.getCurrentTag();
        if (tag != 6) {
            throw new ASN1FormatException("Can't find MechType GSS Context");
        }
        ASN1ObjectID mechType = new ASN1ObjectID((InputStream)asn1);
        ASN1ObjectID krbMechType = new ASN1ObjectID("1.2.840.113554.1.2.2");
        if (!mechType.toString().equals(krbMechType.toString())) {
            throw new ASN1FormatException("Expected mechType = " + krbMechType + " got " + mechType);
        }
        byte[] tok_id = new byte[2];
        asn1.read(tok_id);
        if (tok_id[0] != 1 || tok_id[1] != 0) {
            throw new ASN1FormatException("Can't find TOK_ID 01 00");
        }
        return new ASN1GenericConstructed((InputStream)is);
    }

    public static ASN1Object getElementAt(ASN1Sequence seq, int tagNo) throws ASN1FormatException {
        for (int i = 0; i < seq.length(); ++i) {
            ASN1Object obj = seq.elementAt(i);
            if (!(obj instanceof ASN1TaggedObject) || ((ASN1TaggedObject)obj).getHeader().getTag() != tagNo) continue;
            if (obj instanceof ASN1GenericConstructed) {
                return ((ASN1GenericConstructed)obj).firstElement();
            }
            throw new ASN1FormatException("Excpecting generic constructed");
        }
        throw new ASN1FormatException("Tag " + tagNo + " no found");
    }

    public static ASN1Sequence getApplicationSequence(ASN1GenericConstructed asn, int tagNo) throws ASN1FormatException {
        asn.getHeader().checkTag(tagNo);
        asn.getHeader().checkTagClass(64);
        return (ASN1Sequence)asn.elementAt(0);
    }

    public static class ApReq {
        public int pVno;
        public int msgType;
        public boolean useSessionKey;
        public boolean mutualRequired;
        public Ticket ticket;
        public Authenticator authenticator;

        public ApReq(ASN1GenericConstructed asnApReq, KrbDecryptor.EncryptionKey[] encKeys, KrbDecryptor.EncryptionKey tgtSessionKey) throws IOException {
            ASN1Sequence seq = KrbParser.getApplicationSequence(asnApReq, 14);
            this.pVno = ((ASN1Integer)KrbParser.getElementAt(seq, 0)).intValue();
            this.msgType = ((ASN1Integer)KrbParser.getElementAt(seq, 1)).intValue();
            int apOptions = ((ASN1BitString)KrbParser.getElementAt(seq, 2)).intValue();
            this.useSessionKey = (apOptions & 2) != 0;
            this.mutualRequired = (apOptions & 4) != 0;
            ASN1GenericConstructed asnTicket = (ASN1GenericConstructed)KrbParser.getElementAt(seq, 3);
            this.ticket = new Ticket(asnTicket, encKeys, tgtSessionKey, this.useSessionKey);
            if (this.ticket.key != null) {
                ASN1Sequence asnAuthenticator = (ASN1Sequence)KrbParser.getElementAt(seq, 4);
                this.authenticator = new Authenticator(asnAuthenticator, this.ticket.key);
            }
        }

        public ApReq(ASN1GenericConstructed asnApReq, KrbDecryptor.EncryptionKey encKey) throws IOException {
            ASN1Sequence seq = KrbParser.getApplicationSequence(asnApReq, 14);
            this.pVno = ((ASN1Integer)KrbParser.getElementAt(seq, 0)).intValue();
            this.msgType = ((ASN1Integer)KrbParser.getElementAt(seq, 1)).intValue();
            int apOptions = ((ASN1BitString)KrbParser.getElementAt(seq, 2)).intValue();
            this.useSessionKey = (apOptions & 2) != 0;
            boolean bl = this.mutualRequired = (apOptions & 4) != 0;
            if (encKey != null) {
                ASN1Sequence asnAuthenticator = (ASN1Sequence)KrbParser.getElementAt(seq, 4);
                this.authenticator = new Authenticator(asnAuthenticator, encKey);
            }
        }
    }

    public static class KrbPrincipal
    implements Principal {
        public int nameType;
        public String[] nameString;
        public String name;

        @Override
        public String getName() {
            return this.name;
        }

        public KrbPrincipal(ASN1Sequence seq, String realm) throws IOException {
            this.nameType = ((ASN1Integer)KrbParser.getElementAt(seq, 0)).intValue();
            ASN1Sequence pseq = (ASN1Sequence)KrbParser.getElementAt(seq, 1);
            this.nameString = new String[pseq.size()];
            StringBuffer fullName = new StringBuffer();
            for (int i = 0; i < pseq.size(); ++i) {
                this.nameString[i] = ((ASN1String)pseq.elementAt(i)).getValue();
                if (i > 0) {
                    fullName.append("/");
                }
                fullName.append(this.nameString[i]);
            }
            fullName.append("@");
            fullName.append(realm);
            this.name = fullName.toString();
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static class Authenticator {
        public int authenticatorVno;
        public String crealm;
        public KrbPrincipal cname;
        public int cusec;
        public KrbDecryptor.EncryptionKey subkey;
        public int seqNumber;

        public Authenticator(ASN1Sequence asnAuthenticator, KrbDecryptor.EncryptionKey sessionKey) throws IOException {
            KrbDecryptor.EncryptedData edata = new KrbDecryptor.EncryptedData(asnAuthenticator);
            byte[] authenticatorBytes = edata.decrypt(sessionKey, 11);
            ASN1GenericConstructed asnAuthenticatorDec = new ASN1GenericConstructed(authenticatorBytes);
            ASN1Sequence seq = KrbParser.getApplicationSequence(asnAuthenticatorDec, 2);
            this.authenticatorVno = ((ASN1Integer)KrbParser.getElementAt(seq, 0)).intValue();
            this.crealm = ((ASN1String)KrbParser.getElementAt(seq, 1)).getValue();
            this.cname = new KrbPrincipal((ASN1Sequence)KrbParser.getElementAt(seq, 2), this.crealm);
            try {
                this.seqNumber = ((ASN1Integer)KrbParser.getElementAt(seq, 7)).intValue();
            }
            catch (ASN1FormatException aSN1FormatException) {
                // empty catch block
            }
            this.cusec = ((ASN1Integer)KrbParser.getElementAt(seq, 4)).intValue();
            try {
                ASN1Sequence tseq = (ASN1Sequence)KrbParser.getElementAt(seq, 6);
                this.subkey = new KrbDecryptor.EncryptionKey(tseq);
            }
            catch (ASN1FormatException aSN1FormatException) {
                // empty catch block
            }
            try {
                this.seqNumber = ((ASN1Integer)KrbParser.getElementAt(seq, 7)).intValue();
            }
            catch (ASN1FormatException aSN1FormatException) {
                // empty catch block
            }
        }
    }

    public static class Ticket {
        public int tktVno;
        public String realm;
        public KrbPrincipal sname;
        public KrbDecryptor.EncryptedData edata;
        public int flags;
        public KrbDecryptor.EncryptionKey key;
        public String crealm;
        public KrbPrincipal cname;

        public Ticket(ASN1GenericConstructed asnTicket, KrbDecryptor.EncryptionKey[] serviceKeys, KrbDecryptor.EncryptionKey tgtSessionKey, boolean useSessionKey) throws IOException {
            ASN1Sequence tseq = KrbParser.getApplicationSequence(asnTicket, 1);
            this.tktVno = ((ASN1Integer)KrbParser.getElementAt(tseq, 0)).intValue();
            this.realm = ((ASN1String)KrbParser.getElementAt(tseq, 1)).getValue();
            ASN1Sequence pseq = (ASN1Sequence)KrbParser.getElementAt(tseq, 2);
            this.sname = new KrbPrincipal(pseq, this.realm);
            this.edata = new KrbDecryptor.EncryptedData((ASN1Sequence)KrbParser.getElementAt(tseq, 3));
            if (serviceKeys == null || serviceKeys.length == 0) {
                return;
            }
            KrbDecryptor.EncryptionKey k = null;
            if (useSessionKey) {
                k = tgtSessionKey;
            } else if (serviceKeys != null) {
                for (int i = 0; i < serviceKeys.length; ++i) {
                    if (serviceKeys[i].keyType != this.edata.etype) continue;
                    k = serviceKeys[i];
                }
            }
            byte[] encTicketPart = this.edata.decrypt(k, 2);
            ASN1GenericConstructed asn = new ASN1GenericConstructed(encTicketPart);
            ASN1Sequence etseq = KrbParser.getApplicationSequence(asn, 3);
            this.flags = ((ASN1BitString)KrbParser.getElementAt(etseq, 0)).intValue();
            this.key = new KrbDecryptor.EncryptionKey((ASN1Sequence)KrbParser.getElementAt(etseq, 1));
            this.crealm = ((ASN1String)KrbParser.getElementAt(etseq, 2)).getValue();
            this.cname = new KrbPrincipal((ASN1Sequence)KrbParser.getElementAt(etseq, 3), this.crealm);
        }
    }
}

