/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss;

import java.util.Date;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.util.WSSTokenUtils;
import oracle.security.xmlsec.wss.util.WSSUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSUExpires
extends XMLElement {
    private static final String DEFAULT_TIME_DATA_TYPE = "http://www.w3.org/2001/XMLSchema/dateTime";

    public WSUExpires(Element element) {
        super(element);
    }

    public WSUExpires(Element element, String systemId) {
        super(element, systemId);
    }

    public WSUExpires(Document owner) {
        super(owner, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires");
    }

    public WSUExpires(Document owner, String valType) {
        this(owner);
        this.setValueType(valType);
    }

    public void setValueType(String valType) {
        if (valType != null) {
            WSSUtils.setTypeAttribute((Element)this.node, "ValueType", valType);
        }
    }

    public String getValueType() {
        String valType = WSSUtils.getTypeAttribute((Element)this.node, "ValueType");
        if (valType == null || valType.length() == 0) {
            valType = DEFAULT_TIME_DATA_TYPE;
        }
        return valType;
    }

    public void setValue(Date expires) {
        String textValue = WSSTokenUtils.createTimeDataEncoder(this.getValueType()).encode(expires);
        NodeList nList = this.getChildNodes();
        for (int i = nList.getLength(); i > 0; --i) {
            Node n = nList.item(i - 1);
            if (n.getNodeType() != 3) continue;
            this.removeChild(n);
        }
        this.appendChild(this.getOwnerDocument().createTextNode(textValue));
    }

    public Date getValue() {
        String valStr = XMLUtils.collectText((Node)this.node);
        return WSSTokenUtils.createTimeDataEncoder(this.getValueType()).decode(valStr);
    }
}

