/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss;

import oracle.security.xmlsec.wss.WSSElement;
import oracle.security.xmlsec.wss.WSSecurity;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSEncryptedHeader
extends WSSElement {
    public WSSEncryptedHeader(Element element) {
        super(element);
    }

    public WSSEncryptedHeader(Element element, String systemId) {
        super(element, systemId);
    }

    public WSSEncryptedHeader(Document owner) {
        super(owner, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "EncryptedHeader");
    }

    public WSSEncryptedHeader(Document owner, WSSecurity referencingBlock) {
        super(owner, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "EncryptedHeader");
        this.copyMustUnderstandActorRoleAttribs(referencingBlock);
    }

    public void copyMustUnderstandActorRoleAttribs(WSSecurity referencingBlock) {
        Attr relay;
        Attr role;
        Attr actor;
        Attr mustUnderstand = referencingBlock.getAttributeNodeNS("http://www.w3.org/2003/05/soap-envelope", "mustUnderstand");
        if (mustUnderstand != null) {
            mustUnderstand = referencingBlock.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
        }
        if (mustUnderstand != null) {
            this.setAttributeNS(mustUnderstand.getNamespaceURI(), mustUnderstand.getNodeName(), mustUnderstand.getValue());
        }
        if ((actor = referencingBlock.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor")) != null) {
            this.setAttributeNS(actor.getNamespaceURI(), actor.getNodeName(), actor.getValue());
        }
        if ((role = referencingBlock.getAttributeNodeNS("http://www.w3.org/2003/05/soap-envelope", "role")) != null) {
            this.setAttributeNS(role.getNamespaceURI(), role.getNodeName(), role.getValue());
        }
        if ((relay = referencingBlock.getAttributeNodeNS("http://www.w3.org/2003/05/soap-envelope", "relay")) != null) {
            this.setAttributeNS(relay.getNamespaceURI(), relay.getNodeName(), relay.getValue());
        }
    }
}

