/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss;

import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.WSSElement;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.encoding.BinaryDataEncoder;
import oracle.security.xmlsec.wss.util.WSSTokenUtils;
import oracle.security.xmlsec.wss.util.WSSUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class WSSBinarySecurityToken
extends WSSElement
implements WSSecurityToken {
    protected static final String DEFAULT_ENCODING_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";

    protected WSSBinarySecurityToken(Element element) {
        super(element);
    }

    protected WSSBinarySecurityToken(Element element, String systemId) {
        super(element, systemId);
    }

    protected WSSBinarySecurityToken(Document owner, String valType) {
        this(owner, valType, DEFAULT_ENCODING_TYPE);
    }

    protected WSSBinarySecurityToken(Document owner, String valType, String encType) {
        super(owner, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken");
        WSSUtils.setTypeAttribute((Element)this.getNode(), "ValueType", valType);
        if (encType == null) {
            encType = DEFAULT_ENCODING_TYPE;
        }
        WSSUtils.setTypeAttribute((Element)this.getNode(), "EncodingType", encType);
    }

    public String getValueType() {
        return WSSUtils.getTypeAttribute((Element)this.getNode(), "ValueType");
    }

    public void setValueType(String valueType) {
        WSSUtils.setTypeAttribute((Element)this.getNode(), "ValueType", valueType);
    }

    public String getEncodingType() {
        String encType = WSSUtils.getTypeAttribute((Element)this.getNode(), "EncodingType");
        if (encType.length() == 0) {
            encType = DEFAULT_ENCODING_TYPE;
        }
        return encType;
    }

    public void setValue(byte[] tokenValue) {
        BinaryDataEncoder bdt = WSSTokenUtils.createBinaryDataEncoder(this.getEncodingType());
        this.appendChild(this.getOwnerDocument().createTextNode(bdt.encode(tokenValue)));
    }

    public byte[] getValue() {
        String valStr = XMLUtils.collectText((Node)this.node);
        return WSSTokenUtils.createBinaryDataEncoder(this.getEncodingType()).decode(valStr);
    }

    public abstract void setToken(Object var1);

    @Override
    public abstract Object getToken() throws WSSException;

    @Override
    public QName getTokenName() {
        return new QName("BinarySecurityToken", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", null);
    }
}

