/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.SQLException;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ref.CachedStatement;
import sqlj.runtime.profile.ref.CachedStatementProfile;
import sqlj.runtime.profile.ref.ExecuteEventListener;
import sqlj.runtime.profile.ref.Flushable;
import sqlj.runtime.profile.ref.ObjectPool;
import sqlj.runtime.profile.ref.ProfileWrapper;

public class StatementCacheProfile
extends ProfileWrapper {
    private CachedStatementProfile m_cachedProfile;
    private ObjectPool m_pool;
    private HeadNode[] m_entries;

    public StatementCacheProfile(CachedStatementProfile cachedStatementProfile, ObjectPool objectPool) {
        super(cachedStatementProfile);
        this.m_cachedProfile = cachedStatementProfile;
        this.m_pool = objectPool;
        int n = cachedStatementProfile.getProfileData().size();
        this.m_entries = new HeadNode[n];
        for (int i = 0; i < n; ++i) {
            this.m_entries[i] = new HeadNode();
        }
    }

    public boolean setWrappedProfile(ConnectedProfile connectedProfile) {
        if (connectedProfile instanceof CachedStatementProfile && super.setWrappedProfile(connectedProfile)) {
            this.m_cachedProfile = (CachedStatementProfile)connectedProfile;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTStatement getStatement(int n) throws SQLException {
        Node node = this.m_entries[n];
        Object object = this.m_pool;
        synchronized (object) {
            node = node.getPrevious();
            node.removeForReuse();
        }
        object = node.getStatement(n);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTStatement getStatement(int n, BatchContext batchContext) throws SQLException {
        Node node = this.m_entries[n];
        RTStatement rTStatement = node.getStatement(n, batchContext);
        if (rTStatement == null) {
            ObjectPool objectPool = this.m_pool;
            synchronized (objectPool) {
                node = node.getPrevious();
                node.removeForReuse();
            }
            rTStatement = node.getStatement(n, null);
        }
        return rTStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        SQLException sQLException = null;
        int n = this.m_entries.length;
        ObjectPool objectPool = this.m_pool;
        synchronized (objectPool) {
            for (int i = 0; i < n; ++i) {
                HeadNode headNode = this.m_entries[i];
                for (Node node = headNode.getNext(); node != headNode; node = node.getNext()) {
                    try {
                        node.releaseStatement();
                        continue;
                    }
                    catch (SQLException sQLException2) {
                        if (sQLException == null) {
                            sQLException = sQLException2;
                            continue;
                        }
                        sQLException.setNextException(sQLException2);
                    }
                }
                headNode.reset();
            }
        }
        try {
            super.close();
        }
        catch (SQLException sQLException3) {
            if (sQLException == null) {
                sQLException = sQLException3;
            }
            sQLException.setNextException(sQLException3);
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    private static class DataNode
    extends Node
    implements Flushable,
    ExecuteEventListener {
        private Object m_poolKey;
        private CachedStatement m_stmt;
        private Node m_head;
        private ObjectPool m_pool;

        DataNode(CachedStatement cachedStatement, ObjectPool objectPool, Node node) {
            this.m_stmt = cachedStatement;
            this.m_pool = objectPool;
            this.m_poolKey = objectPool.createKey();
            this.m_head = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeCompleted(CachedStatement cachedStatement) throws SQLException {
            ObjectPool objectPool = this.m_pool;
            synchronized (objectPool) {
                this.m_head.addAsNext(this);
                this.m_pool.addEntry(this.m_poolKey, this);
            }
        }

        public void removeForReuse() {
            this.removeFromList();
            this.m_pool.removeEntry(this.m_poolKey);
        }

        public void releaseStatement() throws SQLException {
            this.m_pool.removeEntry(this.m_poolKey);
            this.m_stmt.releaseStatement();
        }

        public void flush(Object object) throws SQLException {
            this.removeFromList();
            this.m_stmt.releaseStatement();
        }

        public RTStatement getStatement(int n) throws SQLException {
            return this.m_stmt.getStatement(this);
        }

        public RTStatement getStatement(int n, BatchContext batchContext) throws SQLException {
            return this.m_stmt.getStatement(this, batchContext);
        }
    }

    private class HeadNode
    extends Node {
        HeadNode() {
            this.reset();
        }

        void reset() {
            this.m_prev = this.m_next = this;
        }

        public RTStatement getStatement(int n) throws SQLException {
            CachedStatement cachedStatement = StatementCacheProfile.this.m_cachedProfile.getCachedStatement(n);
            if (cachedStatement.isReusable()) {
                return new DataNode(cachedStatement, StatementCacheProfile.this.m_pool, this).getStatement(n);
            }
            return cachedStatement.getStatement(null);
        }

        public RTStatement getStatement(int n, BatchContext batchContext) throws SQLException {
            CachedStatement cachedStatement = StatementCacheProfile.this.m_cachedProfile.getCachedStatement(n, batchContext);
            if (cachedStatement == null) {
                return null;
            }
            try {
                if (cachedStatement.isReusable()) {
                    return new DataNode(cachedStatement, StatementCacheProfile.this.m_pool, this).getStatement(n, batchContext);
                }
                return cachedStatement.getStatement(null, batchContext);
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
    }

    private static class Node {
        Node m_next;
        Node m_prev;

        private Node() {
        }

        public void removeFromList() {
            this.m_next.m_prev = this.m_prev;
            this.m_prev.m_next = this.m_next;
        }

        public void addAsNext(Node node) {
            node.m_next = this.m_next;
            node.m_prev = this;
            this.m_next.m_prev = node;
            this.m_next = node;
        }

        public Node getNext() {
            return this.m_next;
        }

        public Node getPrevious() {
            return this.m_prev;
        }

        public void removeForReuse() {
        }

        public void releaseStatement() throws SQLException {
        }

        public RTStatement getStatement(int n) throws SQLException {
            return null;
        }

        public RTStatement getStatement(int n, BatchContext batchContext) throws SQLException {
            return null;
        }
    }
}

