/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.error;

import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sqlj.runtime.error.Errors;

public class ProfileRefErrors
extends Errors {
    private static final String RESOURCE_NAME = "sqlj.runtime.error.ProfileRefErrorsText";
    private static ResourceBundle m_bundle = null;
    public static final String EXPECTED_EXECUTE_UPDATE = "PRF-0001";
    public static final String EXPECTED_PREPARED_STATEMENT = "PRF-0003";
    public static final String EXPECTED_FOR_UPDATE = "PRF-0004";
    public static final String NO_CALLABLE_STATEMENT = "PRF-0005";
    public static final String NO_PREPARED_STATEMENT = "PRF-0006";
    public static final String INCOMPATIBLE_TYPE = "PRF-0007";
    public static final String UNEXPECTED_CALL = "PRF-0008";
    public static final String EXPECTED_EXECUTE_QUERY = "PRF-0009";
    public static final String UNEXPECTED_PARAMS = "PRF-0010";
    public static final String EXPECTED_CALLABLE_STATEMENT = "PRF-0012";
    public static final String INVALID_ITERATOR = "PRF-0013";
    public static final String EXCEPTION_IN_CONSTRUCTOR = "PRF-0014";
    public static final String STATEMENT_IN_USE = "PRF-0015";
    public static final String EXCEPTION_IN_METHOD = "PRF-0016";
    public static final String CANNOT_SET_INDEX_TABLE_NULL = "PRF-0017";

    public static void raise_EXPECTED_EXECUTE_UPDATE(String sqlString) throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, EXPECTED_EXECUTE_UPDATE, sqlString);
    }

    public static void raise_EXPECTED_PREPARED_STATEMENT(String sqlString) throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, EXPECTED_PREPARED_STATEMENT, sqlString);
    }

    public static void raise_EXPECTED_FOR_UPDATE(int columnNum, String className) throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, EXPECTED_FOR_UPDATE, new Integer(columnNum), className);
    }

    public static void raise_NO_CALLABLE_STATEMENT() throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, NO_CALLABLE_STATEMENT);
    }

    public static void raise_NO_PREPARED_STATEMENT() throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, NO_PREPARED_STATEMENT);
    }

    public static void raise_INCOMPATIBLE_TYPE(Class expected, Class found) throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, INCOMPATIBLE_TYPE, expected.toString(), found.toString());
    }

    public static void raise_UNEXPECTED_CALL(String methodName) throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, UNEXPECTED_CALL, methodName);
    }

    public static void raise_EXPECTED_EXECUTE_QUERY(String sqlString) throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, EXPECTED_EXECUTE_QUERY, sqlString);
    }

    public static void raise_UNEXPECTED_PARAMS(String sqlString, int expected, int found) throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, UNEXPECTED_PARAMS, sqlString, new Integer(expected), new Integer(found));
    }

    public static void raise_EXPECTED_CALLABLE_STATEMENT(String sqlString) throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, EXPECTED_CALLABLE_STATEMENT, sqlString);
    }

    public static void raise_INVALID_ITERATOR(Class iterClass) throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, INVALID_ITERATOR, iterClass.toString());
    }

    public static void raise_EXCEPTION_IN_CONSTRUCTOR(String constructorDesc, Throwable e) throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, EXCEPTION_IN_CONSTRUCTOR, constructorDesc, e);
    }

    public static void raise_STATEMENT_IN_USE() throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, STATEMENT_IN_USE);
    }

    public static void raise_EXCEPTION_IN_METHOD(String methodDesc, Throwable e) throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, EXCEPTION_IN_METHOD, methodDesc, e);
    }

    public static void raise_CANNOT_SET_INDEX_TABLE_NULL() throws SQLException {
        ProfileRefErrors.raiseError(null, m_bundle, CANNOT_SET_INDEX_TABLE_NULL);
    }

    static {
        try {
            m_bundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

