/*
 * Decompiled with CFR 0.152.
 */
package oracle.sqlj.runtime;

import java.io.Serializable;
import oracle.sqlj.runtime.OraTypeInfo;
import sqlj.runtime.profile.EntryInfo;

public class OraEntryInfo
implements Serializable {
    public static final int DML_RETURNING = 7260;
    private EntryInfo m_origEntry;
    private OraTypeInfo[] m_results;
    private OraTypeInfo[] m_params;
    private String m_sqlString;
    private String[] m_bigSqlString;
    private int[] m_columnDefines;
    private String[] m_columnDefineNames;
    private boolean m_isBatchable;
    private boolean m_useFixedChar;
    private boolean m_ncharconv;
    private static final int CHUNK_SIZE = 65000;
    static final long serialVersionUID = -4444536083237381766L;

    public OraEntryInfo(EntryInfo entryInfo, String string, OraTypeInfo[] oraTypeInfoArray, OraTypeInfo[] oraTypeInfoArray2, int[] nArray, String[] stringArray, boolean bl, boolean bl2, boolean bl3) {
        this.m_origEntry = entryInfo;
        this.m_results = new OraTypeInfo[oraTypeInfoArray.length];
        System.arraycopy(oraTypeInfoArray, 0, this.m_results, 0, oraTypeInfoArray.length);
        this.m_params = new OraTypeInfo[oraTypeInfoArray2.length];
        System.arraycopy(oraTypeInfoArray2, 0, this.m_params, 0, oraTypeInfoArray2.length);
        if (string == null || string.length() <= 65000) {
            this.m_sqlString = string;
        } else {
            int n = string.length();
            this.m_sqlString = string.substring(0, 65000);
            this.m_bigSqlString = new String[1 + (n - 65000) / 65000];
            int n2 = 65000;
            for (int i = 0; i < this.m_bigSqlString.length; ++i) {
                this.m_bigSqlString[i] = n2 + 65000 < n ? string.substring(n2, n2 + 65000) : string.substring(n2);
                n2 += 65000;
            }
        }
        this.m_columnDefines = nArray;
        this.m_columnDefineNames = stringArray;
        this.m_isBatchable = bl;
        this.m_useFixedChar = bl2;
        this.m_ncharconv = bl3;
    }

    public EntryInfo getEntryInfo() {
        return this.m_origEntry;
    }

    public OraTypeInfo getResultSetInfo(int n) {
        return this.m_results[n - 1];
    }

    public OraTypeInfo getParamInfo(int n) {
        return this.m_params[n - 1];
    }

    public int[] getColumnDefines() {
        return this.m_columnDefines;
    }

    public String[] getColumnDefineNames() {
        return this.m_columnDefineNames;
    }

    public boolean isBatchable() {
        return this.m_isBatchable;
    }

    public boolean useFixedChar() {
        return this.m_useFixedChar;
    }

    public boolean isNcharconv() {
        return this.m_ncharconv;
    }

    public String getSQLString() {
        if (this.m_sqlString == null) {
            return this.getEntryInfo().getSQLString();
        }
        if (this.m_bigSqlString == null) {
            return this.m_sqlString;
        }
        StringBuffer stringBuffer = new StringBuffer(this.m_sqlString);
        for (int i = 0; i < this.m_bigSqlString.length; ++i) {
            stringBuffer.append(this.m_bigSqlString[i]);
        }
        return stringBuffer.toString();
    }
}

