/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.reflect;

import java.sql.Connection;
import java.util.Hashtable;
import oracle.jpub.reflect.Descriptor;
import oracle.jpub.reflect.RConstructor;
import oracle.jpub.reflect.RField;
import oracle.jpub.reflect.RMethod;
import oracle.jpub.reflect.RObject;
import sqlj.runtime.ref.DefaultContext;

public class RClass {
    private static Hashtable m_classes = new Hashtable();
    private Hashtable m_cachedFields = new Hashtable();
    private Class m_localClass = null;
    private String m_name = null;
    private Connection m_conn = null;
    private DefaultContext m_ctx = null;
    private boolean m_isEvaluated = false;
    private boolean m_isArray = false;
    private boolean m_isPrimitive = false;
    private String m_componentType = null;
    private int m_lazyMode = 0;
    private String m_internalName = null;
    private RClass m_componentTypeCls;
    private RClass m_superclass;
    private RClass m_declaringClass;
    private RClass[] m_interfaces;
    private RClass[] m_declaredClasses;
    private RField[] m_declaredFields;
    private RMethod[] m_declaredMethods;
    private RConstructor[] m_declaredConstructors;
    private Descriptor m_remote = null;

    public static RClass forName(String name) throws ClassNotFoundException {
        return RClass.newRClass(Class.forName(name));
    }

    public static RClass forName(DefaultContext ctx, String name) throws ClassNotFoundException {
        return RClass.newRClass(ctx, name);
    }

    private RClass() {
    }

    static RClass newRClass(Class c) {
        RClass res;
        Hashtable<Class, RClass> h = (Hashtable<Class, RClass>)m_classes.get("");
        if (h == null) {
            h = new Hashtable<Class, RClass>();
            m_classes.put("", h);
        }
        if ((res = (RClass)h.get(c)) == null) {
            res = new RClass();
            res.m_localClass = c;
            h.put(c, res);
        }
        return res;
    }

    private static RClass newRClass(Class c, String internalName) {
        RClass jc = RClass.newRClass(c);
        jc.m_internalName = internalName;
        return jc;
    }

    static RClass newRClass(RClass cls, String klass) throws ClassNotFoundException {
        if (cls.m_ctx != null) {
            return RClass.newRClass(cls.m_ctx, klass);
        }
        if (cls.m_conn != null) {
            return RClass.newRClass(cls.m_conn, klass);
        }
        return RClass.forName(klass);
    }

    DefaultContext getDefaultContext() {
        return this.m_ctx;
    }

    private static RClass newRClass(Object dbConn, String name) throws ClassNotFoundException {
        RClass res;
        if (dbConn == null) {
            return RClass.newRClass(Class.forName(name));
        }
        DefaultContext ctx = null;
        Connection conn = null;
        if (dbConn instanceof DefaultContext) {
            ctx = (DefaultContext)dbConn;
            conn = ctx.getConnection();
        } else {
            conn = (Connection)dbConn;
        }
        Hashtable<Connection, RClass> h = (Hashtable<Connection, RClass>)m_classes.get(conn);
        if (h == null) {
            h = new Hashtable<Connection, RClass>();
            m_classes.put(conn, h);
        }
        if ((res = (RClass)h.get(name)) == null) {
            res = new RClass();
            res.m_name = name;
            res.m_conn = conn;
            res.m_ctx = ctx;
            h.put(conn, res);
        }
        return res;
    }

    RField getCachedField(String s) {
        return (RField)this.m_cachedFields.get(s);
    }

    void putCachedField(String s, RField f) {
        this.m_cachedFields.put(s, f);
    }

    static RClass[] map(Class[] ca) {
        RClass[] res = new RClass[ca.length];
        for (int i = 0; i < ca.length; ++i) {
            res[i] = RClass.newRClass(ca[i]);
        }
        return res;
    }

    static RClass[] map(RClass jc, String[] ca) throws ClassNotFoundException {
        RClass[] res = new RClass[ca.length];
        for (int i = 0; i < ca.length; ++i) {
            res[i] = RClass.newRClass(jc, ca[i]);
        }
        return res;
    }

    static boolean allLocal(RClass[] ca) {
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i].isLocal()) continue;
            return false;
        }
        return true;
    }

    static Class[] unmap(RClass[] ca) {
        Class[] res = new Class[ca.length];
        for (int i = 0; i < ca.length; ++i) {
            res[i] = ca[i].m_localClass;
        }
        return res;
    }

    private boolean isLocal() {
        return this.m_localClass != null;
    }

    private boolean isEvaluated() {
        return this.m_isEvaluated;
    }

    private RClass evaluate() {
        if (!this.isEvaluated()) {
            this.m_isEvaluated = true;
            if (this.m_name == null) {
                this.m_name = this.m_localClass.getName();
            }
            if (this.m_name.startsWith("[")) {
                this.m_isArray = true;
                this.m_componentType = this.m_name.substring(1);
            } else if (this.m_name.endsWith("[]")) {
                this.m_isArray = true;
                this.m_componentType = this.m_name.substring(0, this.m_name.length() - 1);
            } else if (this.m_name.equals("boolean") || this.m_name.equals("byte") || this.m_name.equals("short") || this.m_name.equals("int") || this.m_name.equals("float") || this.m_name.equals("double") || this.m_internalName != null && this.m_internalName.length() == 1) {
                this.m_isPrimitive = true;
            }
        }
        return this;
    }

    public String toString() {
        return this.isLocal() ? this.m_localClass.toString() : this.evaluate().m_name;
    }

    public String getName() {
        return this.isLocal() ? this.m_localClass.getName() : this.evaluate().m_name;
    }

    String getInternalName() throws ClassNotFoundException {
        if (this.m_internalName == null) {
            this.m_internalName = this.isArray() ? "[" + this.getComponentType().getInternalName() : "L" + this.getName() + ";";
        }
        return this.m_internalName;
    }

    public boolean isArray() {
        return this.isLocal() ? this.m_localClass.isArray() : this.evaluate().m_isArray;
    }

    public boolean isPrimitive() {
        return this.isLocal() ? this.m_localClass.isPrimitive() : this.evaluate().m_isPrimitive;
    }

    public RClass getComponentType() throws ClassNotFoundException {
        if (this.m_componentTypeCls == null) {
            this.m_componentTypeCls = this.isLocal() ? RClass.newRClass(this.m_localClass.getComponentType()) : RClass.newRClass(this, this.evaluate().m_componentType);
        }
        return this.m_componentTypeCls;
    }

    public boolean isAssignableFrom(RClass c) {
        return this.isLocal() && c.isLocal() ? this.m_localClass.isAssignableFrom(c.m_localClass) : this.getDescriptor().isAssignableFrom(c.getDescriptor());
    }

    public boolean isInterface() {
        return this.isLocal() ? this.m_localClass.isInterface() : this.getDescriptor().isInterface();
    }

    public int getModifiers() {
        return this.isLocal() ? this.m_localClass.getModifiers() : this.getDescriptor().getModifiers();
    }

    public RClass getSuperclass() throws ClassNotFoundException {
        if (this.m_superclass == null) {
            this.m_superclass = this.isLocal() ? RClass.newRClass(this.m_localClass.getSuperclass()) : RClass.newRClass(this, this.getDescriptor().getSuperclass());
        }
        return this.m_superclass;
    }

    public RClass getDeclaringClass() throws ClassNotFoundException {
        if (this.m_declaringClass == null) {
            this.m_declaringClass = this.isLocal() ? RClass.newRClass(this.m_localClass.getDeclaringClass()) : RClass.newRClass(this, this.getDescriptor().getDeclaringClass());
        }
        return this.m_declaringClass;
    }

    public RClass[] getInterfaces() throws ClassNotFoundException {
        if (this.m_interfaces == null) {
            this.m_interfaces = this.isLocal() ? RClass.map(this.m_localClass.getInterfaces()) : RClass.map(this, this.getDescriptor().getInterfaces());
        }
        return this.m_interfaces;
    }

    public RClass[] getClasses() {
        throw new IllegalArgumentException("RClass.getClasses(): not implemented.");
    }

    public RClass[] getDeclaredClasses() throws ClassNotFoundException {
        if (this.m_declaredClasses == null) {
            this.m_declaredClasses = this.isLocal() ? RClass.map(this.m_localClass.getDeclaredClasses()) : RClass.map(this, this.getDescriptor().getDeclaredClasses());
        }
        return this.m_declaredClasses;
    }

    public RField[] getFields() {
        throw new IllegalArgumentException("RClass.getFields(): not implemented.");
    }

    public RField[] getDeclaredFields() throws ClassNotFoundException {
        if (this.m_declaredFields == null) {
            this.m_declaredFields = this.isLocal() ? RField.map(this, this.m_localClass.getDeclaredFields()) : RField.map(this, this.getDescriptor().getDeclaredFieldModifiers(), this.getDescriptor().getDeclaredFieldNames(), this.getDescriptor().getDeclaredFieldTypes());
        }
        return this.m_declaredFields;
    }

    public RMethod[] getMethods() {
        throw new IllegalArgumentException("RClass.getMethods(): not implemented.");
    }

    public RMethod[] getDeclaredMethods() throws ClassNotFoundException {
        if (this.m_declaredMethods == null) {
            this.m_declaredMethods = this.isLocal() ? RMethod.map(this, this.m_localClass.getDeclaredMethods()) : RMethod.map(this, this.getDescriptor().getDeclaredMethodModifiers(), this.getDescriptor().getDeclaredMethodReturnTypes(), this.getDescriptor().getDeclaredMethodNames(), this.getDescriptor().getDeclaredMethodParameterTypes());
        }
        return this.m_declaredMethods;
    }

    public RConstructor[] getConstructors() {
        throw new IllegalArgumentException("RClass.getConstructors(): not implemented.");
    }

    public RConstructor[] getDeclaredConstructors() throws ClassNotFoundException {
        if (this.m_declaredConstructors == null) {
            this.m_declaredConstructors = this.isLocal() ? RConstructor.map(this, this.m_localClass.getDeclaredConstructors()) : RConstructor.map(this, this.getDescriptor().getDeclaredConstructorModifiers(), this.getDescriptor().getDeclaredConstructorParameterTypes());
        }
        return this.m_declaredConstructors;
    }

    public RObject newInstance() throws InstantiationException, IllegalAccessException {
        return this.newInstance(this.m_ctx);
    }

    public RObject newInstance(DefaultContext ctx) throws InstantiationException, IllegalAccessException {
        return this.isLocal() && ctx == null ? new RObject(this.m_localClass.newInstance(), true, true) : new RObject(ctx, this.evaluate().m_name, true);
    }

    public RField getDeclaredField(String name) throws NoSuchFieldException, ClassNotFoundException {
        return this.isLocal() ? RField.newRField(this, this.m_localClass.getDeclaredField(name)) : RField.newRField(this, name, true);
    }

    public RField getField(String name) throws NoSuchFieldException, ClassNotFoundException {
        return this.isLocal() ? RField.newRField(this, this.m_localClass.getField(name)) : RField.newRField(this, name, false);
    }

    public RMethod getDeclaredMethod(String name, RClass[] args) throws NoSuchMethodException, ClassNotFoundException {
        return this.isLocal() && RClass.allLocal(args) ? RMethod.newRMethod(this, this.m_localClass.getDeclaredMethod(name, RClass.unmap(args))) : RMethod.newRMethod(this, name, args, true);
    }

    public RMethod getDeclaredMethod(String name, Class[] args) throws NoSuchMethodException, ClassNotFoundException {
        return this.isLocal() ? RMethod.newRMethod(this, this.m_localClass.getDeclaredMethod(name, args)) : RMethod.newRMethod(this, name, RClass.map(args), true);
    }

    public RMethod getMethod(String name, RClass[] args) throws NoSuchMethodException, ClassNotFoundException {
        return this.isLocal() && RClass.allLocal(args) ? RMethod.newRMethod(this, this.m_localClass.getMethod(name, RClass.unmap(args))) : RMethod.newRMethod(this, name, args, false);
    }

    public RMethod getMethod(String name, Class[] args) throws NoSuchMethodException, ClassNotFoundException {
        return this.isLocal() ? RMethod.newRMethod(this, this.m_localClass.getMethod(name, args)) : RMethod.newRMethod(this, name, RClass.map(args), false);
    }

    public RConstructor getDeclaredConstructor(RClass[] args) throws NoSuchMethodException, ClassNotFoundException {
        return this.isLocal() && RClass.allLocal(args) ? RConstructor.newRConstructor(this, this.m_localClass.getDeclaredConstructor(RClass.unmap(args))) : RConstructor.newRConstructor(this, args, true);
    }

    public RConstructor getDeclaredConstructor(Class[] args) throws NoSuchMethodException, ClassNotFoundException {
        return this.isLocal() ? RConstructor.newRConstructor(this, this.m_localClass.getDeclaredConstructor(args)) : RConstructor.newRConstructor(this, RClass.map(args), true);
    }

    public RConstructor getConstructor(RClass[] args) throws NoSuchMethodException, ClassNotFoundException {
        return this.isLocal() && RClass.allLocal(args) ? RConstructor.newRConstructor(this, this.m_localClass.getDeclaredConstructor(RClass.unmap(args))) : RConstructor.newRConstructor(this, args, false);
    }

    public RConstructor getConstructor(Class[] args) throws NoSuchMethodException, ClassNotFoundException {
        return this.isLocal() ? RConstructor.newRConstructor(this, this.m_localClass.getDeclaredConstructor(args)) : RConstructor.newRConstructor(this, RClass.map(args), false);
    }

    private Descriptor getDescriptor() {
        if (this.m_remote == null) {
            // empty if block
        }
        return this.m_remote;
    }

    static {
        RClass.newRClass(Void.TYPE, "V");
        RClass.newRClass(Boolean.TYPE, "Z");
        RClass.newRClass(Byte.TYPE, "B");
        RClass.newRClass(Short.TYPE, "S");
        RClass.newRClass(Integer.TYPE, "I");
        RClass.newRClass(Long.TYPE, "J");
        RClass.newRClass(Double.TYPE, "D");
        RClass.newRClass(Float.TYPE, "F");
    }
}

