/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.esax.spi;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class Stack
extends AbstractCollection {
    private ArrayList _list;

    public Stack() {
    }

    public Stack(Collection c) {
        this.addAll(c);
    }

    private List getList() {
        if (this._list == null) {
            this._list = new ArrayList();
        }
        return this._list;
    }

    @Override
    public boolean isEmpty() {
        return this._list == null || this._list.isEmpty();
    }

    public boolean push(Object o) {
        return this.getList().add(o);
    }

    public Object peek() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Illegal peek()");
        }
        List l = this.getList();
        return l.get(l.size() - 1);
    }

    public void replace(Object o) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Illegal replace()");
        }
        List l = this.getList();
        l.set(l.size() - 1, o);
    }

    public Object pop() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Illegal pop()");
        }
        List l = this.getList();
        int lastIndex = l.size() - 1;
        Object theValue = l.get(lastIndex);
        l.remove(lastIndex);
        if (l.isEmpty()) {
            this._list = null;
        }
        return theValue;
    }

    public Iterator reverseIterator() {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this._list.iterator();
    }

    @Override
    public boolean add(Object o) {
        return this.push(o);
    }

    @Override
    public void clear() {
        this.getList().clear();
    }

    @Override
    public Iterator iterator() {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new ReverseListIterator(this._list);
    }

    @Override
    public int size() {
        return this.getList().size();
    }

    private static final class ReverseListIterator
    implements Iterator {
        private final ListIterator _listIterator;

        public ReverseListIterator(List list) {
            this._listIterator = list.listIterator(list.size());
        }

        @Override
        public boolean hasNext() {
            return this._listIterator.hasPrevious();
        }

        public Object next() {
            return this._listIterator.previous();
        }

        @Override
        public void remove() {
            this._listIterator.remove();
        }
    }
}

