/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.esax;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.ElementTypeResolver;
import oracle.javatools.xml.esax.HandlerException;
import oracle.javatools.xml.esax.Key;
import oracle.javatools.xml.esax.spi.Stack;

public class DynamicElementHandler
extends ElementHandler {
    public final Key sApplicationObjectKey = new Key(DynamicElementHandler.class.getName() + ".appObjectKey");
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String SET_METHOD_PREFIX = "set";
    private static final String ADD_METHOD_PREFIX = "add";
    private static final Class[] sObjectParamTypes = new Class[]{Object.class};
    private static final Class[] sStringParamTypes = new Class[]{String.class};
    private final Stack _applicationObjectStack = new Stack();
    private final Stack _complexTypeIndicatorStack = new Stack();
    private ClassLoader _classLoader;
    private final List _resolvers = new ArrayList(5);

    public DynamicElementHandler(Object rootObject) {
        this._applicationObjectStack.push(rootObject);
    }

    public DynamicElementHandler(Object rootObject, ClassLoader classLoader) {
        this(rootObject);
        this._classLoader = classLoader;
    }

    public DynamicElementHandler(Object rootObject, ClassLoader classLoader, ElementTypeResolver resolver) {
        this(rootObject, classLoader);
        this._resolvers.add(resolver);
    }

    public void registerElementTypeResolver(ElementTypeResolver resolver) {
        this._resolvers.add(resolver);
    }

    @Override
    public void handleStart(ElementStartContext context) throws HandlerException {
        Class runtimeType = this.getRuntimeType(context);
        this._complexTypeIndicatorStack.push(new boolean[]{runtimeType != null});
        if (runtimeType != null) {
            Object o = this.getApplicationObject(runtimeType, context);
            this.invokePreInitialize(this._applicationObjectStack.peek(), o);
            this._applicationObjectStack.push(o);
            context.putValue(this.sApplicationObjectKey, o);
            this.handleComplexElementStart(o, context);
        } else {
            this.handleSimpleElementStart(context);
        }
    }

    @Override
    public void handleEnd(ElementEndContext context) throws HandlerException {
        boolean isComplex = ((boolean[])this._complexTypeIndicatorStack.pop())[0];
        if (isComplex) {
            Object child = this._applicationObjectStack.pop();
            this.invokePostInitialize(child);
            this.attachObject(this._applicationObjectStack.peek(), child, context);
            this.handleComplexElementEnd(context);
        } else {
            this.attachData(this._applicationObjectStack.peek(), context.getText(), context);
            this.handleSimpleElementEnd(context);
        }
    }

    protected void handleComplexElementStart(Object applicationObject, ElementStartContext context) throws HandlerException {
    }

    protected void handleComplexElementEnd(ElementEndContext context) throws HandlerException {
    }

    protected void handleSimpleElementStart(ElementStartContext context) throws HandlerException {
    }

    protected void handleSimpleElementEnd(ElementEndContext context) throws HandlerException {
    }

    protected Class getRuntimeType(ElementStartContext context) throws HandlerException {
        Class type = null;
        String classAttribute = context.getAttributeValue(ATTRIBUTE_CLASS);
        if (classAttribute != null) {
            try {
                type = Class.forName(classAttribute, true, this._classLoader != null ? this._classLoader : Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                throw new HandlerException("Unable to load class: " + classAttribute, cnfe);
            }
        } else {
            ListIterator it = this._resolvers.listIterator(this._resolvers.size());
            while (it.hasPrevious() && type == null) {
                type = ((ElementTypeResolver)it.previous()).resolveType(context.getNamespaceURI(), context.getLocalName());
            }
        }
        return type;
    }

    protected Object getApplicationObject(Class runtimeType, ElementStartContext context) throws HandlerException {
        try {
            return runtimeType.newInstance();
        }
        catch (Exception e) {
            throw new HandlerException("Unable to instantiate class: " + runtimeType.getName(), e);
        }
    }

    protected void attachObject(Object parent, Object child, ElementEndContext context) throws HandlerException {
        Method m = this.findMethod(parent, context.getLocalName(), sObjectParamTypes);
        try {
            m.invoke(parent, child);
        }
        catch (InvocationTargetException ite) {
            StringBuffer b = new StringBuffer(200);
            b.append("Could not attach child object: ").append(child.toString());
            b.append(" to parent: ").append(parent.toString());
            b.append(". Root cause: ");
            b.append(ite.getTargetException().getClass().getName()).append(": ");
            b.append(ite.getTargetException().getMessage());
            throw new HandlerException(b.toString());
        }
        catch (Exception e) {
            StringBuffer b = new StringBuffer(200);
            b.append("Could not attach child object: ").append(child.toString());
            b.append(" to parent: ").append(parent.toString());
            b.append(". Root cause: ");
            b.append(e.getClass().getName()).append(": ").append(e.getMessage());
            throw new HandlerException(b.toString());
        }
    }

    protected void attachData(Object parent, String data, ElementEndContext context) throws HandlerException {
        Method m = this.findMethod(parent, context.getLocalName(), sStringParamTypes);
        try {
            m.invoke(parent, data);
        }
        catch (InvocationTargetException ite) {
            throw new HandlerException("Unable to attach data '" + data + "' for simple element " + context.getLocalName(), ite.getTargetException());
        }
        catch (Exception e) {
            throw new HandlerException("Unable to attach data '" + data + "' for simple element " + context.getLocalName(), e);
        }
    }

    protected void invokePreInitialize(Object child, Object parent) throws HandlerException {
    }

    protected void invokePostInitialize(Object o) throws HandlerException {
    }

    protected Method findMethod(Object o, String elementName, Class[] paramTypes) throws HandlerException {
        try {
            String methodName = this.getMethodName(SET_METHOD_PREFIX, elementName);
            return o.getClass().getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException nsme) {
            try {
                String methodName = this.getMethodName(ADD_METHOD_PREFIX, elementName);
                return o.getClass().getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException nme) {
                throw new HandlerException("Class " + o.getClass().getName() + " has no set or add method for element named " + elementName, nme);
            }
        }
    }

    protected String getMethodName(String prefix, String elementName) {
        char[] name = new char[prefix.length() + elementName.length()];
        for (int i = 0; i < prefix.length(); ++i) {
            name[i] = prefix.charAt(i);
        }
        boolean nextUpper = true;
        int nameIndex = prefix.length();
        for (int i = 0; i < elementName.length(); ++i) {
            if (Character.isJavaIdentifierPart(elementName.charAt(i))) {
                if (nextUpper) {
                    name[nameIndex] = Character.toUpperCase(elementName.charAt(i));
                    nextUpper = false;
                } else {
                    name[nameIndex] = elementName.charAt(i);
                }
                ++nameIndex;
                continue;
            }
            nextUpper = true;
        }
        return new String(name).trim();
    }
}

