/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.javatools.patterns.Operator;
import oracle.javatools.patterns.Visitor;

public class ClassHierarchyVisitor
implements Visitor<Class<?>> {
    private final Operator<Class<?>[], ?> operator;
    private final VisitOrder visitOrder;

    public ClassHierarchyVisitor(Operator<Class<?>[], ?> operator, VisitOrder visitOrder) {
        this.operator = operator;
        this.visitOrder = visitOrder;
    }

    public boolean visit(Class<?> ... classes) {
        if (null == classes || 0 == classes.length) {
            return true;
        }
        this.visitOrder.visit(this, classes);
        return true;
    }

    private static class Postorder
    extends VisitingStrategy {
        private final VisitingStrategy decorated;

        public Postorder(VisitingStrategy decorated) {
            this.decorated = decorated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean visit(ClassHierarchyVisitor chv, Class<?> ... classes) {
            try {
                boolean bl = this.decorated.visit(chv, classes);
                return bl;
            }
            finally {
                chv.operator.operate(classes);
            }
        }
    }

    private static class Preorder
    extends VisitingStrategy {
        private final VisitingStrategy decorated;

        public Preorder(VisitingStrategy decorated) {
            this.decorated = decorated;
        }

        @Override
        public boolean visit(ClassHierarchyVisitor chv, Class<?> ... classes) {
            chv.operator.operate(classes);
            return this.decorated.visit(chv, classes);
        }
    }

    private static class SuperclassesFirst
    extends VisitingStrategy {
        private SuperclassesFirst() {
        }

        @Override
        public boolean visit(ClassHierarchyVisitor chv, Class<?> ... classes) {
            return this.visitSuperclass(chv, classes) && this.visitInterfaces(chv, classes);
        }
    }

    private static class InterfacesFirst
    extends VisitingStrategy {
        private InterfacesFirst() {
        }

        @Override
        public boolean visit(ClassHierarchyVisitor chv, Class<?> ... classes) {
            return this.visitInterfaces(chv, classes) && this.visitSuperclass(chv, classes);
        }
    }

    private static abstract class VisitingStrategy {
        private VisitingStrategy() {
        }

        protected abstract boolean visit(ClassHierarchyVisitor var1, Class<?> ... var2);

        protected boolean visitSuperclass(ClassHierarchyVisitor chv, Class<?> ... classes) {
            ArrayList superClasses = new ArrayList();
            for (Class<?> _class : classes) {
                Class<?> superClass;
                if (null == _class || null == (superClass = _class.getSuperclass())) continue;
                superClasses.add(superClass);
            }
            return chv.visit(superClasses.toArray(new Class[superClasses.size()]));
        }

        protected boolean visitInterfaces(ClassHierarchyVisitor chv, Class<?> ... classes) {
            ArrayList interfaces = new ArrayList();
            for (Class<?> _class : classes) {
                if (null == _class) continue;
                interfaces.addAll(Arrays.asList(_class.getInterfaces()));
            }
            return false != chv.visit(interfaces.toArray(new Class[interfaces.size()]));
        }
    }

    public static enum VisitOrder {
        SUPERCLASSES_FIRST_PREORDER(new Preorder(new SuperclassesFirst())),
        INTERFACES_FIRST_PREORDER(new Preorder(new InterfacesFirst())),
        SUPERCLASSES_FIRST_POSTORDER(new Postorder(new SuperclassesFirst())),
        INTERFACES_FIRST_POSTORDER(new Postorder(new InterfacesFirst()));

        private final transient VisitingStrategy strategy;

        private VisitOrder(VisitingStrategy strategy) {
            this.strategy = strategy;
        }

        private boolean visit(ClassHierarchyVisitor chv, Class<?> ... classes) {
            return this.strategy.visit(chv, classes);
        }
    }
}

