/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.util.Pair;
import oracle.javatools.util.PairList;

public class ArrayPairList<A, B>
extends ArrayList<Pair<A, B>>
implements PairList<A, B> {
    public ArrayPairList() {
    }

    public ArrayPairList(int initialCapacity) {
        super(initialCapacity);
    }

    public ArrayPairList(Collection<Pair<A, B>> arg0) {
        super(arg0);
    }

    @Override
    public boolean containsFirstType(A a) {
        return this.indexOfFirstType(a) >= 0;
    }

    @Override
    public boolean containsSecondType(B b) {
        return this.indexOfSecondType(b) >= 0;
    }

    @Override
    public int indexOfFirstType(A a) {
        int size = super.size();
        if (a == null) {
            for (int i = 0; i < size; ++i) {
                Object o = this.get(i);
                if (!(o instanceof Pair)) continue;
                Pair pair = (Pair)o;
                if (pair.first != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                Object o = this.get(i);
                if (!(o instanceof Pair)) continue;
                Pair pair = (Pair)o;
                if (!a.equals(pair.first)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int indexOfSecondType(B b) {
        int size = super.size();
        if (b == null) {
            for (int i = 0; i < size; ++i) {
                Object o = this.get(i);
                if (!(o instanceof Pair)) continue;
                Pair pair = (Pair)o;
                if (pair.second != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                Object o = this.get(i);
                if (!(o instanceof Pair)) continue;
                Pair pair = (Pair)o;
                if (!b.equals(pair.second)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOfFirstType(A a) {
        int size = super.size() - 1;
        if (a == null) {
            for (int i = size; i >= 0; --i) {
                Object o = this.get(i);
                if (!(o instanceof Pair)) continue;
                Pair pair = (Pair)o;
                if (pair.first != null) continue;
                return i;
            }
        } else {
            for (int i = size; i >= 0; --i) {
                Object o = this.get(i);
                if (!(o instanceof Pair)) continue;
                Pair pair = (Pair)o;
                if (!a.equals(pair.first)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOfSecondType(B b) {
        int size = super.size() - 1;
        if (b == null) {
            for (int i = size; i >= 0; --i) {
                Object o = this.get(i);
                if (!(o instanceof Pair)) continue;
                Pair pair = (Pair)o;
                if (pair.second != null) continue;
                return i;
            }
        } else {
            for (int i = size; i >= 0; --i) {
                Object o = this.get(i);
                if (!(o instanceof Pair)) continue;
                Pair pair = (Pair)o;
                if (!b.equals(pair.second)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean removeByFirstType(A a) {
        int size = this.size();
        if (a == null) {
            for (int i = 0; i < size; ++i) {
                Object o = this.get(i);
                if (!(o instanceof Pair)) continue;
                Pair pair = (Pair)o;
                if (pair.first != null) continue;
                this.remove(i);
                return true;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                Object o = this.get(i);
                if (!(o instanceof Pair)) continue;
                Pair pair = (Pair)o;
                if (!a.equals(pair.first)) continue;
                this.remove(i);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeBySecondType(B b) {
        int size = this.size();
        if (b == null) {
            for (int i = 0; i < size; ++i) {
                Object o = this.get(i);
                if (!(o instanceof Pair)) continue;
                Pair pair = (Pair)o;
                if (pair.second != null) continue;
                this.remove(i);
                return true;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                Object o = this.get(i);
                if (!(o instanceof Pair)) continue;
                Pair pair = (Pair)o;
                if (!b.equals(pair.second)) continue;
                this.remove(i);
                return true;
            }
        }
        return false;
    }
}

