/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.popup;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.EnumSet;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.popup.HtmlContentProvider;
import oracle.javatools.editor.popup.HtmlPopupView;
import oracle.javatools.editor.popup.PopupEventListener;
import oracle.javatools.ui.popup.PopupWindow;
import oracle.javatools.ui.popup.PopupWindowListener;
import oracle.javatools.ui.popup.PopupWindowManager;

public final class HtmlPopup
implements EditorPlugin {
    private HashMap commandMap;
    private BasicEditorPane editor;
    private PopupWindow popup;
    private HtmlPopupView docPopupView;
    private final Listeners listeners = new Listeners();
    private static final int[] locations = new int[]{8, 4};
    private static EnumSet<Options> defaultOptions = EnumSet.of(Options.TRAP_EDITOR_NAVIGATION_KEYS);
    private EnumSet<Options> options = defaultOptions;
    private static final String PLUGIN_KEY = HtmlPopup.class.getName();
    public static final String SHOW_DOC_POPUP_ACTION_NAME = "show-doc-popup";
    private static final int UP_COMMAND = 1;
    private static final int DOWN_COMMAND = 2;
    private static final int LEFT_COMMAND = 3;
    private static final int RIGHT_COMMAND = 4;
    private static final int PAGE_UP_COMMAND = 5;
    private static final int PAGE_DOWN_COMMAND = 6;
    private static final int BEGIN_COMMAND = 7;
    private static final int END_COMMAND = 8;
    private static final int CANCEL_COMMAND = 11;
    private static final int UNKNOWN_COMMAND = 0;

    @Override
    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.putProperty(PLUGIN_KEY, this);
    }

    @Override
    public void deinstall(BasicEditorPane editor) {
        this.cancelPopup();
        editor.putProperty(PLUGIN_KEY, null);
        this.editor = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public static HtmlPopupView invokePopup(BasicEditorPane editor, HtmlContentProvider contentProvider) {
        return HtmlPopup.invokePopup(editor, contentProvider, defaultOptions);
    }

    public static HtmlPopupView invokePopup(BasicEditorPane editor, HtmlContentProvider contentProvider, EnumSet<Options> options) {
        HtmlPopupView ret = null;
        HtmlPopup popupPlugin = (HtmlPopup)editor.getProperty(PLUGIN_KEY);
        if (popupPlugin != null) {
            try {
                HtmlPopupView popupView = new HtmlPopupView(contentProvider);
                Rectangle rect = HtmlPopup.getCaretRect(editor);
                popupPlugin.showPopup(popupView, rect);
                ret = popupView;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        popupPlugin.setOptions(options);
        return ret;
    }

    private static Rectangle getCaretRect(BasicEditorPane editor) throws BadLocationException {
        int caretPosition = editor.getCaretPosition();
        Rectangle rect = editor.modelToView(caretPosition);
        return rect;
    }

    public static void cancelPopup(BasicEditorPane editor) {
        HtmlPopup plugin = (HtmlPopup)editor.getProperty(PLUGIN_KEY);
        if (plugin != null) {
            plugin.cancelPopup();
        }
    }

    private void setOptions(EnumSet<Options> options) {
        this.options = options.clone();
    }

    private void showPopup(HtmlPopupView popupView, Rectangle caretRect) {
        if (!this.isPopupVisible()) {
            popupView.addPopupEventListener(this.listeners);
            this.docPopupView = popupView;
            this.initializeCommands();
            this.editor.addActionHookInvoker(this.listeners);
            this.popup = PopupWindowManager.showPopup((JComponent)this.editor, (JComponent)popupView, (boolean)false, (Rectangle)caretRect, (int[])locations, (boolean)false);
            this.popup.addPopupWindowListener((PopupWindowListener)this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelPopup() {
        HtmlPopup htmlPopup = this;
        synchronized (htmlPopup) {
            if (this.popup != null) {
                PopupWindowManager.dismissPopup((PopupWindow)this.popup);
                this.popup = null;
                this.docPopupView.disposePopup();
                this.docPopupView = null;
            }
        }
    }

    private boolean up() {
        if (this.docPopupView != null) {
            return this.docPopupView.up();
        }
        return false;
    }

    private boolean down() {
        if (this.docPopupView != null) {
            return this.docPopupView.down();
        }
        return false;
    }

    private boolean left() {
        if (this.docPopupView != null) {
            return this.docPopupView.left();
        }
        return false;
    }

    private boolean right() {
        if (this.docPopupView != null) {
            return this.docPopupView.right();
        }
        return false;
    }

    private boolean home() {
        if (this.docPopupView != null) {
            return this.docPopupView.home();
        }
        return false;
    }

    private boolean end() {
        if (this.docPopupView != null) {
            return this.docPopupView.end();
        }
        return false;
    }

    private boolean pageUp() {
        if (this.docPopupView != null) {
            return this.docPopupView.pageUp();
        }
        return false;
    }

    private boolean pageDown() {
        if (this.docPopupView != null) {
            return this.docPopupView.pageDown();
        }
        return false;
    }

    private boolean isPopupVisible() {
        return this.popup != null;
    }

    private int lookupCommand(String actionKey) {
        Integer command = (Integer)this.commandMap.get(actionKey);
        return command == null ? 0 : command;
    }

    private void initializeCommands() {
        if (this.commandMap == null) {
            this.commandMap = new HashMap(21);
            this.commandMap.put("caret-up", 1);
            this.commandMap.put("selection-up", 1);
            this.commandMap.put("caret-down", 2);
            this.commandMap.put("selection-down", 2);
            this.commandMap.put("caret-backward", 3);
            this.commandMap.put("selection-backward", 3);
            this.commandMap.put("caret-forward", 4);
            this.commandMap.put("selection-forward", 4);
            this.commandMap.put("page-up", 5);
            this.commandMap.put("selection-page-up", 5);
            this.commandMap.put("page-down", 6);
            this.commandMap.put("selection-page-down", 6);
            this.commandMap.put("caret-begin", 7);
            this.commandMap.put("selection-begin", 7);
            this.commandMap.put("caret-begin-line", 7);
            this.commandMap.put("selection-begin-line", 7);
            this.commandMap.put("caret-end", 8);
            this.commandMap.put("selection-end", 8);
            this.commandMap.put("caret-end-line", 8);
            this.commandMap.put("selection-end-line", 8);
            this.commandMap.put("cancel", 11);
        }
    }

    private class Listeners
    implements ActionHookInvoker,
    PopupEventListener,
    PopupWindowListener {
        private Listeners() {
        }

        @Override
        public boolean invokeAction(String actionKey) {
            if (HtmlPopup.this.docPopupView != null) {
                int command = HtmlPopup.this.lookupCommand(actionKey);
                boolean trapNavigation = HtmlPopup.this.options.contains((Object)Options.TRAP_EDITOR_NAVIGATION_KEYS);
                switch (command) {
                    case 1: {
                        return trapNavigation ? HtmlPopup.this.up() : false;
                    }
                    case 2: {
                        return trapNavigation ? HtmlPopup.this.down() : false;
                    }
                    case 3: {
                        return trapNavigation ? HtmlPopup.this.left() : false;
                    }
                    case 4: {
                        return trapNavigation ? HtmlPopup.this.right() : false;
                    }
                    case 5: {
                        return trapNavigation ? HtmlPopup.this.pageUp() : false;
                    }
                    case 6: {
                        return trapNavigation ? HtmlPopup.this.pageDown() : false;
                    }
                    case 7: {
                        return trapNavigation ? HtmlPopup.this.home() : false;
                    }
                    case 8: {
                        return trapNavigation ? HtmlPopup.this.end() : false;
                    }
                    case 11: {
                        HtmlPopup.this.cancelPopup();
                        HtmlPopup.this.editor.requestFocus();
                        return false;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void popupClosed(PopupWindow popupWindow, int how) {
            Listeners listeners = this;
            synchronized (listeners) {
                HtmlPopup.this.popup = null;
            }
        }

        public void parentFocusGained(PopupWindow popupWindow) {
        }

        public void parentFocusLost(PopupWindow popupWindow, boolean isTemporary) {
            HtmlPopup.this.cancelPopup();
        }

        @Override
        public void popupCanceled() {
            HtmlPopup.this.cancelPopup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void contentsChanged() {
            Listeners listeners = this;
            synchronized (listeners) {
                if (HtmlPopup.this.popup != null && HtmlPopup.this.docPopupView != null) {
                    HtmlPopup.this.popup.updatePopupContent((JComponent)HtmlPopup.this.docPopupView, false);
                }
            }
        }

        @Override
        public void popupClosed() {
            HtmlPopup.this.docPopupView.removePopupEventListener(HtmlPopup.this.listeners);
            HtmlPopup.this.editor.removeActionHookInvoker(HtmlPopup.this.listeners);
        }
    }

    public static enum Options {
        TRAP_EDITOR_NAVIGATION_KEYS;

    }
}

