/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.find.Finder;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.plugins.EditorPlugin;

@Deprecated
public final class FindHighlightPlugin
implements EditorPlugin,
DocumentListener {
    private static final boolean FORWARD = true;
    private static final boolean BACKWARDS = false;
    public static final String PLUGIN_PROPERTY = "*find_plugin*";
    private static HighlightStyle findStyle = Finder.getFindStyle();
    private HighlightLayer highlightLayer = null;
    private BasicEditorPane editor = null;
    private String lastSearchText = null;
    private boolean lastMatchCase = false;
    private boolean lastWholeWordOnly = false;
    private ArrayList offsetList = new ArrayList();
    private ArrayList highlightList = new ArrayList();
    private ArrayList tempOffsetList = new ArrayList();
    private ArrayList tempHighlightList = new ArrayList();

    private int firstValidEditorOffset() {
        return Math.max(0, this.editor.getValidOffsetStart());
    }

    private int lastValidEditorOffset() {
        return this.editor.getValidOffsetEnd() == -1 ? this.editor.getDocument().getLength() : this.editor.getValidOffsetEnd();
    }

    public static HighlightStyle getFindHighlightStyle() {
        return findStyle;
    }

    @Override
    public void install(BasicEditorPane editor) {
        this.editor = editor;
        Document document = editor.getDocument();
        document.addDocumentListener(this);
    }

    @Override
    public void deinstall(BasicEditorPane editor) {
        Document document = editor.getDocument();
        if (document != null) {
            document.removeDocumentListener(this);
        }
        if (this.highlightLayer != null) {
            editor.destroyHighlightLayer(this.highlightLayer);
            this.highlightLayer = null;
        }
        editor = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("document")) {
            Object newValue;
            Object oldValue = event.getOldValue();
            if (oldValue instanceof Document) {
                Document document = (Document)oldValue;
                document.removeDocumentListener(this);
            }
            if ((newValue = event.getNewValue()) instanceof Document) {
                Document document = (Document)newValue;
                document.addDocumentListener(this);
                if (this.highlightLayer != null) {
                    this.highlightLayer.removeAllHighlights();
                }
                this.highlightList.clear();
                this.offsetList.clear();
                if (this.lastSearchText != null) {
                    this.updateFindRegion(this.firstValidEditorOffset(), this.lastValidEditorOffset());
                }
            }
        } else if (propertyName.equals("view-limited")) {
            if (this.highlightLayer != null) {
                this.highlightLayer.removeAllHighlights();
            }
            this.highlightList.clear();
            this.offsetList.clear();
            if (this.lastSearchText != null) {
                this.updateFindRegion(this.firstValidEditorOffset(), this.lastValidEditorOffset());
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.insertUpdate(event.getOffset(), event.getLength());
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.removeUpdate(event.getOffset(), event.getLength());
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
    }

    public int findText(String searchText, int startOffset, boolean searchForward, boolean matchCase, boolean wrapAround, boolean highlightOccurrences) {
        return this.findText(searchText, startOffset, searchForward, matchCase, wrapAround, false, highlightOccurrences);
    }

    public int findText(String searchText, int startOffset, boolean searchForward, boolean matchCase, boolean wrapAround, boolean wholeWordOnly, boolean highlightOccurrences) {
        if (highlightOccurrences) {
            boolean redoSearch = false;
            if (this.lastSearchText == null) {
                redoSearch = true;
            } else if (!searchText.equals(this.lastSearchText) || matchCase != this.lastMatchCase || wholeWordOnly != this.lastWholeWordOnly) {
                redoSearch = true;
            }
            if (redoSearch) {
                this.clearFindHighlighting();
                this.performFindHighlighting(searchText, matchCase, wholeWordOnly);
            }
            int foundOffset = -1;
            int listSize = this.offsetList.size();
            if (searchForward) {
                int highlightOffset;
                int i;
                for (i = 0; i < listSize; ++i) {
                    highlightOffset = (Integer)this.offsetList.get(i);
                    if (highlightOffset < startOffset) continue;
                    foundOffset = highlightOffset;
                    break;
                }
                if (wrapAround && foundOffset == -1) {
                    for (i = 0; i < listSize; ++i) {
                        highlightOffset = (Integer)this.offsetList.get(i);
                        if (highlightOffset >= startOffset) continue;
                        foundOffset = highlightOffset;
                        break;
                    }
                }
            } else {
                int highlightOffset;
                int i;
                int textLength = searchText.length();
                for (i = listSize - 1; i >= 0; --i) {
                    highlightOffset = (Integer)this.offsetList.get(i);
                    if (highlightOffset + textLength > startOffset) continue;
                    foundOffset = highlightOffset;
                    break;
                }
                if (wrapAround && foundOffset == -1) {
                    for (i = listSize - 1; i >= 0; --i) {
                        highlightOffset = (Integer)this.offsetList.get(i);
                        if (highlightOffset + textLength <= startOffset) continue;
                        foundOffset = highlightOffset;
                        break;
                    }
                }
            }
            return foundOffset;
        }
        this.clearFindHighlighting();
        int foundOffset = -1;
        if (searchForward) {
            foundOffset = this.findTextInternal(searchText, true, matchCase, wholeWordOnly, startOffset, this.lastValidEditorOffset());
            if (wrapAround && foundOffset == -1) {
                foundOffset = this.findTextInternal(searchText, true, matchCase, wholeWordOnly, this.firstValidEditorOffset(), startOffset + searchText.length());
            }
        } else {
            foundOffset = this.findTextInternal(searchText, false, matchCase, wholeWordOnly, this.firstValidEditorOffset(), startOffset);
            if (wrapAround && foundOffset == -1) {
                foundOffset = this.findTextInternal(searchText, false, matchCase, wholeWordOnly, startOffset - searchText.length(), this.lastValidEditorOffset());
            }
        }
        return foundOffset;
    }

    public void clearFindHighlighting() {
        if (this.highlightLayer != null) {
            this.highlightLayer.removeAllHighlights();
        }
        this.lastSearchText = null;
        this.offsetList.clear();
        this.highlightList.clear();
    }

    public boolean hasFindHighlighting() {
        return this.lastSearchText != null;
    }

    public boolean getFirstHighlightAfter(int position, int[] range) {
        int i = Collections.binarySearch(this.offsetList, new Integer(position));
        if (i < 0) {
            i = -i - 1;
        }
        while (i < this.offsetList.size()) {
            Integer intValue = (Integer)this.offsetList.get(i);
            int offset = intValue;
            if (offset > position) {
                HighlightedText highlightedText = (HighlightedText)this.highlightList.get(i);
                range[0] = offset;
                range[1] = highlightedText.getEndOffset();
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean getFirstHighlightBefore(int position, int[] range) {
        int i = Collections.binarySearch(this.offsetList, new Integer(position));
        if (i < 0) {
            i = -i - 1;
        }
        while (--i >= 0) {
            Integer intValue = (Integer)this.offsetList.get(i);
            int offset = intValue;
            if (offset >= position) continue;
            HighlightedText highlightedText = (HighlightedText)this.highlightList.get(i);
            range[0] = offset;
            range[1] = highlightedText.getEndOffset();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performFindHighlighting(String searchText, boolean matchCase, boolean wholeWordOnly) {
        if (searchText == null) {
            return;
        }
        if (this.editor == null || this.editor.getDocument() == null) {
            return;
        }
        this.lastSearchText = searchText;
        this.lastMatchCase = matchCase;
        this.lastWholeWordOnly = wholeWordOnly;
        BasicDocument document = (BasicDocument)this.editor.getDocument();
        document.readLock();
        try {
            this.updateFindRegion(this.firstValidEditorOffset(), this.lastValidEditorOffset());
        }
        finally {
            document.readUnlock();
        }
    }

    private void insertUpdate(int offset, int count) {
        if (this.lastSearchText != null) {
            HighlightLayer highlightLayer = this.getHighlightLayer();
            Document document = this.editor.getDocument();
            int searchLen = this.lastSearchText.length();
            int startAffected = Math.max(this.firstValidEditorOffset(), offset - searchLen);
            int endAffected = offset;
            int listSize = this.offsetList.size();
            int removeStart = -1;
            int removeEnd = -1;
            boolean SEARCH_FOR_START = false;
            boolean SEARCH_FOR_END = true;
            int UPDATE_OFFSETS = 2;
            int state = 0;
            block5: for (int i = 0; i < listSize; ++i) {
                int highlightOffset = (Integer)this.offsetList.get(i);
                switch (state) {
                    case 0: {
                        if (highlightOffset < startAffected) continue block5;
                        removeStart = i;
                        state = 1;
                        removeEnd = listSize;
                    }
                    case 1: {
                        if (highlightOffset <= endAffected) {
                            HighlightedText highlightToRemove = (HighlightedText)this.highlightList.get(i);
                            highlightLayer.removeHighlight(highlightToRemove);
                            continue block5;
                        }
                        removeEnd = i;
                        state = 2;
                    }
                    case 2: {
                        this.offsetList.set(i, new Integer(highlightOffset += count));
                    }
                }
            }
            if (removeStart != removeEnd) {
                int countToRemove = removeEnd - removeStart;
                for (int i = 0; i < countToRemove; ++i) {
                    this.offsetList.remove(removeStart);
                    this.highlightList.remove(removeStart);
                }
            }
            int recomputeStart = startAffected;
            int recomputeEnd = Math.min(offset + count + searchLen, this.lastValidEditorOffset());
            this.updateFindRegion(recomputeStart, recomputeEnd);
        }
    }

    private void removeUpdate(int offset, int count) {
        if (this.lastSearchText != null) {
            final HighlightLayer highlightLayer = this.getHighlightLayer();
            Document document = this.editor.getDocument();
            int searchLen = this.lastSearchText.length();
            int startAffected = Math.max(this.firstValidEditorOffset(), offset - searchLen);
            int endAffected = Math.min(this.lastValidEditorOffset(), offset + count);
            int listSize = this.offsetList.size();
            int removeStart = -1;
            int removeEnd = -1;
            boolean SEARCH_FOR_START = false;
            boolean SEARCH_FOR_END = true;
            int UPDATE_OFFSETS = 2;
            int state = 0;
            block5: for (int i = 0; i < listSize; ++i) {
                int highlightOffset = (Integer)this.offsetList.get(i);
                switch (state) {
                    case 0: {
                        if (highlightOffset < startAffected) continue block5;
                        removeStart = i;
                        state = 1;
                        removeEnd = listSize;
                    }
                    case 1: {
                        if (highlightOffset <= endAffected) {
                            final HighlightedText highlightToRemove = (HighlightedText)this.highlightList.get(i);
                            if (SwingUtilities.isEventDispatchThread()) {
                                highlightLayer.removeHighlight(highlightToRemove);
                                continue block5;
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (highlightLayer != null) {
                                        highlightLayer.removeHighlight(highlightToRemove);
                                    }
                                }
                            });
                            continue block5;
                        }
                        removeEnd = i;
                        state = 2;
                    }
                    case 2: {
                        this.offsetList.set(i, new Integer(highlightOffset -= count));
                    }
                }
            }
            if (removeStart != removeEnd) {
                int countToRemove = removeEnd - removeStart;
                for (int i = 0; i < countToRemove; ++i) {
                    this.offsetList.remove(removeStart);
                    this.highlightList.remove(removeStart);
                }
            }
            int recomputeStart = startAffected;
            int recomputeEnd = Math.min(offset + searchLen, this.lastValidEditorOffset());
            this.updateFindRegion(recomputeStart, recomputeEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFindRegion(int startOffset, int endOffset) {
        int listSize;
        if (this.lastSearchText == null) {
            return;
        }
        int insertPoint = listSize = this.offsetList.size();
        for (int i = 0; i < listSize; ++i) {
            int highlightOffset = (Integer)this.offsetList.get(i);
            if (highlightOffset <= startOffset) continue;
            insertPoint = i;
            break;
        }
        HighlightLayer highlightLayer = this.getHighlightLayer();
        int searchLen = this.lastSearchText.length();
        highlightLayer.beginBlockUpdate();
        try {
            int currentOffset = startOffset;
            while (currentOffset < endOffset) {
                int foundOffset = this.findTextInternal(this.lastSearchText, true, this.lastMatchCase, this.lastWholeWordOnly, currentOffset, endOffset);
                if (foundOffset == -1) {
                    break;
                }
                HighlightedText entry = highlightLayer.addHighlight(findStyle, foundOffset, foundOffset + searchLen);
                this.tempOffsetList.add(new Integer(foundOffset));
                this.tempHighlightList.add(entry);
                currentOffset = foundOffset + 1;
            }
        }
        finally {
            highlightLayer.endBlockUpdate();
        }
        if (this.tempOffsetList.size() > 0) {
            this.offsetList.addAll(insertPoint, this.tempOffsetList);
            this.highlightList.addAll(insertPoint, this.tempHighlightList);
        }
        this.tempOffsetList.clear();
        this.tempHighlightList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findTextInternal(String searchText, boolean searchForward, boolean matchCase, boolean wholeWordOnly, int startOffset, int endOffset) {
        BasicDocument doc = (BasicDocument)this.editor.getDocument();
        TextBuffer textBuffer = doc.getTextBuffer();
        textBuffer.readLock();
        try {
            int foundOffset;
            while (true) {
                foundOffset = -1;
                foundOffset = matchCase ? (searchForward ? this.searchForwardMatch(searchText, (ReadTextBuffer)textBuffer, startOffset, endOffset) : this.searchBackwardMatch(searchText, (ReadTextBuffer)textBuffer, startOffset, endOffset)) : (searchForward ? this.searchForwardNoMatch(searchText, (ReadTextBuffer)textBuffer, startOffset, endOffset) : this.searchBackwardNoMatch(searchText, (ReadTextBuffer)textBuffer, startOffset, endOffset));
                if (foundOffset == -1 || !wholeWordOnly || this.isWholeWordMatch(doc, foundOffset, searchText.length())) break;
                if (searchForward) {
                    startOffset = foundOffset + 1;
                    continue;
                }
                endOffset = foundOffset - 1;
            }
            int n = foundOffset;
            return n;
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWholeWordMatch(BasicDocument document, int startOffset, int length) {
        Boolean b = EditorProperties.getProperties().getBooleanProperty("word-boundary-use-case");
        try {
            EditorProperties.getProperties().putBooleanProperty("word-boundary-use-case", Boolean.FALSE);
            int endOffset = startOffset + length;
            int wordStart = Utilities.getWordStart(document, startOffset);
            int wordEnd = Utilities.getWordEnd(document, endOffset - 1);
            boolean bl = wordStart == startOffset && wordEnd == endOffset;
            return bl;
        }
        finally {
            EditorProperties.getProperties().putBooleanProperty("word-boundary-use-case", b);
        }
    }

    private int searchForwardMatch(String searchText, ReadTextBuffer textBuffer, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        int lastOffset = endOffset - searchLength;
        block0: for (int currentOffset = startOffset; currentOffset <= lastOffset; ++currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s;
                char t;
                if ((t = textBuffer.getChar(textOffset++)) == (s = searchText.charAt(stringOffset++))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private int searchBackwardMatch(String searchText, ReadTextBuffer textBuffer, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        block0: for (int currentOffset = endOffset - searchLength; currentOffset >= startOffset; --currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s;
                char t;
                if ((t = textBuffer.getChar(textOffset++)) == (s = searchText.charAt(stringOffset++))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private int searchForwardNoMatch(String searchText, ReadTextBuffer textBuffer, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        int lastOffset = endOffset - searchLength;
        int textBufferLength = this.lastValidEditorOffset();
        block0: for (int currentOffset = startOffset; currentOffset <= lastOffset; ++currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset && textOffset < textBufferLength) {
                char s2;
                char t2;
                char s1;
                char t1;
                char s;
                char t;
                if ((t = textBuffer.getChar(textOffset++)) == (s = searchText.charAt(stringOffset++)) || (t1 = Character.toUpperCase(t)) == (s1 = Character.toUpperCase(s)) || (t2 = Character.toLowerCase(t1)) == (s2 = Character.toLowerCase(s1))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private int searchBackwardNoMatch(String searchText, ReadTextBuffer textBuffer, int startOffset, int endOffset) {
        int searchLength = searchText.length();
        block0: for (int currentOffset = endOffset - searchLength; currentOffset >= startOffset; --currentOffset) {
            int stringOffset = 0;
            int textOffset = currentOffset;
            int lastTextOffset = currentOffset + searchLength;
            while (textOffset < lastTextOffset) {
                char s2;
                char t2;
                char s1;
                char t1;
                char s;
                char t;
                if ((t = textBuffer.getChar(textOffset++)) == (s = searchText.charAt(stringOffset++)) || (t1 = Character.toUpperCase(t)) == (s1 = Character.toUpperCase(s)) || (t2 = Character.toLowerCase(t1)) == (s2 = Character.toLowerCase(s1))) continue;
                continue block0;
            }
            return currentOffset;
        }
        return -1;
    }

    private HighlightLayer getHighlightLayer() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        }
        return this.highlightLayer;
    }
}

