/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.jsp;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import oracle.javatools.editor.language.ExtendedBraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.html.HTMLBraceProvider;
import oracle.javatools.editor.language.java.JavaBraceProvider;
import oracle.javatools.parser.LexerToken;

public final class JSPBraceProvider
extends HTMLBraceProvider
implements ExtendedBraceProvider {
    private JavaBraceProvider _javaBraceProvider;
    private static final int JSP_DIRECTIVE_TAG = 3;
    private List<Integer> _javaBraceArray;
    private SoftReference<List<Integer>> _javaBraceArrayRef;

    public JSPBraceProvider(LanguageSupport support) {
        super(support);
        this._javaBraceProvider = new JavaBraceProvider(support);
        this._lexer.setRecognizeJSP(true);
        this._lexer.setRecognizeEmbeddedTags(true);
    }

    @Override
    public int findClosestBrace(int offset, NumberRange braceLocation) {
        if (offset >= this.getTextBuffer().getLength()) {
            return -1;
        }
        if (this.binarySearch(this._javaBraceArray, offset) == -1) {
            return -1;
        }
        return this._javaBraceProvider.findClosestBrace(offset, braceLocation);
    }

    @Override
    public boolean isOpenBraceType(int tokenType) {
        return this._javaBraceProvider.isOpenBraceType(tokenType);
    }

    @Override
    public boolean isCloseBraceType(int tokenType) {
        return this._javaBraceProvider.isCloseBraceType(tokenType);
    }

    @Override
    public int getBraceType(int tokenType, NumberRange braceLocation) {
        return this._javaBraceProvider.getBraceType(tokenType, braceLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int isPartOfBrace(int offset, NumberRange braceLocation) {
        if (offset >= this.getTextBuffer().getLength()) {
            return -1;
        }
        try {
            this.buildBraceArray();
            int entry = this.findEntryForOffset(offset);
            if (entry >= 0 && ((HTMLBraceProvider.BraceArray)this._htmlBraceArray.get(entry)).getBraceType() == 3) {
                braceLocation.start = ((HTMLBraceProvider.BraceArray)this._htmlBraceArray.get(entry)).getStartOffset();
                braceLocation.end = ((HTMLBraceProvider.BraceArray)this._htmlBraceArray.get(entry)).getTagNameEndOffset();
                int n = ((HTMLBraceProvider.BraceArray)this._htmlBraceArray.get(entry)).getBraceType();
                return n;
            }
        }
        finally {
            this._htmlBraceArray = null;
        }
        if (this.binarySearch(this._javaBraceArray, offset) != -1) {
            return this._javaBraceProvider.isPartOfBrace(offset, braceLocation);
        }
        return super.isPartOfBrace(offset, braceLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int findMatchingBrace(int braceType, NumberRange braceLocation, NumberRange matchingLocation) {
        if (braceType == 3) {
            int braceOffset = braceLocation.start + (braceLocation.end - braceLocation.start >> 1);
            if (braceOffset < 0 || braceOffset > this.getTextBuffer().getLength()) {
                throw new IllegalStateException("brace not in buffer");
            }
            try {
                this.buildBraceArray();
                int startEntry = this.findEntryForOffset(braceOffset);
                if (startEntry < 0) {
                    int n = 3;
                    return n;
                }
                matchingLocation.start = ((HTMLBraceProvider.BraceArray)this._htmlBraceArray.get(startEntry)).getEndOffset() - 2;
                matchingLocation.end = ((HTMLBraceProvider.BraceArray)this._htmlBraceArray.get(startEntry)).getEndOffset();
                int n = 1;
                return n;
            }
            finally {
                this._htmlBraceArray = null;
            }
        }
        if (this.isOpenBraceType(braceType) || this.isCloseBraceType(braceType)) {
            return this._javaBraceProvider.findMatchingBrace(braceType, braceLocation, matchingLocation);
        }
        return super.findMatchingBrace(braceType, braceLocation, matchingLocation);
    }

    @Override
    protected void parseToken(LexerToken htmlToken, int token) {
        switch (token) {
            case 22: 
            case 23: 
            case 24: {
                this._javaBraceArray.add(htmlToken.getStartOffset());
                this._javaBraceArray.add(htmlToken.getEndOffset());
                break;
            }
            case 21: {
                String tagName = this.scanTagBlock(htmlToken.getStartOffset());
                int tagEnd = this.getTagNameEndOffset();
                int braceType = tagEnd > htmlToken.getStartOffset() && tagEnd <= htmlToken.getEndOffset() ? tagEnd : htmlToken.getEndOffset();
                this._htmlBraceArray.add(new HTMLBraceProvider.BraceArray(htmlToken.getStartOffset(), htmlToken.getEndOffset(), braceType, 3, tagName));
                break;
            }
            default: {
                super.parseToken(htmlToken, token);
            }
        }
    }

    @Override
    protected void buildBraceArray() {
        if (this._javaBraceArray != null) {
            this._javaBraceArray = this._javaBraceArrayRef.get();
            super.buildBraceArray();
        }
        if (this._javaBraceArray == null || this.getBufferChangeId() != this.getTextBuffer().getChangeId()) {
            this._javaBraceArray = new ArrayList<Integer>();
            super.buildBraceArray();
            this._javaBraceArrayRef = new SoftReference<List<Integer>>(this._javaBraceArray);
        }
    }

    private int binarySearch(List<Integer> aList, int offset) {
        int low = 0;
        int high = aList.size() - 2;
        while (low <= high) {
            int mid = low + high >> 1;
            if (mid % 2 != 0) {
                --mid;
            }
            int start = aList.get(mid);
            int end = aList.get(mid + 1);
            if (offset >= start && offset < end) {
                return mid;
            }
            if (offset < start) {
                high = mid - 2;
                continue;
            }
            if (offset < end) continue;
            low = mid + 2;
        }
        return -1;
    }
}

