/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.SmartIndentProvider;
import oracle.javatools.editor.language.java.CodingStyleOptions;
import oracle.javatools.editor.language.java.CodingStyleProvider;
import oracle.javatools.editor.language.java.Indent;

public class JavaIndentProvider
extends SmartIndentProvider {
    public JavaIndentProvider(LanguageSupport support) {
        super(support);
    }

    @Override
    public boolean isAutoReindentTriggerChar(char charTyped) {
        return charTyped == '\n' || charTyped == '{' || charTyped == '{' || charTyped == ':';
    }

    @Override
    public int getIndentForLine(int line, int tabSize) {
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        int offset = lineMap.getLineStartOffset(line);
        CodingStyleProvider codingStyleProvider = CodingStyleProvider.getCodingStyleProvider();
        CodingStyleOptions codingStyleOptions = codingStyleProvider.getCodingStyleOptions();
        int indent = Indent.getIndent(textBuffer, offset, tabSize, codingStyleOptions);
        return indent;
    }
}

