/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.LexerBlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.java.JavaDocBlockRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

public class JavaBlockRenderer
extends LexerBlockRenderer
implements JavaTokens {
    private JavaDocBlockRenderer docRenderer;

    public JavaBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this.docRenderer = new JavaDocBlockRenderer(textBuffer);
    }

    @Override
    protected Lexer createLexer() {
        JavaLexer lexer = new JavaLexer();
        lexer.setRecognizeSQLJ(true);
        return lexer;
    }

    @Override
    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        switch (token) {
            case 26: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.docRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            default: {
                super.renderToken(fragmentsList, token, tokenStart, tokenEnd, clipStart, clipEnd);
            }
        }
    }

    @Override
    protected String mapTokenToStyleName(int token) {
        switch (token) {
            case 6: {
                return "java-sqlj-style";
            }
            case 4: {
                return "java-identifier-style";
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return "java-number-style";
            }
            case 12: 
            case 15: {
                return "java-literals-style";
            }
            case 13: 
            case 14: {
                return "java-string-style";
            }
            case 24: 
            case 25: {
                return "java-comment-style";
            }
            case 26: {
                throw new IllegalStateException("should be sub-rendering doc");
            }
            case 49: 
            case 50: 
            case 55: 
            case 70: 
            case 71: 
            case 72: {
                return "java-brace-style";
            }
        }
        if (32 <= token && token < 83) {
            return "java-operator-style";
        }
        if (96 <= token && token < 146) {
            return "java-keyword-style";
        }
        return this.getDefaultStyleName();
    }
}

