/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.diff;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.diff.DiffBlockRenderer;
import oracle.javatools.editor.language.diff.DiffLanguageSupport;
import oracle.javatools.editor.language.diff.DiffStyles;
import oracle.javatools.resource.BundleHelper;

public final class DiffLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"diff", "patch"};

    @Override
    public String getPresentationName() {
        BundleHelper resources = EditorProperties.getEditorBundle();
        return resources.getString("DIFF_MODULE_NAME");
    }

    @Override
    public String[] getStyleNames() {
        return DiffStyles.STYLE_NAMES;
    }

    @Override
    public String getContentSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("--- lao Sat Jan 26 23:30:39 1991\n");
        buffer.append("+++ tzu Sat Jan 26 23:30:50 1991\n");
        buffer.append("@@ -1,7 +1,6 @@\n");
        buffer.append("-The Way that can be told of is not the eternal Way;\n");
        buffer.append("-The name that can be named is not the eternal name.\n");
        buffer.append(" The Nameless is the origin of Heaven and Earth;\n");
        buffer.append("-The Named is the mother of all things.\n");
        buffer.append("+The named is the mother of all things.\n");
        buffer.append("+\n");
        buffer.append(" Therefore let there always be non-being,\n");
        buffer.append("   so we may see their subtlety,\n");
        buffer.append(" And let there always be being,\n");
        buffer.append("@@ -9,3 +8,6 @@\n");
        buffer.append(" The two are the same,\n");
        buffer.append(" But after they are produced,\n");
        buffer.append("   they have different names.\n");
        buffer.append("+They both may be called deep and profound.\n");
        buffer.append("+Deeper and more profound,\n");
        buffer.append("+The door of all subtleties!\n");
        return buffer.toString();
    }

    @Override
    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    @Override
    public void registerStyles(StyleRegistry registry) {
        DiffStyles styles = new DiffStyles(registry);
    }

    @Override
    public LanguageSupport createLanguageSupport() {
        return new DiffLanguageSupport();
    }

    @Override
    public BlockRenderer createBlockRenderer(TextBuffer buffer) {
        return new DiffBlockRenderer(buffer);
    }
}

