/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.css;

import java.awt.Color;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.resource.BundleHelper;

public final class CSSStyles {
    public static final String CSS_COMMENT_STYLE = "css-comment-style";
    public static final String CSS_SELECTOR_STYLE = "css-selector-style";
    public static final String CSS_AT_RULE_STYLE = "css-at-rule-style";
    public static final String CSS_PROPERTY_STYLE = "css-property-style";
    public static final String CSS_ERROR_STYLE = "css-error-style";
    public static final String CSS_IDENTIFIER_STYLE = "css-identifier-style";
    public static final String CSS_STRING_STYLE = "css-string-style";
    public static final String CSS_UNIT_STYLE = "css-unit-style";
    public static final String CSS_FUNCTION_STYLE = "css-function-style";
    public static final String CSS_IMPORTANT_STYLE = "css-important-style";
    public static final String CSS_MEDIUM_STYLE = "css-medium-style";
    public static final String CSS_URI_STYLE = "css-uri-style";
    private static final String[] STYLE_NAMES = new String[]{"css-comment-style", "css-at-rule-style", "css-selector-style", "css-property-style", "css-error-style", "css-identifier-style", "css-unit-style", "css-string-style", "css-function-style", "css-important-style", "css-medium-style", "css-uri-style"};
    private BaseStyle cssCommentStyle;
    private static String CommentStyleName = CSSStyles.getBoundleHelper().getString("CSS_COMMENT_STYLE");
    private BaseStyle cssAtRuleStyle;
    private String AtRuleStyleName = CSSStyles.getBoundleHelper().getString("CSS_AT_RULE_STYLE");
    private BaseStyle cssSelectorStyle;
    private String SelectorStyleName = CSSStyles.getBoundleHelper().getString("CSS_SELECTOR_STYLE");
    private BaseStyle cssPropertyStyle;
    private static String PropertyStyleName = CSSStyles.getBoundleHelper().getString("CSS_PROPERTY_STYLE");
    private BaseStyle cssErrorStyle;
    private static String ErrorStyleName = CSSStyles.getBoundleHelper().getString("CSS_ERROR_STYLE");
    private BaseStyle cssIdentifierStyle;
    private static String IdentifierStyleName = CSSStyles.getBoundleHelper().getString("CSS_IDENTIFIER_STYLE");
    private BaseStyle cssUnitStyle;
    private static String UnitStyleName = CSSStyles.getBoundleHelper().getString("CSS_UNIT_STYLE");
    private BaseStyle cssStringStyle;
    private static String StringStyleName = CSSStyles.getBoundleHelper().getString("CSS_STRING_STYLE");
    private BaseStyle cssFunctionStyle;
    private static String FunctionStyleName = CSSStyles.getBoundleHelper().getString("CSS_FUNCTION_STYLE");
    private BaseStyle cssImportantStyle;
    private static String ImportantStyleName = CSSStyles.getBoundleHelper().getString("CSS_IMPORTANT_STYLE");
    private BaseStyle cssMediumStyle;
    private static String MediumStyleName = CSSStyles.getBoundleHelper().getString("CSS_MEDIUM_STYLE");
    private BaseStyle cssUriStyle;
    private static String UriStyleName = CSSStyles.getBoundleHelper().getString("CSS_URI_STYLE");

    public static String[] getStyleNames() {
        return STYLE_NAMES;
    }

    private static BundleHelper getBoundleHelper() {
        return EditorProperties.getEditorBundle();
    }

    public CSSStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        BundleHelper resources = EditorProperties.getEditorBundle();
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        this.cssCommentStyle = styleRegistry.lookupStyle(CSS_COMMENT_STYLE);
        if (this.cssCommentStyle == null) {
            this.cssCommentStyle = styleRegistry.createStyle(CSS_COMMENT_STYLE, CommentStyleName, "base-comment-style", new Color(102, 102, 102));
        }
        this.cssAtRuleStyle = styleRegistry.lookupStyle(CSS_AT_RULE_STYLE);
        if (this.cssAtRuleStyle == null) {
            this.cssAtRuleStyle = styleRegistry.createStyle(CSS_AT_RULE_STYLE, this.AtRuleStyleName, "base-markup-style", new Color(102, 0, 0));
        }
        this.cssSelectorStyle = styleRegistry.lookupStyle(CSS_SELECTOR_STYLE);
        if (this.cssSelectorStyle == null) {
            this.cssSelectorStyle = styleRegistry.createStyle(CSS_SELECTOR_STYLE, this.SelectorStyleName, "base-element-style", new Color(51, 102, 153));
        }
        this.cssPropertyStyle = styleRegistry.lookupStyle(CSS_PROPERTY_STYLE);
        if (this.cssPropertyStyle == null) {
            this.cssPropertyStyle = styleRegistry.createStyle(CSS_PROPERTY_STYLE, PropertyStyleName, "base-keyword-style");
        }
        this.cssErrorStyle = styleRegistry.lookupStyle(CSS_ERROR_STYLE);
        if (this.cssErrorStyle == null) {
            this.cssErrorStyle = styleRegistry.createStyle(CSS_ERROR_STYLE, ErrorStyleName, "base-keyword-style", Color.red, 2);
        }
        this.cssIdentifierStyle = styleRegistry.lookupStyle(CSS_IDENTIFIER_STYLE);
        if (this.cssIdentifierStyle == null) {
            this.cssIdentifierStyle = styleRegistry.createStyle(CSS_IDENTIFIER_STYLE, IdentifierStyleName, "base-keyword-style", Color.blue, 1);
        }
        this.cssUnitStyle = styleRegistry.lookupStyle(CSS_UNIT_STYLE);
        if (this.cssUnitStyle == null) {
            this.cssUnitStyle = styleRegistry.createStyle(CSS_UNIT_STYLE, UnitStyleName, "base-number-style", Color.blue);
        }
        this.cssStringStyle = styleRegistry.lookupStyle(CSS_STRING_STYLE);
        if (this.cssStringStyle == null) {
            this.cssStringStyle = styleRegistry.createStyle(CSS_STRING_STYLE, StringStyleName, "base-string-style", new Color(0, 102, 0));
        }
        this.cssFunctionStyle = styleRegistry.lookupStyle(CSS_FUNCTION_STYLE);
        if (this.cssFunctionStyle == null) {
            this.cssFunctionStyle = styleRegistry.createStyle(CSS_FUNCTION_STYLE, FunctionStyleName, "base-plain-style", new Color(153, 51, 204));
        }
        this.cssImportantStyle = styleRegistry.lookupStyle(CSS_IMPORTANT_STYLE);
        if (this.cssImportantStyle == null) {
            this.cssImportantStyle = styleRegistry.createStyle(CSS_IMPORTANT_STYLE, ImportantStyleName, "base-plain-style", Color.red, 1);
        }
        this.cssMediumStyle = styleRegistry.lookupStyle(CSS_MEDIUM_STYLE);
        if (this.cssMediumStyle == null) {
            this.cssMediumStyle = styleRegistry.createStyle(CSS_MEDIUM_STYLE, MediumStyleName, "base-plain-style", new Color(51, 153, 204));
        }
        this.cssUriStyle = styleRegistry.lookupStyle(CSS_URI_STYLE);
        if (this.cssUriStyle == null) {
            this.cssUriStyle = styleRegistry.createStyle(CSS_URI_STYLE, UriStyleName, "base-plain-style", new Color(153, 51, 204));
        }
    }
}

