/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.javatools.editor.folding.FoldingBlock;

public abstract class AbstractFoldingBlock<B extends FoldingBlock>
implements FoldingBlock<B> {
    private B parent;
    private boolean isLeaf = true;
    private List<B> children = Collections.emptyList();
    private boolean isExpanded;

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    @Override
    public B getParent() {
        return this.parent;
    }

    @Override
    public void setParent(B parent) {
        this.parent = parent;
    }

    @Override
    public void add(B child) {
        B oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.remove(child);
        }
        child.setParent((AbstractFoldingBlock)this);
        if (this.isLeaf) {
            this.children = new LinkedList<B>();
        }
        this.children.add(child);
        this.isLeaf = false;
    }

    @Override
    public void remove(B child) {
        if (this.getChildCount() != 0 && this.children.remove(child)) {
            child.setParent(null);
        }
    }

    @Override
    public void removeAll() {
        if (this.getChildCount() == 0) {
            return;
        }
        Iterator<B> it = this.getChildren();
        while (it.hasNext()) {
            FoldingBlock child = (FoldingBlock)it.next();
            child.setParent(null);
        }
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public Iterator<B> getChildren() {
        return this.children.iterator();
    }

    @Override
    public int length() {
        int endOffset = this.getEndOffset();
        int startOffset = this.getStartOffset();
        return Math.abs(endOffset - startOffset);
    }

    @Override
    public boolean bounds(int offset) {
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        return offset > startOffset && offset < endOffset;
    }

    @Override
    public abstract int getStartOffset();

    @Override
    public abstract int getEndOffset();

    @Override
    public abstract String getReplacementText();
}

