/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.find;

import java.awt.Color;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.TextRange;
import oracle.javatools.editor.find.Find;
import oracle.javatools.editor.find.FindBundle;
import oracle.javatools.editor.find.FindCriteria;
import oracle.javatools.editor.find.FindResult;
import oracle.javatools.editor.find.FindUtils;
import oracle.javatools.editor.find.Finder;
import oracle.javatools.editor.find.ReplaceCriteria;
import oracle.javatools.editor.find.ReplaceResult;
import oracle.javatools.editor.find.Replacement;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;

public final class Replacer {
    static final EditDescriptor replaceDescriptor;
    static final EditDescriptor replaceAllDescriptor;
    static final int FEEDBACK_DURATION = 10000;
    private static final int DEFAULT_REPLACE_PRIORITY = 78;
    public static final String HIGHLIGHT_SKIP_RESULT = "skip-results-highlight";
    public static final String HIGHLIGHT_REPLACE_RESULT = "replace-results-highlight";
    private static final String PROPERTY_REPLACE_HIGHLIGHT_LAYER = "replace-highlight-layer";
    private static final Color SKIP_COLOR;
    private static final Color REPLACE_COLOR;
    private static final Object REPLACE_OVERVIEW_GROUP;
    private static final HighlightStyle skipStyle;
    private static final HighlightStyle replaceStyle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ReplaceResult replace(BasicEditorPane editor, ReplaceCriteria criteria) {
        if (criteria.getScope() == ReplaceCriteria.Scope.PROMPTED) {
            return null;
        }
        FindResult result = Finder.getLatestFindResult(editor);
        if (result == null || result.getFinds().isEmpty()) {
            Toolkit.getDefaultToolkit().beep();
            return new ReplaceResult(ReplaceResult.State.NOT_FOUND);
        }
        if (!editor.makeEditable()) {
            Toolkit.getDefaultToolkit().beep();
            return new ReplaceResult(ReplaceResult.State.ERROR);
        }
        BasicDocument doc = (BasicDocument)editor.getDocument();
        doc.writeLock();
        try {
            if (result.getChangeId() != editor.getTextBuffer().getChangeId() && ((result = Finder.getLatestFindResult(editor)) == null || result.getFinds().isEmpty())) {
                Toolkit.getDefaultToolkit().beep();
                ReplaceResult replaceResult = new ReplaceResult(ReplaceResult.State.NOT_FOUND);
                return replaceResult;
            }
            switch (criteria.getScope()) {
                case GLOBAL: {
                    Collection<Replacement> replaced = Replacer.globalReplace(editor, criteria, result);
                    if (replaced == null) {
                        ReplaceResult replaceResult = new ReplaceResult(ReplaceResult.State.ERROR);
                        return replaceResult;
                    }
                    FindResult findResult = Finder.find(editor, result.getFindCriteria());
                    ReplaceResult replaceResult = new ReplaceResult(findResult, replaced);
                    return replaceResult;
                }
                case SINGLE: {
                    ReplaceResult replaceResult = Replacer.singleReplace(editor, criteria, result);
                    return replaceResult;
                }
            }
            return new ReplaceResult(ReplaceResult.State.ERROR);
        }
        finally {
            doc.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Replacement> globalReplace(BasicEditorPane editor, ReplaceCriteria criteria, FindResult result) {
        FeedbackManager feedbackManager;
        ArrayList<Replacement> replacements = new ArrayList<Replacement>();
        editor.beginEdit(replaceAllDescriptor);
        try {
            Collection<TextRange> excludes = criteria.getExcludes();
            block3: for (Find replace : result.getFinds()) {
                for (TextRange exclude : excludes) {
                    if (!exclude.contains(replace.getStartOffset())) continue;
                    continue block3;
                }
                Replacement replacement = Replacer.replaceOccurence(editor, criteria, result.getFindCriteria(), replace, false);
                if (replacement != null) {
                    replacements.add(replacement);
                    continue;
                }
                break;
            }
        }
        finally {
            editor.endEdit();
        }
        if ((feedbackManager = editor.getFeedbackManager()) != null) {
            feedbackManager.showFeedback(editor, FindBundle.format("FEEDBACK_REPLACE_STATUS", result.getFinds().size()), 10000);
        }
        return replacements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReplaceResult singleReplace(BasicEditorPane editor, ReplaceCriteria criteria, FindResult result) {
        Find nextFind;
        Find find = result.getFind();
        if (find == null) {
            Toolkit.getDefaultToolkit().beep();
            return new ReplaceResult(ReplaceResult.State.NOT_FOUND);
        }
        Replacement replacement = null;
        editor.beginEdit(replaceDescriptor);
        try {
            replacement = Replacer.replaceOccurence(editor, criteria, result.getFindCriteria(), find, true);
        }
        finally {
            editor.endEdit();
        }
        if (replacement == null) {
            return new ReplaceResult(ReplaceResult.State.ERROR);
        }
        FindCriteria findCriteria = result.getFindCriteria();
        findCriteria.setLocation(editor.getSelectionEnd());
        FindResult findResult = Finder.find(editor, findCriteria);
        if (findResult != null && criteria.isAdvanceAfterReplace() && (nextFind = findResult.getFind()) != null) {
            editor.select(nextFind.getStartOffset(), nextFind.getEndOffset());
        }
        return new ReplaceResult(findResult, Collections.singleton(replacement));
    }

    private static Replacement replaceOccurence(BasicEditorPane editor, ReplaceCriteria criteria, FindCriteria findCriteria, Find find, boolean select) {
        try {
            int start = find.getStartOffset();
            int length = find.getEndOffset() - find.getStartOffset();
            String foundText = editor.getText(start, length);
            String replaceText = Replacer.getReplaceText(criteria, findCriteria, find, foundText);
            if (replaceText == null) {
                return null;
            }
            editor.insertString(start, replaceText, null);
            editor.remove(start + replaceText.length(), length);
            if (select) {
                editor.select(start, start + replaceText.length());
            }
            Replacer.highlight(editor, find, Replacement.ReplaceType.REPLACE);
            Replacement replacement = new Replacement(Replacement.ReplaceType.REPLACE, find, foundText, replaceText, new TextRange(editor.getTextBuffer(), start, start + replaceText.length()));
            return replacement;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    static String getReplaceText(ReplaceCriteria criteria, FindCriteria findCriteria, Find find, String foundText) {
        String replaceText = criteria.getReplaceText();
        if (replaceText.length() == 0) {
            return replaceText;
        }
        if (criteria.isSubstituteReplace()) {
            replaceText = FindUtils.substituteSpecial(replaceText);
        }
        if (findCriteria != null && findCriteria.isRegEx()) {
            replaceText = FindUtils.substituteRegExGroups(criteria, find, replaceText);
        }
        if (criteria.isPreserveCase()) {
            if (foundText.toUpperCase().equals(foundText)) {
                replaceText = replaceText.toUpperCase();
            } else if (foundText.toLowerCase().equals(foundText)) {
                replaceText = replaceText.toLowerCase();
            } else if (foundText.length() > 1) {
                Character foundFirst = Character.valueOf(foundText.charAt(0));
                String foundRest = foundText.substring(1);
                Character replaceFirst = Character.valueOf(replaceText.charAt(0));
                String replaceRest = replaceText.substring(1);
                if (Character.isUpperCase(foundFirst.charValue()) && foundRest.toLowerCase().equals(foundRest)) {
                    replaceText = "" + Character.toUpperCase(replaceFirst.charValue()) + replaceRest.toLowerCase();
                } else if (Character.isLowerCase(foundFirst.charValue()) && foundRest.toUpperCase().equals(foundRest)) {
                    replaceText = "" + Character.toLowerCase(replaceFirst.charValue()) + replaceRest.toUpperCase();
                } else if (Character.isUpperCase(foundFirst.charValue())) {
                    replaceText = "" + Character.toUpperCase(replaceFirst.charValue()) + replaceRest;
                } else if (Character.isLowerCase(foundFirst.charValue())) {
                    replaceText = "" + Character.toLowerCase(replaceFirst.charValue()) + replaceRest;
                }
            }
        }
        return replaceText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReplaceResult skip(BasicEditorPane editor, FindCriteria criteria) {
        BasicDocument doc = (BasicDocument)editor.getDocument();
        doc.readLock();
        try {
            FindResult result = Finder.getLatestFindResult(editor);
            if (result == null || result.getFinds().isEmpty() || result.getFind() == null) {
                Toolkit.getDefaultToolkit().beep();
                ReplaceResult replaceResult = null;
                return replaceResult;
            }
            Find find = result.getFind();
            Replacer.highlight(editor, find, Replacement.ReplaceType.SKIP);
            String text = editor.getText(find.getStartOffset(), find.getEndOffset() - find.getStartOffset());
            Replacement replacement = new Replacement(Replacement.ReplaceType.SKIP, find, text, text, new TextRange(editor.getTextBuffer(), find.getStartOffset(), find.getEndOffset()));
            List<Find> finds = result.getFinds();
            if (finds.size() > 1) {
                criteria.setLocation(find.getEndOffset());
                FindResult nextResult = Finder.find(editor, criteria);
                if (nextResult != null && nextResult.getFind() != null) {
                    Find next = nextResult.getFind();
                    editor.select(next.getStartOffset(), next.getEndOffset());
                }
                ReplaceResult replaceResult = new ReplaceResult(nextResult, Collections.singleton(replacement));
                return replaceResult;
            }
            ReplaceResult replaceResult = new ReplaceResult(null, Collections.singleton(replacement));
            return replaceResult;
        }
        catch (BadLocationException e) {
            ReplaceResult replaceResult = new ReplaceResult(ReplaceResult.State.ERROR);
            return replaceResult;
        }
        finally {
            doc.readUnlock();
        }
    }

    private static void highlight(BasicEditorPane editor, Find find, Replacement.ReplaceType replaceType) {
        HighlightLayer highlightLayer = (HighlightLayer)editor.getProperty(PROPERTY_REPLACE_HIGHLIGHT_LAYER);
        if (highlightLayer == null) {
            highlightLayer = editor.createHighlightLayer();
            editor.putProperty(PROPERTY_REPLACE_HIGHLIGHT_LAYER, highlightLayer);
        }
        BasicEditorOverview overview = (BasicEditorOverview)((Object)editor.getProperty("overview"));
        highlightLayer.addHighlight(replaceType == Replacement.ReplaceType.SKIP ? skipStyle : replaceStyle, find.getStartOffset(), find.getEndOffset());
        if (overview != null) {
            overview.addMark(new BasicEditorOverviewMark(editor, find.getStartOffset(), find.getEndOffset(), 78.0f, replaceType == Replacement.ReplaceType.SKIP ? SKIP_COLOR : REPLACE_COLOR, false, true), REPLACE_OVERVIEW_GROUP);
        }
    }

    public static void clearHighlights(BasicEditorPane editor) {
        BasicEditorOverview overview;
        HighlightLayer highlightLayer = (HighlightLayer)editor.getProperty(PROPERTY_REPLACE_HIGHLIGHT_LAYER);
        if (highlightLayer != null) {
            highlightLayer.removeAllHighlights();
        }
        if ((overview = (BasicEditorOverview)((Object)editor.getProperty("overview"))) != null) {
            overview.removeMarks(REPLACE_OVERVIEW_GROUP);
        }
    }

    public static boolean hasHighlights(BasicEditorPane editor) {
        HighlightLayer highlightLayer = (HighlightLayer)editor.getProperty(PROPERTY_REPLACE_HIGHLIGHT_LAYER);
        if (highlightLayer != null) {
            return highlightLayer.hasHighlights();
        }
        return false;
    }

    static {
        SKIP_COLOR = new Color(255, 204, 153);
        REPLACE_COLOR = new Color(204, 255, 153);
        REPLACE_OVERVIEW_GROUP = new Object();
        String editName = FindBundle.get("FD_UNDO_REPLACE");
        replaceDescriptor = new EditDescriptor(editName);
        editName = FindBundle.get("FD_UNDO_REPLACE_ALL");
        replaceAllDescriptor = new EditDescriptor(editName);
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        skipStyle = registry.lookupStyle(HIGHLIGHT_SKIP_RESULT);
        replaceStyle = registry.lookupStyle(HIGHLIGHT_REPLACE_RESULT);
    }
}

