/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.MultiSelectionEvent;
import oracle.javatools.editor.MultiSelectionListener;
import oracle.javatools.editor.Selection;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;

final class MultiSelectionSupport {
    private BasicEditorPane editor;
    private HighlightLayer highlightLayer;
    private final List<MultiSelection> selections = new ArrayList<MultiSelection>();
    private final ActionHookI actionHookI = new ActionHookI();
    private long selChangeId = 0L;
    private List<Selection> externalSelections = new ArrayList<Selection>();
    private long externalSelChangeId = -1L;
    private long bufferChangeId = -1L;
    private MultiSelection latestSelection;
    private CaretListener caretListener = e -> this.checkSelections();
    private List<MultiSelectionListener> listeners = new ArrayList<MultiSelectionListener>();
    private boolean isAdjusting;
    private static final HighlightStyle SELECTION_STYLE;

    MultiSelectionSupport() {
    }

    void install(BasicEditorPane editor) {
        assert (this.editor == null);
        this.editor = editor;
        editor.addActionHookInvoker(this.actionHookI);
        editor.addCaretListener(this.caretListener);
    }

    void deinstall() {
        this.editor.removeCaretListener(this.caretListener);
        this.editor.removeActionHookInvoker(this.actionHookI);
        if (this.highlightLayer != null) {
            this.highlightLayer.destroy();
        }
        for (MultiSelection selection : this.selections) {
            selection.dispose();
        }
        this.selections.clear();
        this.latestSelection = null;
        this.highlightLayer = null;
        this.editor = null;
    }

    void addMultiSelectionListener(MultiSelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    void removeMultiSelectionListener(MultiSelectionListener listener) {
        this.listeners.remove(listener);
    }

    void fireListenerEvent() {
        ArrayList<Selection> sels = new ArrayList<Selection>();
        for (MultiSelection mSel : this.selections) {
            sels.add(new Selection(mSel.getDot(), mSel.getMark()));
        }
        MultiSelectionEvent e = new MultiSelectionEvent(sels);
        for (MultiSelectionListener l : this.listeners) {
            l.multiSelectionChange(e);
        }
    }

    void clear() {
        ++this.selChangeId;
        for (MultiSelection selection : this.selections) {
            selection.dispose();
        }
        this.selections.clear();
        this.latestSelection = null;
        if (this.highlightLayer != null) {
            this.highlightLayer.removeAllHighlights();
        }
        this.fireListenerEvent();
    }

    void select(Collection<Selection> newSelections) {
        this.select(newSelections, true);
    }

    void select(Collection<Selection> newSelections, boolean extra) {
        ++this.selChangeId;
        for (Selection selection : newSelections) {
            this.selections.add(new MultiSelection(this.editor.getTextBuffer(), selection.getDot(), selection.getMark()));
        }
        int size = this.selections.size();
        MultiSelection multiSelection = this.latestSelection = size == 0 ? null : this.selections.get(size - 1);
        if (extra) {
            this.checkSelections();
            this.updateHighlights();
            this.fireListenerEvent();
        }
    }

    MultiSelection select(Selection selection) {
        ++this.selChangeId;
        MultiSelection multiSelection = new MultiSelection(this.editor.getTextBuffer(), selection.getDot(), selection.getMark());
        this.selections.add(multiSelection);
        this.latestSelection = multiSelection;
        this.checkSelections();
        this.updateHighlights();
        this.fireListenerEvent();
        return multiSelection;
    }

    void updateHighlights() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        }
        this.highlightLayer.removeAllHighlights();
        for (Selection selection : this.selections) {
            this.highlightLayer.addHighlight(SELECTION_STYLE, selection.getStart(), selection.getEnd());
        }
    }

    List<Selection> getSelections() {
        if (this.editor == null) {
            return Collections.emptyList();
        }
        try {
            if (this.externalSelChangeId != this.selChangeId || this.bufferChangeId != (long)this.editor.getTextBuffer().getChangeId()) {
                this.externalSelChangeId = this.selChangeId;
                this.bufferChangeId = this.editor.getTextBuffer().getChangeId();
                this.externalSelections = new ArrayList<Selection>();
                for (MultiSelection mSel : this.selections) {
                    this.externalSelections.add(new Selection(mSel.getDot(), mSel.getMark()));
                }
            }
            return Collections.unmodifiableList(this.externalSelections);
        }
        catch (ExpiredTextBufferException ex) {
            return Collections.emptyList();
        }
    }

    MultiSelection getLatestSelection() {
        return this.latestSelection;
    }

    List<MultiSelection> getMultiSelections() {
        return this.selections;
    }

    void adjustSelection(MultiSelection selection, int offset, boolean isMove) {
        ++this.externalSelChangeId;
        Document document = this.editor.getDocument();
        if (document == null) {
            return;
        }
        offset = Math.min(offset, document.getLength());
        offset = Math.max(offset, 0);
        if (isMove) {
            selection.setDot(offset);
        } else {
            selection.setDot(offset);
            selection.setMark(offset);
        }
        this.checkSelections();
        this.updateHighlights();
        this.fireListenerEvent();
    }

    void checkSelections() {
        ++this.selChangeId;
        if (this.isAdjusting || this.selections.size() == 0) {
            return;
        }
        Collections.sort(this.selections);
        ArrayList<MultiSelection> removeSelections = new ArrayList<MultiSelection>();
        MultiSelection previousSelection = null;
        for (MultiSelection selection : this.selections) {
            if (previousSelection != null) {
                if (selection.getStart() < previousSelection.getEnd()) {
                    if (previousSelection.getDot() < previousSelection.getMark()) {
                        previousSelection.setMark(Math.max(selection.getEnd(), previousSelection.getEnd()));
                    } else {
                        previousSelection.setDot(Math.max(selection.getEnd(), previousSelection.getEnd()));
                    }
                    removeSelections.add(selection);
                    continue;
                }
                if (selection.getStart() == previousSelection.getStart() && selection.getEnd() == previousSelection.getEnd()) {
                    removeSelections.add(selection);
                    continue;
                }
            }
            previousSelection = selection;
        }
        int start = this.editor.getSelectionStart();
        int end = this.editor.getSelectionEnd();
        for (MultiSelection selection : this.selections) {
            if (removeSelections.contains(selection)) continue;
            if (selection.getStart() == start && selection.getEnd() == end) {
                removeSelections.add(selection);
                continue;
            }
            if (selection.getStart() >= start && selection.getStart() < end) {
                removeSelections.add(selection);
                end = Math.max(end, selection.getEnd());
                continue;
            }
            if (selection.getStart() > start || selection.getEnd() <= start) continue;
            removeSelections.add(selection);
            start = Math.min(start, selection.getStart());
            end = Math.max(end, selection.getEnd());
        }
        int oldDot = this.editor.getCaret().getDot();
        int oldMark = this.editor.getCaret().getMark();
        if (start != oldMark || end != oldMark) {
            if (oldDot < oldMark) {
                if (oldDot != start || oldMark != end) {
                    this.editor.getCaret().setDot(end);
                    this.editor.getCaret().moveDot(start);
                }
            } else if (oldDot != end || oldMark != start) {
                this.editor.getCaret().setDot(start);
                this.editor.getCaret().moveDot(end);
            }
        }
        if (!removeSelections.isEmpty()) {
            for (MultiSelection selection : removeSelections) {
                this.selections.remove(selection);
                if (selection == this.latestSelection) {
                    this.latestSelection = null;
                }
                selection.dispose();
            }
            this.updateHighlights();
        }
    }

    void setIsAdjusting(boolean isAdjusting) {
        this.isAdjusting = isAdjusting;
        if (!isAdjusting) {
            this.checkSelections();
        }
    }

    boolean isIsAdjusting() {
        return this.isAdjusting;
    }

    static {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        SELECTION_STYLE = registry.lookupStyle("highlight-selection");
    }

    private class ActionHookI
    implements ActionHookInvoker {
        private ActionHookI() {
        }

        @Override
        public boolean invokeAction(String actionKey) {
            if (actionKey.equals("cancel")) {
                MultiSelectionSupport.this.clear();
            }
            return false;
        }
    }

    static final class MultiSelection
    extends Selection {
        private OffsetMark dot;
        private OffsetMark mark;
        private TextBuffer textBuffer;
        private Point magicPosition = null;
        private boolean disposed = false;

        MultiSelection(TextBuffer textBuffer, int dot, int mark) {
            super(dot, mark);
            assert (dot >= 0);
            assert (mark >= 0);
            this.textBuffer = textBuffer;
            this.dot = textBuffer.addOffsetMark(dot);
            this.mark = textBuffer.addOffsetMark(mark);
        }

        void dispose() {
            this.disposed = true;
            this.textBuffer.removeOffsetMark(this.dot);
            this.textBuffer.removeOffsetMark(this.mark);
        }

        protected void finalize() throws Throwable {
            if (!this.disposed) {
                Logger.getLogger("global").log(Level.SEVERE, "MultiSelection Not Disposed!");
            }
            super.finalize();
        }

        @Override
        public int getDot() {
            return this.dot.getOffset();
        }

        @Override
        public int getMark() {
            return this.mark.getOffset();
        }

        private void setDot(int dot) {
            this.textBuffer.removeOffsetMark(this.dot);
            this.dot = this.textBuffer.addOffsetMark(dot);
            this.magicPosition = null;
        }

        private void setMark(int mark) {
            this.textBuffer.removeOffsetMark(this.mark);
            this.mark = this.textBuffer.addOffsetMark(mark);
        }

        void setMagicPosition(Point magicPosition) {
            this.magicPosition = magicPosition;
        }

        Point getMagicPosition() {
            return this.magicPosition;
        }
    }
}

