/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EditorSelection;
import oracle.javatools.editor.MultiSelectionSupport;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;

public final class EditorSelectionWrap
implements EditorSelection {
    private BasicEditorPane _editor;
    private HighlightedText _highlightedText;

    @Override
    public int getMark() {
        Caret caret = this._editor.getCaret();
        return Math.min(caret.getDot(), caret.getMark());
    }

    @Override
    public int getDot() {
        Caret caret = this._editor.getCaret();
        return Math.max(caret.getDot(), caret.getMark());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSelectedText() {
        String txt;
        block5: {
            txt = null;
            BasicDocument doc = (BasicDocument)this._editor.getDocument();
            doc.readLock();
            try {
                int p0 = this.getMark();
                int p1 = this.getDot();
                if (p0 == p1) break block5;
                try {
                    txt = doc.getText(p0, p1 - p0);
                }
                catch (BadLocationException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            finally {
                doc.readUnlock();
            }
        }
        return txt;
    }

    @Override
    public void updateSelectionHighlight(HighlightLayer layer, HighlightStyle caretStyle) {
        int end;
        if (this._editor == null) {
            this.clearSelectionHighlights(layer);
            return;
        }
        int start = this.getMark();
        if (start == (end = this.getDot()) && layer != null) {
            this.clearSelectionHighlights(layer);
        }
        if (start != end) {
            if (this._highlightedText != null) {
                layer.changeHighlight(this._highlightedText, caretStyle, start, end);
            } else {
                this._highlightedText = layer.addHighlight(caretStyle, start, end);
            }
        }
    }

    @Override
    public void install(BasicEditorPane editor) {
        if (this._editor == null) {
            this._editor = editor;
        }
    }

    @Override
    public void deinstall() {
        this._editor = null;
    }

    @Override
    public void setMarkPoint(Point p) {
    }

    @Override
    public void setDotPoint(Point p) {
    }

    @Override
    public void clearSelectionHighlights(HighlightLayer selectionLayer) {
        selectionLayer.removeHighlight(this._highlightedText);
        this._highlightedText = null;
    }

    @Override
    public void deleteSelection() throws BadLocationException {
        int selectStart = this._editor.getSelectionStart();
        int selectEnd = this._editor.getSelectionEnd();
        Document document = this._editor.getDocument();
        document.remove(selectStart, selectEnd - selectStart);
    }

    @Override
    public void insertText(int offset, String text) throws BadLocationException {
        this._editor.getDocument().insertString(offset, text, null);
    }

    @Override
    public boolean isInSelection(int offset) {
        int selectStart = this._editor.getSelectionStart();
        int selectEnd = this._editor.getSelectionEnd();
        boolean inSelection = selectStart <= offset && offset <= selectEnd;
        return inSelection;
    }

    @Override
    public void selectAll() {
        Document doc = this._editor.getDocument();
        if (doc != null) {
            this._editor.setCaretPosition(0);
            this._editor.moveCaretPosition(doc.getLength());
        }
    }

    @Override
    public boolean canSupportEditor(BasicEditorPane editorPane) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void mouseDraggedDoubleClick(int offset, BasicEditorPane editor) {
        BasicCaret caret = (BasicCaret)editor.getCaret();
        int lastClickOffset = caret.getLastClickOffset();
        Boolean b = EditorProperties.getProperties().getBooleanProperty("word-boundary-use-case");
        try {
            EditorProperties.getProperties().putBooleanProperty("word-boundary-use-case", Boolean.FALSE);
            BasicDocument document = (BasicDocument)editor.getDocument();
            offset = Math.max(0, offset);
            offset = Math.min(offset, document.getLength());
            int leftBoundary = Math.min(offset, lastClickOffset);
            int rightBoundary = Math.max(offset, lastClickOffset);
            int leftOffset = Utilities.getWordStart(document, leftBoundary);
            int rightOffset = Utilities.getWordEnd(document, rightBoundary);
            boolean draggingForward = offset > lastClickOffset;
            int dragStart = draggingForward ? leftOffset : rightOffset;
            int dragEnd = draggingForward ? rightOffset : leftOffset;
            caret.setDot(dragStart);
            caret.moveDot(dragEnd);
        }
        finally {
            EditorProperties.getProperties().putBooleanProperty("word-boundary-use-case", b);
        }
    }

    @Override
    public void mouseDragged(Point point, int offset) {
        BasicCaret caret = (BasicCaret)this._editor.getCaret();
        int lastClickOffset = caret.getLastClickOffset();
        if (caret.getLastClickCount() == 2) {
            EditorSelectionWrap.mouseDraggedDoubleClick(offset, this._editor);
        } else if (caret.getLastClickCount() == 3) {
            int rightOffset;
            int leftOffset;
            BasicDocument document = (BasicDocument)this._editor.getDocument();
            offset = Math.max(0, offset);
            offset = Math.min(offset, document.getLength());
            int leftBoundary = Math.min(offset, lastClickOffset);
            int rightBoundary = Math.max(offset, lastClickOffset);
            try {
                Rectangle leftRect = this._editor.modelToView(leftBoundary);
                Point leftPoint = new Point(0, leftRect.y);
                leftOffset = this._editor.viewToModel(leftPoint);
                Rectangle rightRect = this._editor.modelToView(rightBoundary);
                Point rightPoint = new Point(0, rightRect.y + caret.getFontHeight());
                rightOffset = this._editor.viewToModel(rightPoint);
            }
            catch (BadLocationException e) {
                leftOffset = leftBoundary;
                rightOffset = rightBoundary;
            }
            boolean draggingForward = offset > lastClickOffset;
            int dragStart = draggingForward ? leftOffset : rightOffset;
            int dragEnd = draggingForward ? rightOffset : leftOffset;
            caret.setDot(dragStart);
            caret.moveDot(dragEnd);
        } else {
            MultiSelectionSupport multiSelectionSupport = this._editor.getMultiSelectionSupport();
            MultiSelectionSupport.MultiSelection latestSelection = multiSelectionSupport.getLatestSelection();
            if (latestSelection != null) {
                multiSelectionSupport.adjustSelection(latestSelection, offset, true);
            } else {
                caret.moveDot(offset);
            }
            this.setDotPoint(point);
            caret.updateHighlight();
        }
        this._editor.getMultiSelectionSupport().checkSelections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void duplicate() {
        Toolkit toolkit = this._editor.getToolkit();
        if (this._editor.isEditable() && this._editor.isEnabled()) {
            BasicDocument document = (BasicDocument)this._editor.getDocument();
            document.readLock();
            try {
                boolean inEdit = false;
                List<MultiSelectionSupport.MultiSelection> sels = this._editor.getMultiSelectionSupport().getMultiSelections();
                int start = this._editor.getSelectionStart();
                int end = this._editor.getSelectionEnd();
                if (start == end && this._editor.isCutCopyLineEnabled() && sels.isEmpty()) {
                    int currentLine = this._editor.getLineFromOffset(this._editor.getCaretPosition());
                    start = this._editor.getLineStartOffset(currentLine);
                    end = this._editor.getLineEndOffset(currentLine);
                }
                if (start != end) {
                    if (!inEdit) {
                        this._editor.beginEdit(BasicEditorPane.duplicateDescriptor);
                    }
                    inEdit = true;
                    String data = document.getText(start, end - start);
                    document.insertString(end, data, null);
                    this._editor.select(end, end + (end - start));
                }
                for (int i = sels.size() - 1; i >= 0; --i) {
                    MultiSelectionSupport.MultiSelection sel = sels.get(i);
                    start = sel.getStart();
                    if (start == (end = sel.getEnd())) continue;
                    if (!inEdit) {
                        this._editor.beginEdit(BasicEditorPane.duplicateDescriptor);
                    }
                    inEdit = true;
                    String data = document.getText(start, end - start);
                    document.insertString(end, data, null);
                    this._editor.getMultiSelectionSupport().adjustSelection(sel, end, false);
                    this._editor.getMultiSelectionSupport().adjustSelection(sel, end + (end - start), true);
                }
                if (!inEdit) return;
                this._editor.endEdit();
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            finally {
                document.readUnlock();
            }
        } else {
            toolkit.beep();
        }
    }
}

