/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.ActionPostInvoker;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPainter;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.ColumnSelectionPainter;
import oracle.javatools.editor.EditorSelection;
import oracle.javatools.editor.EditorSelectionWrap;
import oracle.javatools.editor.MultiSelectionSupport;
import oracle.javatools.editor.Selection;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.util.Pair;

public final class EditorSelectionColumns
implements EditorSelection {
    private BasicEditorPane _editor;
    private Point _markPoint;
    private Point _dotPoint;
    private int _markColumn = -1;
    private int _dotColumn = -1;
    private int _markLine = -1;
    private int _dotLine = -1;
    private final BasicEditorPainter _painter = new ColumnSelectionPainter(this);
    private final ActionHandler _actionHandler = new ActionHandler();
    private boolean _isAdjusting = false;

    @Override
    public int getMark() {
        Caret caret = this._editor.getCaret();
        return Math.min(caret.getDot(), caret.getMark());
    }

    @Override
    public int getDot() {
        Caret caret = this._editor.getCaret();
        return Math.max(caret.getDot(), caret.getMark());
    }

    @Override
    public String getSelectedText() {
        BasicDocument document = (BasicDocument)this._editor.getDocument();
        if (this._markColumn == this._dotColumn) {
            return null;
        }
        try {
            StringJoiner sj = new StringJoiner("\n");
            List<Selection> sels = this._editor.getMultiSelections();
            if (sels.isEmpty() || this._editor.getCaretPosition() < sels.get(0).getStart()) {
                sj.add(document.getText(this._editor.getSelectionStart(), this._editor.getSelectionEnd() - this._editor.getSelectionStart()));
            }
            for (Selection sel : sels) {
                String s = document.getText(sel.getStart(), sel.getEnd() - sel.getStart());
                sj.add(s);
            }
            if (!sels.isEmpty() && this._editor.getCaretPosition() > sels.get(0).getStart()) {
                sj.add(document.getText(this._editor.getSelectionStart(), this._editor.getSelectionEnd() - this._editor.getSelectionStart()));
            }
            String text = sj.toString();
            return text;
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy() {
        BasicDocument document = (BasicDocument)this._editor.getDocument();
        document.readLock();
        try {
            String data;
            int start = this.getMark();
            int end = this.getDot();
            if (start != end && (data = this.getSelectedText()) != null) {
                this._editor.setClipboardContents(data.toString());
            }
        }
        finally {
            document.readUnlock();
        }
    }

    public void cut() {
        this._editor.makeEditable();
        if (!this._editor.isEditable()) {
            this._editor.getToolkit().beep();
            return;
        }
        this.copy();
        this._editor.beginEdit(BasicEditorPane.cutDescriptor);
        try {
            this.deleteSelection();
        }
        catch (BadLocationException e) {
            this._editor.getToolkit().beep();
        }
        this._editor.endEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSelection() throws BadLocationException {
        this._editor.makeEditable();
        if (!this._editor.isEditable()) {
            this._editor.getToolkit().beep();
            return;
        }
        BasicDocument document = (BasicDocument)this._editor.getDocument();
        int startLine = Math.min(this._dotLine, this._markLine);
        int endLine = Math.max(this._dotLine, this._markLine);
        int lines = endLine - startLine + 1;
        this._editor.beginEdit(BasicEditorPane.deletePrevDescriptor);
        try {
            for (int line = startLine + lines - 1; line >= startLine; --line) {
                Pair<Integer, Integer> offsets = this._getSelectedLineOffsets(line);
                if (offsets == null || offsets.first == offsets.second) continue;
                document.remove((Integer)offsets.first, (Integer)offsets.second - (Integer)offsets.first);
            }
            this.setDotPoint(this._markPoint);
        }
        finally {
            this._editor.endEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paste() {
        this._editor.makeEditable();
        if (!this._editor.isEditable()) {
            this._editor.getToolkit().beep();
            return;
        }
        int start = this.getMark();
        int end = this.getDot();
        int startLine = this._editor.getLineFromOffset(start);
        int startColumn = start - this._editor.getLineStartOffset(startLine);
        this._editor.beginEdit(BasicEditorPane.pasteDescriptor);
        DefaultCaret caret = (DefaultCaret)this._editor.getCaret();
        int updatePolicy = caret.getUpdatePolicy();
        caret.setUpdatePolicy(1);
        try {
            try {
                BasicDocument document = (BasicDocument)this._editor.getDocument();
                if (start != end) {
                    int endLine = this._editor.getLineFromOffset(end);
                    int lines = endLine - startLine + 1;
                    for (int line = startLine; line < startLine + lines; ++line) {
                        Pair<Integer, Integer> offsets = this._getSelectedLineOffsets(line);
                        if (offsets == null) continue;
                        document.remove((Integer)offsets.first, (Integer)offsets.second - (Integer)offsets.first);
                    }
                }
                end = this.pasteFromClipboard(startLine, startColumn);
                this._editor.setCaretPosition(start);
            }
            catch (BadLocationException e) {
                this._editor.getToolkit().beep();
            }
        }
        finally {
            caret.setUpdatePolicy(updatePolicy);
            this._editor.endEdit();
        }
    }

    private int pasteFromClipboard(int insertAtLine, int startColumn) {
        Transferable transferable;
        Toolkit toolkit = this._editor.getToolkit();
        Clipboard clipboard = BasicEditorPane.getClipboard();
        if (clipboard != null && this._editor.isEditable() && this._editor.isEnabled() && (transferable = clipboard.getContents(this)) != null) {
            try {
                Object data = transferable.getTransferData(DataFlavor.stringFlavor);
                String stringData = (String)data;
                return this._insertText(insertAtLine, startColumn, stringData);
            }
            catch (Exception e) {
                toolkit.beep();
            }
        }
        return -1;
    }

    private int _insertText(int insertAtLine, int startColumn, String stringData) throws IOException, BadLocationException {
        int finalOffset = this._editor.getLineStartOffset(insertAtLine) + startColumn;
        if (stringData != null && stringData.length() > 0) {
            String[] lines = stringData.split("\n");
            int linesToAdd = insertAtLine + lines.length - this._editor.getLineCount();
            StringBuffer addition = new StringBuffer();
            for (int addLine = 0; addLine < linesToAdd; ++addLine) {
                addition.append("\n");
            }
            if (addition.length() > 0) {
                int lastOffset = this._editor.getDocument().getLength();
                this._editor.getDocument().insertString(lastOffset, addition.toString(), null);
            }
            for (int n = 0; n < lines.length; ++n) {
                int line = insertAtLine + n;
                int lineStart = this._editor.getLineStartOffset(line);
                int lineEnd = this._editor.getLineEndOffset(line);
                if (line == this._editor.getLineCount() - 1) {
                    ++lineEnd;
                }
                String lineString = lines[n];
                int offset = lineStart + startColumn;
                if (offset >= lineEnd) {
                    for (int i = 0; i <= offset - lineEnd; ++i) {
                        lineString = " " + lineString;
                    }
                    offset = lineEnd - 1;
                }
                offset = Math.min(offset, this._editor.getDocument().getLength());
                offset = Math.max(offset, 0);
                this._editor.getDocument().insertString(offset, lineString, null);
                finalOffset = offset + lineString.length();
            }
        }
        return finalOffset;
    }

    private int getLineEndOffset(int line) {
        int lineEnd = this._editor.getLineEndOffset(line);
        if (line != this._editor.getLineCount() - 1) {
            --lineEnd;
        }
        return lineEnd;
    }

    private Pair<Integer, Integer> _getSelectedLineOffsets(int line) {
        if (this._markColumn == -1 || this._dotColumn == -1) {
            return null;
        }
        int lineStart = this._editor.getLineStartOffset(line);
        int lineEnd = this.getLineEndOffset(line);
        int startOffset = Math.min(lineEnd, lineStart + this._markColumn);
        int endOffset = Math.min(lineEnd, lineStart + this._dotColumn);
        return new Pair<Integer, Integer>(Math.min(startOffset, endOffset), Math.max(startOffset, endOffset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSelectionHighlight(HighlightLayer layer, HighlightStyle caretStyle) {
        if (this._editor == null) {
            this.clearSelectionHighlights(layer);
            return;
        }
        int start = this.getMark();
        int end = this.getDot();
        if (layer != null) {
            layer.removeAllHighlights();
        }
        if (start != end) {
            layer.beginBlockUpdate();
            this._isAdjusting = true;
            try {
                int line = this._editor.getLineFromOffset(start);
                int startColumn = this._dotColumn;
                int endColumn = this._markColumn;
                if (endColumn < startColumn) {
                    int temp = startColumn;
                    startColumn = endColumn;
                    endColumn = temp;
                }
                int startLineOffset = this._editor.getLineStartOffset(line);
                int endLineOffset = this.getLineEndOffset(line);
                int startOffset = Math.min(endLineOffset, startLineOffset + startColumn);
                int endOffset = Math.min(endLineOffset, startLineOffset + endColumn);
                layer.addHighlight(caretStyle, startOffset, endOffset);
            }
            finally {
                layer.endBlockUpdate();
                this._isAdjusting = false;
            }
        }
    }

    @Override
    public void install(BasicEditorPane editor) {
        if (this._editor == null) {
            this._editor = editor;
            this._editor.addActionHookInvoker(this._actionHandler);
            this._editor.addActionPostInvoker(this._actionHandler);
            this._editor.registerPainter(this._painter);
        }
    }

    @Override
    public void deinstall() {
        if (this._editor != null) {
            this._editor.removeActionHookInvoker(this._actionHandler);
            this._editor.removeActionPostInvoker(this._actionHandler);
            this._editor.unregisterPainter(this._painter);
        }
        this._editor = null;
    }

    Point getDotPoint() {
        return this._dotPoint;
    }

    Point getMarkPoint() {
        return this._markPoint;
    }

    @Override
    public void setMarkPoint(Point p) {
        if (this._isAdjusting) {
            return;
        }
        this._markPoint = (Point)p.clone();
        this._markPoint.x = Math.max(0, this._markPoint.x);
        this._markPoint.x = Math.min(this._editor.getWidth(), this._markPoint.x);
        this._markPoint.y = Math.max(0, this._markPoint.y);
        this._markPoint.y = Math.min(this._editor.getHeight(), this._markPoint.y);
        this.update();
    }

    @Override
    public void setDotPoint(Point p) {
        if (this._isAdjusting) {
            return;
        }
        this._dotPoint = (Point)p.clone();
        this._dotPoint.x = Math.max(0, this._dotPoint.x);
        this._dotPoint.x = Math.min(this._editor.getWidth(), this._dotPoint.x);
        this._dotPoint.y = Math.max(0, this._dotPoint.y);
        this._dotPoint.y = Math.min(this._editor.getHeight(), this._dotPoint.y);
        this.update();
    }

    @Override
    public int determineSetDot(int dot) {
        return dot;
    }

    private void dump() {
    }

    @Override
    public Selection determineMoveDot(int dot, int mark) {
        this._editor.getMultiSelectionSupport().clear();
        int dotLine = this._editor.getLineFromOffset(dot);
        int lineStart = this._editor.getLineStartOffset(dotLine);
        int lineEnd = this._editor.getLineEndOffset(dotLine);
        mark = Math.min(lineStart + this._markColumn, lineEnd);
        for (int line = Math.min(dotLine, this._markLine); line <= Math.max(dotLine, this._markLine); ++line) {
            int startLineOffset = this._editor.getLineStartOffset(line);
            int endLineOffset = this.getLineEndOffset(line);
            int multiMark = Math.min(endLineOffset, startLineOffset + this._markColumn);
            int multiDot = Math.min(endLineOffset, startLineOffset + this._dotColumn);
            if (line == dotLine) continue;
            this._editor.getMultiSelectionSupport().select(Collections.singletonList(new Selection(multiDot, multiMark)), false);
        }
        this._editor.getMultiSelectionSupport().updateHighlights();
        return new Selection(dot, mark);
    }

    void update() {
        if (this._markPoint == null || this._dotPoint == null) {
            return;
        }
        int start = this._editor.viewToModel(this._markPoint);
        int end = this._editor.viewToModel(this._dotPoint);
        int startLine = this._editor.getLineFromOffset(start);
        int endLine = this._editor.getLineFromOffset(end);
        int charWidth = this.getColumnWidth();
        int startColumn = this._markPoint.x / charWidth;
        int endColumn = this._dotPoint.x / charWidth;
        this._markColumn = startColumn;
        this._dotColumn = endColumn;
        this._markLine = startLine;
        this._dotLine = endLine;
        this.dump();
    }

    @Override
    public void clearSelectionHighlights(HighlightLayer selectionLayer) {
        selectionLayer.removeAllHighlights();
        this._markColumn = -1;
        this._dotColumn = -1;
        this._markLine = -1;
        this._dotLine = -1;
    }

    @Override
    public void insertText(int offset, String text) throws BadLocationException {
        this._editor.makeEditable();
        if (!this._editor.isEditable()) {
            this._editor.getToolkit().beep();
            return;
        }
        int startLine = this._editor.getLineFromOffset(offset);
        int column = offset - this._editor.getLineStartOffset(startLine);
        try {
            this._insertText(startLine, column, text);
            Point newDot = this._editor.modelToView(this._editor.getCaretPosition()).getLocation();
            this.setDotPoint(newDot);
        }
        catch (IOException e) {
            this._editor.getToolkit().beep();
        }
    }

    @Override
    public boolean isInSelection(int offset) {
        if (this.getMark() == this.getDot()) {
            return false;
        }
        int selStartLine = this._editor.getLineFromOffset(this.getMark());
        int selEndLine = this._editor.getLineFromOffset(this.getDot());
        int thisLine = this._editor.getLineFromOffset(offset);
        if (thisLine < selStartLine || thisLine > selEndLine) {
            return false;
        }
        Pair<Integer, Integer> lineOffsets = this._getSelectedLineOffsets(thisLine);
        if (lineOffsets == null) {
            return false;
        }
        return offset >= (Integer)lineOffsets.first && offset <= (Integer)lineOffsets.second;
    }

    @Override
    public void selectAll() {
        int endOffset = this._editor.getTextBuffer().getLength();
        int longestLineLength = 0;
        for (int i = 0; i < this._editor.getLineCount(); ++i) {
            longestLineLength = Math.max(longestLineLength, this._editor.getLineLength(i));
        }
        int x = (longestLineLength - 1) * this.getColumnWidth();
        this.adjustSelection(new Point(x, this._editor.getSize().height), new Point(0, 0), endOffset, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustSelection(Point dotPoint, Point markPoint, int dot, int mark) {
        this.setMarkPoint(markPoint);
        this.setDotPoint(dotPoint);
        this._isAdjusting = true;
        try {
            BasicCaret caret = (BasicCaret)this._editor.getCaret();
            caret.setDot(mark);
            caret.moveDot(dot);
            caret.updateHighlight();
            this.repaintSelection(this._dotPoint, this._markPoint);
        }
        finally {
            this._isAdjusting = false;
        }
    }

    @Override
    public boolean canSupportEditor(BasicEditorPane editorPane) {
        return EditorSelectionColumns.isEditorFixedWidthFont(editorPane);
    }

    int getColumnWidth() {
        FontMetrics fm = this._editor.getFontMetrics(this._editor.getFont());
        return fm.charWidth(' ');
    }

    public static boolean isEditorFixedWidthFont(BasicEditorPane editorPane) {
        FontMetrics fm = editorPane.getFontMetrics(editorPane.getFont());
        return fm.charWidth('.') == fm.charWidth('W');
    }

    int getMarkColumn() {
        return this._markColumn;
    }

    int getDotColumn() {
        return this._dotColumn;
    }

    int getMarkLine() {
        return this._markLine;
    }

    int getDotLine() {
        return this._dotLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(Point point, int offset) {
        BasicCaret caret = (BasicCaret)this._editor.getCaret();
        if (caret.getLastClickCount() == 3) {
            this._markPoint.x = 0;
            int start = this._editor.viewToModel(this._markPoint);
            int end = this._editor.viewToModel(this._dotPoint);
            int startLine = this._editor.getLineFromOffset(Math.min(start, end));
            int endLine = this._editor.getLineFromOffset(Math.max(start, end));
            int longestLineLength = 0;
            for (int i = startLine; i <= endLine; ++i) {
                longestLineLength = Math.max(longestLineLength, this._editor.getLineLength(i));
            }
            int x = (longestLineLength - 1) * this.getColumnWidth();
            point.x = Math.max(x, point.x);
            this.setDotPoint(point);
            this._isAdjusting = true;
            try {
                caret.moveDot(offset);
                caret.updateHighlight();
            }
            finally {
                this._isAdjusting = false;
            }
        }
        if (caret.getLastClickCount() == 2) {
            EditorSelectionWrap.mouseDraggedDoubleClick(offset, this._editor);
        } else {
            this.setDotPoint(point);
            this._isAdjusting = true;
            try {
                caret.moveDot(offset);
                caret.updateHighlight();
            }
            finally {
                this._isAdjusting = false;
            }
        }
        this._editor.getMultiSelectionSupport().checkSelections();
        this.repaintSelection(this._dotPoint, this._markPoint);
    }

    private void repaintSelection(Point p1, Point p2) {
        int lineH = this._editor.getFontMetrics(this._editor.getFont()).getHeight();
        int x = Math.min(p1.x, p2.x);
        int y = Math.min(p1.y, p2.y);
        int w = p1.x < p2.x ? p2.x - p1.x : p1.x - p2.x;
        int h = p1.y < p2.y ? p2.y - p1.y : p1.y - p2.y;
        this._editor.repaint(x, y, w, h + lineH);
    }

    void setAdjusting(boolean _isAdjusting) {
        this._isAdjusting = _isAdjusting;
    }

    boolean isAdjusting() {
        return this._isAdjusting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void duplicate() {
        Toolkit toolkit = this._editor.getToolkit();
        List<MultiSelectionSupport.MultiSelection> sels = this._editor.getMultiSelectionSupport().getMultiSelections();
        if (this._editor.isEditable() && this._editor.isEnabled() && sels.isEmpty()) {
            BasicDocument document = (BasicDocument)this._editor.getDocument();
            document.readLock();
            try {
                boolean isLineCopy = false;
                int start = this._editor.getSelectionStart();
                int end = this._editor.getSelectionEnd();
                if (start == end && this._editor.isCutCopyLineEnabled()) {
                    int currentLine = this._editor.getLineFromOffset(this._editor.getCaretPosition());
                    start = this._editor.getLineStartOffset(currentLine);
                    end = this._editor.getLineEndOffset(currentLine);
                    isLineCopy = true;
                }
                if (start == end) return;
                this._editor.beginEdit(BasicEditorPane.duplicateDescriptor);
                String data = document.getText(start, end - start);
                document.insertString(end, data, null);
                int length = end + (end - start);
                this._editor.select(end, isLineCopy ? length - 1 : length);
                this._editor.endEdit();
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            finally {
                document.readUnlock();
            }
        } else {
            toolkit.beep();
        }
    }

    private class ActionHandler
    implements ActionHookInvoker,
    ActionPostInvoker {
        private ActionHandler() {
        }

        @Override
        public boolean invokeAction(String actionKey) {
            if (actionKey.equals("cut-to-clipboard")) {
                EditorSelectionColumns.this.cut();
                return true;
            }
            if (actionKey.equals("copy-to-clipboard")) {
                EditorSelectionColumns.this.copy();
                return true;
            }
            if (actionKey.equals("delete-next") || actionKey.equals("delete-previous")) {
                if (!EditorSelectionColumns.this._editor.hasSelection()) {
                    return false;
                }
                try {
                    EditorSelectionColumns.this.deleteSelection();
                }
                catch (BadLocationException e) {
                    EditorSelectionColumns.this._editor.getToolkit().beep();
                }
                return true;
            }
            if (actionKey.equals("select-line")) {
                int lineStart;
                int pos = EditorSelectionColumns.this._editor.getCaretPosition();
                int line = EditorSelectionColumns.this._editor.getLineFromOffset(pos);
                int lineEnd = EditorSelectionColumns.this._editor.getLineEndOffset(line) - 1;
                if (lineEnd > (lineStart = EditorSelectionColumns.this._editor.getLineStartOffset(line))) {
                    EditorSelectionColumns.this._editor.select(lineStart, lineEnd);
                } else {
                    EditorSelectionColumns.this._editor.setCaretPosition(lineStart);
                }
                return true;
            }
            if (actionKey.equals("cancel")) {
                BasicCaret caret = (BasicCaret)EditorSelectionColumns.this._editor.getCaret();
                int mark = caret.getMark();
                int dot = caret.getDot();
                caret.setDot(mark);
                caret.moveDot(dot);
                return false;
            }
            if (actionKey.equals("selection-forward") || actionKey.equals("selection-backward")) {
                int pos = EditorSelectionColumns.this._editor.getCaretPosition();
                int line = EditorSelectionColumns.this._editor.getLineFromOffset(pos);
                int lineEnd = EditorSelectionColumns.this._editor.getLineEndOffset(line);
                int lineStart = EditorSelectionColumns.this._editor.getLineStartOffset(line);
                int charW = EditorSelectionColumns.this.getColumnWidth();
                Point oldDot = new Point(EditorSelectionColumns.this._dotPoint);
                int n = ((EditorSelectionColumns)EditorSelectionColumns.this)._dotPoint.x = actionKey.equals("selection-forward") ? ((EditorSelectionColumns)EditorSelectionColumns.this)._dotPoint.x + charW : ((EditorSelectionColumns)EditorSelectionColumns.this)._dotPoint.x - charW;
                if (((EditorSelectionColumns)EditorSelectionColumns.this)._dotPoint.x < 0) {
                    ((EditorSelectionColumns)EditorSelectionColumns.this)._dotPoint.x = 0;
                }
                EditorSelectionColumns.this.update();
                int newDot = Math.min(lineStart + EditorSelectionColumns.this._dotColumn, lineEnd - 1);
                EditorSelectionColumns.this._isAdjusting = true;
                ((BasicCaret)EditorSelectionColumns.this._editor.getCaret()).moveDot(newDot);
                EditorSelectionColumns.this.repaintSelection(EditorSelectionColumns.this._dotPoint, oldDot);
                EditorSelectionColumns.this.repaintSelection(EditorSelectionColumns.this._dotPoint, EditorSelectionColumns.this._markPoint);
                EditorSelectionColumns.this.dump();
                return true;
            }
            if (actionKey.equals("selection-down") || actionKey.equals("selection-up")) {
                int pos = EditorSelectionColumns.this._editor.getCaretPosition();
                int line = EditorSelectionColumns.this._editor.getLineFromOffset(pos);
                int n = line = actionKey.equals("selection-down") ? line + 1 : line - 1;
                if (line >= EditorSelectionColumns.this._editor.getLineCount() || line < 0) {
                    return true;
                }
                int lineEnd = EditorSelectionColumns.this._editor.getLineEndOffset(line);
                int lineStart = EditorSelectionColumns.this._editor.getLineStartOffset(line);
                try {
                    Rectangle lineEndR = EditorSelectionColumns.this._editor.modelToView(lineEnd);
                    Point oldDot = new Point(EditorSelectionColumns.this._dotPoint);
                    ((EditorSelectionColumns)EditorSelectionColumns.this)._dotPoint.y = actionKey.equals("selection-down") ? ((EditorSelectionColumns)EditorSelectionColumns.this)._dotPoint.y + lineEndR.height : ((EditorSelectionColumns)EditorSelectionColumns.this)._dotPoint.y - lineEndR.height;
                    EditorSelectionColumns.this.update();
                    int newDot = Math.min(lineStart + EditorSelectionColumns.this._dotColumn, lineEnd - 1);
                    EditorSelectionColumns.this._isAdjusting = true;
                    ((BasicCaret)EditorSelectionColumns.this._editor.getCaret()).moveDot(newDot);
                    EditorSelectionColumns.this.repaintSelection(EditorSelectionColumns.this._dotPoint, oldDot);
                    EditorSelectionColumns.this.repaintSelection(EditorSelectionColumns.this._dotPoint, EditorSelectionColumns.this._markPoint);
                    EditorSelectionColumns.this.dump();
                    return true;
                }
                catch (BadLocationException e) {
                    Logger.getLogger("global").log(Level.SEVERE, "Bad Location", e);
                }
            }
            return false;
        }

        @Override
        public void invokedAction(String actionKey) {
            EditorSelectionColumns.this._isAdjusting = false;
        }
    }
}

