/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferUtils;

public abstract class TransferDataInfo
implements Comparable {
    public static final Object METADATA_SHORT_DESCRIPTION = "shortDesc";
    public static final Object METADATA_MEDIUM_DESCRIPTION = "mediumDesc";
    public static final Object METADATA_LONG_DESCRIPTION = "longDesc";
    public static final Object METADATA_ICON = "icon";

    public abstract DataFlavor getDataFlavor();

    public abstract Object getData(FetchMode var1, boolean var2) throws IOException;

    public abstract float getSuitabilityRank();

    public Object getMetadata(Object key) {
        if (this.isDescriptionKey(key)) {
            return TransferUtils.inventDescription(this.getDataFlavor());
        }
        return null;
    }

    public final int compareTo(Object o) {
        TransferDataInfo other = (TransferDataInfo)o;
        float rankDiff = other.getSuitabilityRank() - this.getSuitabilityRank();
        if (rankDiff == 0.0f) {
            return 0;
        }
        if (rankDiff < 0.0f) {
            return -1;
        }
        return 1;
    }

    public final boolean isDescriptionKey(Object key) {
        return key == METADATA_SHORT_DESCRIPTION || key == METADATA_MEDIUM_DESCRIPTION || key == METADATA_LONG_DESCRIPTION;
    }

    protected TransferDataInfo() {
    }
}

