/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.completionfield;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import oracle.javatools.controls.completionfield.CompletionPopupHandler;
import oracle.javatools.controls.completionfield.CompletionTextComponent;
import oracle.javatools.editor.highlight.UnderlinePainter;
import oracle.javatools.editor.highlight.ZigZagLinePainter;

@Deprecated
public class CompletionTextField
extends JTextField
implements CompletionTextComponent {
    private static final int VALIDATION_TIMER_DELAY_MS = 500;
    private final CompletionPopupHandler _popupHandler;
    private final Timer _validationTimer = new Timer(500, new TimerListener());
    private boolean _textIsValid = true;
    private final UnderlinePainter _underlinePainter = new ZigZagLinePainter(2, 1);

    public CompletionTextField() {
        this._popupHandler = new CompletionPopupHandler(this);
        this.initializeValidation();
    }

    public CompletionTextField(CompletionPopupHandler popupHandler) {
        this._popupHandler = popupHandler;
        this.initializeValidation();
    }

    private void initializeValidation() {
        this._validationTimer.setRepeats(false);
        this.getDocument().addDocumentListener(new DocumentListener(){

            private void update() {
                CompletionTextField.this._validationTimer.restart();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }
        });
    }

    @Override
    public final CompletionPopupHandler getPopupHandler() {
        return this._popupHandler;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._popupHandler.setInsightVisible(false);
    }

    @Override
    public final void setText(String text) {
        this._popupHandler.acquireInsightLock();
        try {
            super.setText(text);
        }
        finally {
            this._popupHandler.yieldInsightLock();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isEnabled() && this.isEditable() && !this._textIsValid) {
            Insets insets = this.getInsets();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int[][] ranges = this.getInvalidCharacterRanges();
            for (int i = 0; i < ranges.length; ++i) {
                int end;
                int[] range = ranges[i];
                int start = range[0];
                if (start < 0 || start > this.getText().length() - 1 || (end = range[1]) < 0 || end < start || end > this.getText().length() - 1) continue;
                try {
                    Rectangle startRect = this.modelToView(start);
                    int left = startRect.x;
                    Rectangle endRect = this.modelToView(end + 1);
                    int width = endRect.x + endRect.width - startRect.x;
                    int yTop = insets.top;
                    int yBaseline = fm.getHeight();
                    int descent = fm.getDescent();
                    this._underlinePainter.paintUnderline(g, Color.RED, left, width, yTop, yBaseline, descent);
                    continue;
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }
    }

    protected int[][] getInvalidCharacterRanges() {
        return new int[][]{{0, this.getText().length() - 1}};
    }

    protected boolean isTextValid() {
        return true;
    }

    public final void setAlignWithField(boolean isAlignWithField) {
        this._popupHandler.setAlignWithField(isAlignWithField);
    }

    public final void setWidthOfField(boolean isWidthOfField) {
        this._popupHandler.setWidthOfField(isWidthOfField);
    }

    public final void setInsightVisible(boolean isVisible) {
        this._popupHandler.setInsightVisible(isVisible);
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            CompletionTextField.this._textIsValid = CompletionTextField.this.isTextValid();
            CompletionTextField.this.repaint();
        }
    }
}

