/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class WashedIcon
implements Icon {
    protected static final float DEFAULT_ALPHA = 0.5f;
    private final Icon _icon;
    private final AlphaComposite _composite;

    public WashedIcon(Icon icon) {
        this(icon, 0.5f);
    }

    public WashedIcon(Icon icon, float alpha) {
        assert (icon != null) : "icon must be specified";
        assert (alpha >= 0.0f && alpha <= 1.0f) : "alpha value out of range";
        this._icon = icon;
        this._composite = AlphaComposite.getInstance(3, alpha);
    }

    public Icon getIcon() {
        return this._icon;
    }

    public float getAlpha() {
        return this.getComposite().getAlpha();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.getIcon();
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        Graphics2D g2 = (Graphics2D)g.create(x, y, w, h);
        g2.setComposite(this.getComposite());
        icon.paintIcon(c, g2, 0, 0);
        g2.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.getIcon().getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getIcon().getIconHeight();
    }

    protected AlphaComposite getComposite() {
        return this._composite;
    }
}

