/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.concurrent;

import java.util.ArrayList;
import oracle.javatools.concurrent.Task;

final class Scheduler {
    private static final int DEFAULT_MAX_TOTAL_THREADS = 4;
    private static final Scheduler _INSTANCE = new Scheduler(4, 10000);
    private static final boolean DEBUG_VERBOSE = false;
    private ArrayList _taskList = new ArrayList();
    private int _threadCount = 0;
    private final ArrayList _threadList = new ArrayList();
    private int _threadId = 1;
    private final int _idleTimeout;
    private int _idleCount = 0;
    private int _maxThreads;

    private Scheduler(int maxThreads, int idleTimeout) {
        this._maxThreads = maxThreads;
        this._idleTimeout = idleTimeout;
    }

    static Scheduler getInstance() {
        return _INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Task task) {
        ArrayList arrayList = this._taskList;
        synchronized (arrayList) {
            Thread t;
            this._taskList.add(task);
            for (int i = this._threadCount - 1; i >= 0; --i) {
                t = (Thread)this._threadList.get(i);
                if (t.isAlive()) continue;
                this._threadList.remove(t);
                --this._threadCount;
            }
            if (this._idleCount > 0) {
                this._taskList.notify();
            } else if (this._threadCount < this._maxThreads) {
                TRunner r = new TRunner(this._threadId++);
                t = new Thread(r);
                t.setPriority(1);
                this._threadList.add(t);
                ++this._threadCount;
                t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelTask(Task task) {
        ArrayList arrayList = this._threadList;
        synchronized (arrayList) {
            this._threadList.remove(task);
        }
        task.cancel(null);
    }

    private class TRunner
    implements Runnable {
        private final int _threadId;

        TRunner(int threadId) {
            this._threadId = threadId;
        }

        private void printVerbose(String message) {
            String name = Thread.currentThread().getName();
            System.out.print("TRunner(" + name + ") ");
            System.out.println(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Task task = null;
                ArrayList arrayList = Scheduler.this._taskList;
                synchronized (arrayList) {
                    if (Scheduler.this._taskList.size() == 0) {
                        try {
                            Scheduler.this._idleCount++;
                            Scheduler.this._taskList.wait(Scheduler.this._idleTimeout);
                            Scheduler.this._idleCount--;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (Scheduler.this._taskList.size() == 0) {
                            Scheduler.this._threadCount--;
                            Scheduler.this._threadList.remove(Thread.currentThread());
                            return;
                        }
                    }
                    task = (Task)Scheduler.this._taskList.remove(0);
                }
                Thread.currentThread().setName("TaskThread-" + this._threadId + ": " + task.getName());
                task.run(null);
                Thread.currentThread().setName("TaskThread-" + this._threadId + ": idle");
            }
        }
    }
}

